/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class TrustAnchor {
    private java.security.cert.TrustAnchor ta;
    private byte[] nameConstraints;
    private X509Certificate trustedCert;
    private String caName;
    private PublicKey pubKey;

    TrustAnchor(java.security.cert.TrustAnchor trustAnchor) {
        this.ta = trustAnchor;
        this.nameConstraints = trustAnchor.getNameConstraints();
        this.caName = trustAnchor.getCAName();
        this.trustedCert = trustAnchor.getTrustedCert();
        this.pubKey = trustAnchor.getCAPublicKey();
    }

    public TrustAnchor(X509Certificate x509Certificate, byte[] byArray) throws IllegalArgumentException {
        if (x509Certificate == null) {
            throw new NullPointerException();
        }
        this.setNameConstraints(byArray);
        this.trustedCert = x509Certificate;
        this.caName = null;
        this.pubKey = null;
    }

    public TrustAnchor(String string, PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        if (string == null || publicKey == null) {
            throw new NullPointerException();
        }
        try {
            X500Name x500Name = new X500Name(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        this.setNameConstraints(byArray);
        this.caName = string;
        this.pubKey = publicKey;
        this.trustedCert = null;
    }

    public final X509Certificate getTrustedCert() {
        return this.trustedCert;
    }

    public final String getCAName() {
        return this.caName;
    }

    public final PublicKey getCAPublicKey() {
        return this.pubKey;
    }

    public final byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TrustAnchor: \n");
        if (this.trustedCert != null) {
            stringBuffer.append("\tTrusted certificate: " + this.trustedCert.toString());
        } else {
            stringBuffer.append("\tTrusted ca: " + this.caName);
            stringBuffer.append("\tTrusted ca public key: " + this.pubKey.toString());
        }
        if (this.nameConstraints != null) {
            try {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(Boolean.TRUE, (Object)this.nameConstraints);
                stringBuffer.append("\t" + nameConstraintsExtension.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private void setNameConstraints(byte[] byArray) throws IllegalArgumentException {
        if (byArray != null) {
            this.nameConstraints = (byte[])byArray.clone();
            try {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(Boolean.TRUE, (Object)this.nameConstraints);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else {
            this.nameConstraints = null;
        }
    }
}

