/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.zseries;

import com.ibm.jvm.zseries.Engine;
import com.ibm.jvm.zseries.RXInstruction;

public class BranchOnCondition
extends RXInstruction {
    BranchOnCondition(Engine engine, int n) {
        super(engine, n);
    }

    int jitd2() {
        if (this.word == 1206972417) {
            return 16;
        }
        return this.d2();
    }

    public int nextAddress(int n) {
        int n2 = this.engine.getRegister(15) + this.jitd2();
        if (!this.engine.foundStart && this.engine.r15PointsToEntry && this.b2() == 15 && this.x2() == 0 && this.jitd2() > 1 && n2 > n) {
            return n2;
        }
        return n + this.length();
    }

    public String mnemonic() {
        String string = null;
        switch (this.r1()) {
            case 1: {
                string = "BO ";
                break;
            }
            case 2: {
                string = "BGT";
                break;
            }
            case 3: {
                string = "BC ";
                break;
            }
            case 4: {
                string = "BLT";
                break;
            }
            case 5: {
                string = "BNZ";
                break;
            }
            case 7: {
                string = "BNE";
                break;
            }
            case 8: {
                string = "BEQ";
                break;
            }
            case 10: {
                string = "BZ ";
                break;
            }
            case 11: {
                string = "BGE";
                break;
            }
            case 12: {
                string = "BNC";
                break;
            }
            case 13: {
                string = "BLE";
                break;
            }
            case 14: {
                string = "BNO";
                break;
            }
            case 15: {
                string = "B  ";
                break;
            }
            default: {
                throw new Error("Unknown branch mask " + this.r1());
            }
        }
        return string + " ";
    }

    public String toString() {
        if (this.r1() == 0) {
            return "NOP";
        }
        String string = this.x2() == 0 ? "" : "$r" + this.x2() + ",";
        return this.mnemonic() + "   x'" + BranchOnCondition.hx(this.d2()) + "'(" + string + "$r" + this.b2() + ")";
    }
}

