/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util.html;

import com.ibm.jvm.util.html.Cell;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Table;
import java.util.ArrayList;
import java.util.Iterator;

public class Row
extends Element {
    protected Table table;
    protected ArrayList cells = new ArrayList();
    protected boolean isHeader;

    public Row() {
    }

    public Row(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addCell(stringArray[i]);
        }
    }

    public Row(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addCell("" + nArray[i]);
        }
    }

    public Row(boolean bl) {
        this.isHeader = bl;
    }

    public void setHeader(boolean bl) {
        this.isHeader = bl;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void addCell(Cell cell) {
        if (this.table != null) {
            this.table.addCellToColumn(cell, this.cells.size());
        }
        this.cells.add(cell);
    }

    public void addCell(String string) {
        Row.Assert(string != null);
        this.addCell(new Cell(string));
    }

    public void addCell(Element element) {
        this.addCell(new Cell(element));
    }

    public int size() {
        return this.cells.size();
    }

    public Cell cellAt(int n) {
        return (Cell)this.cells.get(n);
    }

    protected String toHtmlString() {
        String string = this.beautify("<tr>");
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            if (this.isHeader) {
                cell.setHeader(true);
            }
            string = string + cell.toHtmlString();
        }
        string = string + "</tr>";
        return this.beautify(string);
    }

    protected String toTextString() {
        int n;
        Cell cell;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            cell = (Cell)iterator.next();
            stringBuffer.append(cell.toTextString());
            for (n = 0; n < cell.column().width() - cell.width(); ++n) {
                stringBuffer.append(' ');
            }
            for (n = 0; n < this.table.columnGap(); ++n) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(Document.lineSeparator);
        if (this.isHeader) {
            iterator = this.cells.iterator();
            while (iterator.hasNext()) {
                cell = (Cell)iterator.next();
                for (n = 0; n < cell.width(); ++n) {
                    stringBuffer.append('-');
                }
                for (n = 0; n < cell.column().width() - cell.width(); ++n) {
                    stringBuffer.append(' ');
                }
                for (n = 0; n < this.table.columnGap(); ++n) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(Document.lineSeparator);
        }
        return stringBuffer.toString();
    }
}

