/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump.examples;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Page;
import com.ibm.jvm.svcdump.StackSegment;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.Enumeration;
import java.util.Vector;

public class FindStackRoots {
    public static void main(String[] stringArray) {
        IntHashtable intHashtable = new IntHashtable();
        Vector<Dsa> vector = new Vector<Dsa>();
        if (stringArray.length != 2) {
            System.out.println("Usage: java com.ibm.jvm.svcdump.examples.FindStackRoots <dumpname> <tcb id>");
            return;
        }
        try {
            int n;
            Object object;
            int n2 = SvcdumpProperties.parseInt(stringArray[1], 16);
            Dump dump = new Dump(stringArray[0]);
            AddressSpace addressSpace = dump.getDefaultAddressSpace();
            Tcb tcb = addressSpace.getTcb(n2);
            Tcb[] tcbArray = addressSpace.tcbs();
            for (int i = 0; i < tcbArray.length; ++i) {
                if (!tcbArray[i].isJava() || addressSpace.readInt(tcbArray[i].tid()) != tcb.tid()) continue;
                System.out.println("tid is present as someones forward pointer");
            }
            StackSegment[] stackSegmentArray = tcb.stackSegments();
            System.out.println("ok so far, found " + stackSegmentArray.length);
            for (int i = 0; i < stackSegmentArray.length; ++i) {
                object = stackSegmentArray[i];
                System.out.println("hunt for dsa from " + FindStackRoots.hex(((StackSegment)object).lower) + " to " + FindStackRoots.hex(((StackSegment)object).lower));
                for (int j = ((StackSegment)object).lower; j < ((StackSegment)object).upper; j += 4) {
                    try {
                        Object object2;
                        Dsa dsa = new Dsa(tcb, j, ((StackSegment)object).isDownStack);
                        n = dsa.prevCount();
                        if (n <= 3 || n >= 190) continue;
                        boolean bl = false;
                        for (object2 = dsa; object2 != null; object2 = ((Dsa)object2).previous()) {
                            if (((Dsa)object2).function().startsWith("(unknown")) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        object2 = null;
                        for (Dsa dsa2 = dsa; dsa2 != null && !FindStackRoots.outsideStack(stackSegmentArray, dsa2.address); dsa2 = dsa2.previous()) {
                            DsaNode dsaNode = (DsaNode)intHashtable.get(dsa2.address);
                            if (dsaNode == null) {
                                dsaNode = new DsaNode(dsa2);
                                intHashtable.put(dsa2.address, (Object)dsaNode);
                            }
                            if (object2 != null) {
                                DsaNode.link((DsaNode)object2, dsaNode);
                            }
                            object2 = dsaNode;
                        }
                        if (vector.contains(object2)) continue;
                        vector.add((Dsa)object2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Enumeration enumeration = addressSpace.getPages();
            while (enumeration.hasMoreElements()) {
                object = (Page)enumeration.nextElement();
                int[] nArray = ((Page)object).getIntArray();
                int n3 = 0;
                for (n = 0; n < nArray.length; ++n) {
                    int n4;
                    DsaNode dsaNode = (DsaNode)intHashtable.get(nArray[n]);
                    if (dsaNode == null || !FindStackRoots.outsideStack(stackSegmentArray, n4 = ((Page)object).getAddress() + n * 4)) continue;
                    dsaNode.addPointer(n4);
                    ++n3;
                }
            }
            for (int i = 0; i < vector.size(); ++i) {
                object = (DsaNode)vector.elementAt(i);
                ((DsaNode)object).print(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Oops: " + exception);
        }
    }

    static boolean outsideStack(StackSegment[] stackSegmentArray, int n) {
        for (int i = 0; i < stackSegmentArray.length; ++i) {
            if (!stackSegmentArray[i].contains(n)) continue;
            return false;
        }
        return true;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static class DsaNode {
        Dsa dsa;
        DsaNode parent;
        Vector children = new Vector();
        int[] pointers;

        DsaNode(Dsa dsa) {
            this.dsa = dsa;
        }

        static void link(DsaNode dsaNode, DsaNode dsaNode2) {
            dsaNode.parent = dsaNode2;
            if (!dsaNode2.children.contains(dsaNode)) {
                dsaNode2.children.add(dsaNode);
            }
        }

        void addPointer(int n) {
            if (this.pointers == null) {
                this.pointers = new int[1];
                this.pointers[0] = n;
            } else {
                int[] nArray = new int[this.pointers.length + 1];
                System.arraycopy(this.pointers, 0, nArray, 0, this.pointers.length);
                nArray[this.pointers.length] = n;
                this.pointers = nArray;
            }
        }

        void print(String string, int n) {
            for (int i = 0; i < n; ++i) {
                System.out.print("    ");
            }
            System.out.println(string);
        }

        void print(int n) {
            int n2;
            String string = FindStackRoots.hex(this.dsa.address) + " " + this.dsa.function();
            if (this.pointers != null) {
                string = string + " (pointed to by ";
                for (n2 = 0; n2 < this.pointers.length; ++n2) {
                    if (n2 != 0) {
                        string = string + ", ";
                    }
                    string = string + FindStackRoots.hex(this.pointers[n2]);
                }
                string = string + ")";
            }
            this.print(string, n);
            for (n2 = 0; n2 < this.children.size(); ++n2) {
                DsaNode dsaNode = (DsaNode)this.children.elementAt(n2);
                dsaNode.print(n + 1);
            }
        }
    }
}

