/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.Jvm;

public class HeapMethod
extends Base {
    Jvm jvm;
    int mb;
    AddressSpace space;
    HeapClass classclass;
    String fullname;
    String fullnameNoSig;

    HeapMethod(HeapClass heapClass, int n) {
        this.jvm = heapClass.jvm;
        this.mb = n;
        this.classclass = heapClass;
        this.space = this.jvm.space;
    }

    HeapMethod(Jvm jvm, int n) throws Exception {
        this.space = jvm.space;
        int n2 = this.space.readInt(n);
        this.classclass = jvm.getClass(n2);
        this.jvm = jvm;
        this.mb = n;
    }

    String fullname() throws Exception {
        if (this.fullname == null) {
            this.fullname = this.classclass + "." + this;
        }
        return this.fullname;
    }

    String fullnameNoSig() throws Exception {
        if (this.fullnameNoSig == null) {
            this.fullnameNoSig = this.classclass + "." + this.mbName();
        }
        return this.fullnameNoSig;
    }

    String mbName() throws Exception {
        int n = this.space.readInt(this.mb + 8);
        return this.space.readString(n);
    }

    String mbSignature() throws Exception {
        int n = this.space.readInt(this.mb + 4);
        return this.space.readString(n);
    }

    public String toString() {
        try {
            return this.mbName() + " " + this.mbSignature();
        }
        catch (Exception exception) {
            throw new Error("error getting mbName: " + exception);
        }
    }

    public int mbLocalVariableCount() throws Exception {
        return this.space.readUnsignedShort(this.mb + 68);
    }

    int mbByteCode() throws Exception {
        int n = CType.offsetof("methodblock", "code", 20);
        int n2 = this.space.readInt(this.mb + n);
        return n2;
    }

    int mbAccess() throws Exception {
        int n = CType.offsetof("methodblock", "member", 0);
        int n2 = CType.offsetof("MemberBlock", "access", 12);
        int n3 = this.space.readUnsignedShort(this.mb + n + n2);
        return n3;
    }

    boolean mbIsNative() throws Exception {
        return (this.mbAccess() & 0x100) != 0;
    }

    int pc2LineNumber(int n) throws Exception {
        int n2 = n - this.mbByteCode();
        LineNumberEntry[] lineNumberEntryArray = this.mbLineNumberTable();
        if (lineNumberEntryArray.length > 0) {
            int n3 = 0;
            int n4 = lineNumberEntryArray.length;
            if (n2 < lineNumberEntryArray[n3].pc) {
                throw new Exception("pc_offset " + n2 + " smaller than " + lineNumberEntryArray[n3].pc + " pc " + HeapMethod.hex(n));
            }
            if (n2 >= lineNumberEntryArray[n4 - 1].pc) {
                int n5 = lineNumberEntryArray[n4 - 1].line_number;
                return n5;
            }
            while (n3 < n4) {
                int n6 = n3 + n4 >> 1;
                if (n2 < lineNumberEntryArray[n6].pc) {
                    n4 = n6;
                    continue;
                }
                if (n2 >= lineNumberEntryArray[n6 + 1].pc) {
                    n3 = n6;
                    continue;
                }
                int n7 = lineNumberEntryArray[n6].line_number;
                return n7;
            }
            throw new Error("pc_offset " + n2 + " not found in line number table");
        }
        throw new Exception("no line number table found in " + this.fullname());
    }

    LineNumberEntry[] mbLineNumberTable() throws Exception {
        int n = CType.offsetof("methodblock", "line_number_table", 44);
        int n2 = this.space.readInt(this.mb + n);
        int n3 = CType.offsetof("methodblock", "line_number_table_length", 52);
        int n4 = this.space.readInt(this.mb + n3);
        LineNumberEntry[] lineNumberEntryArray = new LineNumberEntry[n4];
        CType cType = CType.find("LineNumberEntry");
        HeapMethod.Assert(cType == null || cType.getSize() == 4);
        for (int i = 0; i < n4; ++i) {
            int n5 = this.space.readUnsignedShort(n2 + (i << 2));
            int n6 = this.space.readUnsignedShort(n2 + (i << 2) + 2);
            lineNumberEntryArray[i] = new LineNumberEntry(n5, n6);
        }
        return lineNumberEntryArray;
    }

    class LineNumberEntry {
        int pc;
        int line_number;

        LineNumberEntry(int n, int n2) {
            this.pc = n;
            this.line_number = n2;
        }
    }
}

