/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvMonitor;
import com.ibm.jvm.dump.format.DvObject;
import com.ibm.jvm.dump.format.DvThreadDetails;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

public class DvMonitorsRepository {
    static CommandPlugin showRegCp = null;
    static Method showRegMethod = null;
    Vector monitorReferences = new Vector();
    int totalMonitorsCount = 0;
    static String lockingError = null;
    static boolean lockingErrorFirstTime = true;
    private static Vector regMonList = new Vector();
    private static Vector deadlocks = new Vector();
    private static Vector inflMonList = new Vector();
    private static Hashtable lockedObjectsByAddr;
    public static Hashtable monitorsByAddr;
    public static Hashtable monitorsBySysmon;
    public static DvMonitorsRepository that;

    public DvMonitorsRepository() {
        that = this;
        monitorsByAddr = new Hashtable(1000, 1000.0f);
        monitorsBySysmon = new Hashtable(1000, 1000.0f);
        lockedObjectsByAddr = new Hashtable(1000, 1000.0f);
    }

    public static void reset() {
    }

    public void addMonitorReference(Object object, int n) {
        this.monitorReferences.add(object);
        ++this.totalMonitorsCount;
    }

    public String toString() {
        return null;
    }

    public static DvMonitor getInflMon(int n) {
        DvMonitor dvMonitor = null;
        if (n < inflMonList.size()) {
            dvMonitor = (DvMonitor)inflMonList.get(n);
        }
        return dvMonitor;
    }

    public static DvMonitor getRegMon(int n) {
        DvMonitor dvMonitor = null;
        if (n < regMonList.size()) {
            dvMonitor = (DvMonitor)regMonList.get(n);
        }
        return dvMonitor;
    }

    public static void addToInflatedMonList(DvMonitor dvMonitor) {
        inflMonList.add(dvMonitor);
    }

    public static void addToRegMonList(DvMonitor dvMonitor) {
        regMonList.add(dvMonitor);
    }

    public static DvMonitor getMonitorBySysMon(String string) {
        DvMonitor dvMonitor = null;
        dvMonitor = (DvMonitor)monitorsBySysmon.get(string);
        return dvMonitor;
    }

    public static DvMonitor getMonitorByAddr(String string) {
        DvMonitor dvMonitor = null;
        dvMonitor = (DvMonitor)monitorsByAddr.get(string);
        return dvMonitor;
    }

    public static String checkLockingData() {
        if (lockingErrorFirstTime) {
            Vector vector = DvUtils.findMethodForCurrentSuffix("checkLockingData", new Class[0]);
            CommandPlugin commandPlugin = (CommandPlugin)vector.get(0);
            Method method = (Method)vector.get(1);
            try {
                lockingError = (String)method.invoke((Object)commandPlugin, new Object[0]);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find checkLockingData supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        }
        lockingErrorFirstTime = false;
        return lockingError;
    }

    public static Vector displayMonitorPoolInfo(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayMonitorPoolInfo");
        Vector vector = null;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("displayMonitorPoolInfo", new Class[]{String.class});
        CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
        Method method = (Method)vector2.get(1);
        try {
            vector = (Vector)method.invoke((Object)commandPlugin, string);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find displayMonitorPoolInfo supporting " + DvUtils.getSuffix(), 0, true);
            String string2 = exception.toString();
            DvUtils.trace(string2, 0, true);
        }
        return vector;
    }

    public static Vector displayMonitorPoolDump(String string, DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayMonitorPoolDump(String, ObjectDetails)");
        Vector vector = null;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("displayMonitorPoolDump", new Class[]{String.class, DvObject.class});
        CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
        Method method = (Method)vector2.get(1);
        try {
            vector = (Vector)method.invoke((Object)commandPlugin, string, dvObject);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find displayMonitorPoolDump supporting " + DvUtils.getSuffix(), 0, true);
            String string2 = exception.toString();
            DvUtils.trace(string2, 0, true);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayMonitorPoolDump(String, ObjectDetails)");
        return vector;
    }

    public static Vector displaySysMonitorDump(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displaySysMonitorDump");
        Vector vector = null;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("displaySysMonitorDump", new Class[]{String.class});
        CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
        Method method = (Method)vector2.get(1);
        try {
            vector = (Vector)method.invoke((Object)commandPlugin, string);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find displaySysMonitorDump supporting " + DvUtils.getSuffix(), 0, true);
            String string2 = exception.toString();
            DvUtils.trace(string2, 0, true);
        }
        DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displaySysMonitorDump");
        return vector;
    }

    public static void processMonitors(Vector vector) {
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("processMonitors", new Class[]{Vector.class});
        CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
        Method method = (Method)vector2.get(1);
        try {
            method.invoke((Object)commandPlugin, vector);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find processMonitors supporting " + DvUtils.getSuffix(), 0, true);
            String string = exception.toString();
            DvUtils.trace(string, 0, true);
        }
    }

    public static Vector displayJavaObjMonDump(String string) {
        Vector vector = null;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("displayJavaObjMonDump", new Class[]{String.class});
        CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
        Method method = (Method)vector2.get(1);
        try {
            vector = (Vector)method.invoke((Object)commandPlugin, string);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find displayJavaObjMonDump supporting " + DvUtils.getSuffix(), 0, true);
            String string2 = exception.toString();
            DvUtils.trace(string2, 0, true);
        }
        return vector;
    }

    public static Vector getDeadlocksVector() {
        return deadlocks;
    }

    public static Hashtable getLockedObjectsByAddrHashtable() {
        return lockedObjectsByAddr;
    }

    public static Vector getRegMonListVector() {
        return regMonList;
    }

    public static Vector getInflMonListVector() {
        return inflMonList;
    }

    public static Vector showReg(Object object) {
        Vector vector = null;
        if (null == showRegCp) {
            Vector vector2 = DvUtils.findMethodForCurrentSuffix("showReg", new Class[]{DvMonitor.class});
            showRegCp = (CommandPlugin)vector2.get(0);
            showRegMethod = (Method)vector2.get(1);
        }
        try {
            vector = (Vector)showRegMethod.invoke((Object)showRegCp, (DvMonitor)object);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find showReg supporting " + DvUtils.getSuffix(), 0, true);
            String string = exception.toString();
            DvUtils.trace(string, 0, true);
        }
        return vector;
    }

    public static Hashtable getLockedObjectsByAddrHashTable() {
        return lockedObjectsByAddr;
    }

    public static void displayDeadlockChain(boolean bl, Vector vector) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayDeadlockChain");
        for (int i = 0; i < deadlocks.size(); ++i) {
            Object e;
            String string = "  ";
            String string2 = "  ";
            boolean bl2 = true;
            vector.add("\n==============================\n");
            Object object = e = deadlocks.elementAt(i);
            do {
                long l;
                vector.add(string + "Thread 0x" + DvThreadDetails.getThreadID(object) + " \"" + DvThreadDetails.getThreadName(object) + "\"");
                long l2 = DvThreadDetails.getWaitMon(object);
                if (l2 != 0L) {
                    vector.add(string + string2 + "is waiting to be notified for: ");
                } else {
                    l2 = DvThreadDetails.getEnterMon(object);
                    vector.add(string + string2 + "is waiting to enter: ");
                }
                DvMonitor dvMonitor = DvMonitorsRepository.getMonitorByAddr(Long.toHexString(l2));
                if (dvMonitor == null) {
                    dvMonitor = DvMonitorsRepository.getMonitorBySysMon(Long.toHexString(l2));
                }
                if ((l = dvMonitor.getObjectAddress()) == 0L) {
                    l = dvMonitor.getAddress();
                }
                vector.add(string + "    (0x" + Long.toHexString(l) + ") \"" + dvMonitor.getObjectName() + "\"");
                vector.add(string + "     which is owned by:\n");
                string = string + "  ";
                object = DvThreadDetails.getBlockingThread(object);
                if (!bl2) continue;
                bl2 = false;
                string2 = string2 + "which ";
            } while (object != e);
            vector.add(string + "Thread 0x" + DvThreadDetails.getThreadID(object) + " \"" + DvThreadDetails.getThreadName(object) + "\"");
        }
        vector.add("\n==============================\n");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayDeadlockChain");
    }

    static {
        that = null;
    }
}

