/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AIXCore;
import com.ibm.jvm.dump.extract.AbstractLayout;
import com.ibm.jvm.dump.extract.ExLoaded;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExProcessAddressSpace;
import com.ibm.jvm.dump.extract.Executable;
import com.ibm.jvm.dump.extract.HPIModule;
import com.ibm.jvm.dump.extract.JVMModule;
import com.ibm.jvm.dump.extract.Layout;
import com.ibm.jvm.dump.extract.MemoryMap;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.SDFFRas;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdffArchive.SdffArchiveOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class Extract {
    static String exeName = "java";

    public Extract(int n, String string, String string2, String string3, boolean bl, int n2, boolean bl2) {
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format version" + n2);
            }
        }
        try {
            Object object;
            ExProcess exProcess;
            MemoryMap memoryMap;
            Sdff sdff;
            String string4;
            DvFileReader dvFileReader;
            AbstractLayout abstractLayout;
            block14: {
                if (n > 0) {
                    DvUtils.setVerbose(true);
                }
                exeName = string3;
                RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
                abstractLayout = Layout.getLayout(randomAccessFile);
                if (abstractLayout == null) {
                    System.err.println("JVMRAS001: the input file is incompatible with jextract.");
                    System.exit(1);
                }
                dvFileReader = abstractLayout.getFileReader(randomAccessFile);
                string4 = n2 == 0 ? string2 : string2 + ".hdr";
                sdff = new Sdff(string4);
                abstractLayout.readCoreFile();
                SDFFDump sDFFDump = abstractLayout.getHeader();
                sDFFDump.printSdff(sdff);
                memoryMap = abstractLayout.getMemoryMap();
                dvFileReader.setMapper(memoryMap);
                exProcess = abstractLayout.getProcess();
                abstractLayout.getJVMLayout(exProcess, memoryMap, dvFileReader);
                DvUtils.trace("HPIData = " + exProcess.hpiData, 2, false);
                if (exProcess.jvmData == null || exProcess.hpiData == null) {
                    System.err.println("JVMRAS004: Unable to find JVM data in the core file.  The core file may be truncated or it may be incompatible with jextract.");
                    System.exit(1);
                }
                JVMModule jVMModule = exProcess.jvmData;
                jVMModule.populate();
                HPIModule hPIModule = exProcess.hpiData;
                hPIModule.populate();
                try {
                    object = new Executable(exProcess, string3);
                    exeName = ((Executable)object).getExecFileName();
                    if (!(abstractLayout instanceof AIXCore)) {
                        exProcess.loaded = new ExLoaded(dvFileReader, (Executable)object, memoryMap);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                    exeName = "java";
                    if (abstractLayout instanceof AIXCore) break block14;
                    exProcess.loaded = new ExLoaded();
                }
            }
            exProcess.populate(null);
            object = new ExProcessAddressSpace(exProcess);
            SDFFRas sDFFRas = new SDFFRas();
            sDFFRas.jvmRas = exProcess.jvmData.jvmRas;
            DvUtils.trace("JvmRas is 0x" + Long.toHexString(sDFFRas.jvmRas) + " typedefs address " + "0x" + Long.toHexString(sDFFRas.jvmRas + 24L), 2, false);
            dvFileReader.setAddress(sDFFRas.jvmRas + 24L);
            DvUtils.trace("jvmRas typedefs at 0x" + Long.toHexString(dvFileReader.getPos()), 2, false);
            sDFFRas.typedefs = dvFileReader.readAddress();
            DvUtils.trace("typedefs address 0x" + Long.toHexString(sDFFRas.typedefs), 2, false);
            sDFFRas.typedefsLen = (int)dvFileReader.readAddress();
            DvUtils.trace("typedefs length 0x" + Long.toHexString(sDFFRas.typedefsLen), 2, false);
            sDFFRas.printSdff(sdff);
            ((ExProcessAddressSpace)object).printSdff(sdff, memoryMap);
            memoryMap.printSdff(sdff);
            if (n2 == 0 && !bl) {
                memoryMap.printMemory(sdff, dvFileReader);
            }
            sdff.close();
            if (n2 == 0) {
                return;
            }
            File file = new File(string4);
            File file2 = new File(string);
            SdffArchiveOutputStream sdffArchiveOutputStream = new SdffArchiveOutputStream(string2, file, file2);
            sdffArchiveOutputStream.putFile(new File(string4), "SDFF Header");
            sdffArchiveOutputStream.putFile(new File(string), "Original Dump");
            if (bl2) {
                abstractLayout.dumpLibs(sdffArchiveOutputStream);
            }
            sdffArchiveOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("JVMRAS006: Extract failed : " + iOException);
            iOException.printStackTrace();
        }
    }

    static String getExeName() {
        return exeName;
    }
}

