/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;

public final class CrlBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid;
    private Object value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.CrlBag";

    public CrlBag(CRL cRL) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CrlBag", cRL);
        }
        if (!(cRL instanceof X509CRL)) {
            if (debug != null) {
                debug.text(16384L, className, "CrlBag", "Input CRL must extend X509CRL.");
            }
            throw new IllegalArgumentException("Input CRL must extend X509CRL.");
        }
        this.oid = PKCSOID.X509_CRL_OID;
        this.value = cRL;
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(CRL cRL, String string) throws PKCSException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", cRL, string);
        }
        if (!(cRL instanceof X509CRL)) {
            if (debug != null) {
                debug.text(16384L, className, "CrlBag", "Input CRL must extend X509CRL.");
            }
            throw new IllegalArgumentException("Input CRL must extend X509CRL.");
        }
        this.oid = PKCSOID.X509_CRL_OID;
        this.value = cRL;
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(ObjectIdentifier objectIdentifier, byte[] byArray) {
        this(objectIdentifier, byArray, null);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", objectIdentifier, byArray);
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(ObjectIdentifier objectIdentifier, byte[] byArray, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, byArray, string};
            debug.entry(16384L, (Object)className, "CrlBag", objectArray);
        }
        if (!objectIdentifier.equals(PKCSOID.X509CRLBAG_OID) && !objectIdentifier.equals(PKCSOID.X509_CRL_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "CrlBag", "Invalid input object identifier.");
            }
            throw new IllegalArgumentException("Invalid input object identifier.");
        }
        try {
            this.value = new X509CRLImpl(byArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "CrlBag", exception);
            }
            throw new IllegalArgumentException("Invalid CRL encoding.");
        }
        this.oid = objectIdentifier;
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CrlBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", string, new Boolean(bl));
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "CrlBag", objectArray);
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        derOutputStream.putOID(this.oid);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        X509CRL x509CRL = (X509CRL)this.value;
        try {
            derOutputStream3.write(x509CRL.getEncoded());
            derOutputStream4.putOctetString(derOutputStream3.toByteArray());
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding X.509 CRL.");
            }
            throw new IOException("Error encoding X.509 CRL.");
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception exception) {
            objectIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", objectIdentifier);
        }
        return objectIdentifier;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        try {
            X509CRLImpl x509CRLImpl = new X509CRLImpl(this.getEncodedValue());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getValue_1", x509CRLImpl);
            }
            return x509CRLImpl;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", exception);
                debug.exit(16384L, (Object)className, "getValue_2", null);
            }
            return null;
        }
    }

    public byte[] getEncodedValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        X509CRL x509CRL = (X509CRL)this.value;
        try {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_1", x509CRL.getEncoded());
            }
            return x509CRL.getEncoded();
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", cRLException);
                debug.exit(16384L, (Object)className, "getEncodedValue_2", null);
            }
            return null;
        }
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "CrlBag");
        }
        return "CrlBag";
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof CrlBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((CrlBag)object));
            }
            return this.equals((CrlBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            CrlBag crlBag = new CrlBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", crlBag);
            }
            return crlBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        Object object = this.getValue();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "CrlBag:";
        string = string + "\r\nobject identifier: " + this.oid;
        string = string + "\r\ncertificate revocation list:\r\n";
        string = string + object.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CrlBag parsing error, not a SEQUENCE.");
            }
            throw new IOException("CrlBag parsing error, not a SEQUENCE.");
        }
        this.oid = derValue.getData().getOID();
        if (!this.oid.equals(PKCSOID.X509CRLBAG_OID) && !this.oid.equals(PKCSOID.X509_CRL_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid CrlBag object identifier in encoding.");
            }
            throw new IllegalArgumentException("Invalid CrlBag object identifier in encoding.");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        DerValue derValue3 = derValue2.isContextSpecific((byte)0) ? derValue2.getData().getDerValue() : derValue2;
        if (this.oid.equals(PKCSOID.X509CRLBAG_OID) || this.oid.equals(PKCSOID.X509_CRL_OID)) {
            try {
                byte[] byArray = derValue3.getOctetString();
                this.value = new X509CRLImpl(byArray);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", exception);
                }
                throw new IOException("Error decoding X.509 CRL.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoded OID");
            }
            throw new IllegalArgumentException("Invalid encoded OID");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(CrlBag crlBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", crlBag);
        }
        if (crlBag == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            crlBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

