#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;

#
#  Write header of page for admin
#
sub print_top {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}


#
#  Write header of page for admin
#
sub print_bottom {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}

#
#  Begin of main section
#

my ($time,  $line, @tracesettings, $admin_trace, $datagram_trace,
    $data_trace, $check_count, $label, $trace_none);

print header;

# output top of template page
print_top();

$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#! Get CSLINKS output
@tracesettings=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_cs_trace`;

print "<font face=\"Courier, Helvetica\">";
print "<br><b> Select Client/Server Trace Options: $time</b>";
print "<br><br>  Current Client/Server Trace status:<br>\n";
print "<form action= \"/cscbin/actcsdomtrace.cgi\" method=\"post\">\n";

#
# display current client/server  trace options
#
$check_count = 0;
foreach $line (@tracesettings) {
   next if $line=~m/^-------/;       # skip border
   if ($line=~m/^trace_flags/) {     # start reading traces
        print $line."<br>\n";
        if ($line=~m/ NONE/) {  #  If trace is off, mark it and go to next line
            $trace_none = 1;
            next;
        }
  #  Test for each flag on line
        if ($line=~m/ CS_ADMIN/) {
           $admin_trace = 1;
           $check_count++;
        } # ADMIN msg trace
        if ($line=~m/ CS_DATAGRAM/) {
           $datagram_trace = 1;
           $check_count++;
        } # Datagram trace
        if ($line=~m/ CS_DATA/) {
           $data_trace = 1;
           $check_count++;
        } # DATA trace
        next;
   }
}
#  Print seperator line
print " <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
print "<td colspan=\"2\" width=\"100%\">\n";
print "<hr size=\"1\" align=\"left\" width=\"100%\" color=\"#000000\" noshade=\"noshade\">\n";
print "</td></table> <table>\n";
#
#   Process lines read for action to set up
#

if ($trace_none) {  # Set ALL flag and skip rest
   print "<table><tr><td> Select <b>ALL</b> to turn on all trace flags: ";
   print "<b>ALL </b><input type=\"checkbox\" name=\"traceopt\" value=\"all\"/>";
} elsif ($check_count == 3) {  # ALL flag is set
   print "<table><tr><td> Select <b>NONE</b> to turn off trace flags: ";
   print "<b>NONE</b><input type=\"checkbox\" name=\"traceopt\" value=\"none\"/>";
} else {
   print "<table><tr><td> Select <b>NONE</b> to turn off traces, <b>ALL</b> to enable all traces:<br>";
   print "<b> NONE </b><input type=\"radio\" name=\"traceopt\" value=\"none\"/>";
   print "<b> ALL </b><input type=\"radio\" name=\"traceopt\" value=\"all\"/>";
}
print "<br><br><b> -OR- </b> \"check\" specific Client/Server trace flags to enable:&nbsp;&nbsp;&nbsp;&nbsp;<br>";
print "</td></tr>";

# Print check boxes
print "<table><tr><td><br>     ";
#  set Admin checkbox
print "<b>ADMIN_MSG</b><input type=\"checkbox\" name=\"admin\" value=\"yes\"";
if ($admin_trace) { print " checked />"; }
else {print " />"; }
#  set DATAGRAM checkbox
print "<b>  DATAGRAM</b><input type=\"checkbox\" name=\"datagram\" value=\"yes\"";
if ($datagram_trace) { print " checked />"; }
else {print " />"; }
#  set DATA checkbox
print "<b>  DATA</b><input type=\"checkbox\" name=\"data\" value=\"yes\"";
if ($data_trace) { print " checked />"; }
else {print " />"; }
#  set Data checkbox
#
print "</td></tr></tbody></table></table>";
print "<br>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";
print "   <input type=\"reset\" name=\"reset\" value=\"Reset\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
