#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2016 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;

my ($time, $arg, $line, @contents);
$arg=" ";

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

#! parameter grep is set to indicate type of diag call 
$arg=param('grep');

$time=localtime;

print "<font face=\"Courier, Helvetica\">\n";   # Force to mono-space

if ($arg=~/^error/) {
   print "<b>Communications Server Error Log: $time</b><br>";
   @contents=`cat /var/opt/ibm/sna/sna.err`;   # Command to get sna.err
} elsif ($arg=~/^audit/) {
   print "<b>Communications Server Audit Log: $time</b><br>";
   @contents=`cat /var/opt/ibm/sna/sna.aud`;     # Command to get sna.aud
} elsif ($arg=~/^tail_error/) {
   print "<b>Communications Server Error Log Tail: $time</b><br>";
   @contents=`tail -100 /var/opt/ibm/sna/sna.err`;   # get last 100 lines of sna.err
} elsif ($arg=~/^tail_audit/) {
   print "<b>Communications Server Audit Log Tail: $time</b><br>";
   @contents=`tail -100 /var/opt/ibm/sna/sna.aud`;     # get last 100 lines sna.aud
} elsif ($arg=~/^usage/) {
   print "<b>Communications Server Usage: $time</b><br>";
   @contents=`cat /var/opt/ibm/sna/sna.usage`;     # Command to get usage
} elsif ($arg=~/^display_usage/) {
   print "<b>Communications Server Usage Summary: $time</b><br>";
   @contents=`../cscbin/usage.pl /var/opt/ibm/sna/sna.usage`;     # Command to get usage
} elsif ($arg=~/^provMgr/) {
   print "<b>Provision Manager Log: $time</b><br>";
   @contents=`cat /var/opt/ibm/sna/provMgr.log`;   # Command to get provMgr.log
} elsif ($arg=~/^rapi_provMgr/) {
   print "<b>RAPI Provision Manager Log: $time</b><br>";
   @contents=`cat /var/opt/ibm/sna/rapi_provMgr.trc`;     # Command to get rapi_provMgr.trc
} elsif ($arg=~/^tail_provMgr/) {
   print "<b>Provision ManagerLog Tail: $time</b><br>";
   @contents=`tail -500 /var/opt/ibm/sna/provMgr.log`;   # get last 500 lines of provMgr.log
} elsif ($arg=~/^tail_rapi_provMgr/) {
   print "<b>RAPI Provision Manager Tail: $time</b><br>";
   @contents=`tail -500 /var/opt/ibm/sna/rapi_provMgr.trc`;     # get last 500 lines rapi_provMgr.trc
} else {
  print " UNKNOWN COMMAND";
}
foreach $line (@contents) {
#   chomp $line;
#  On none active lines, print end of list in html format
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);


