#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_conversation and display
#  the active conversations in the domain
#

use strict;

 my ( $srv_index, $srvcnt, $state,$lu_name, $conv_id, $local_tp_name, $partner_tp_name, $tp_id,
      $sess_id, $conv_start_time,$bytes_sent, $bytes_received, $conv_state, $duplex_type,$display_flag,
      @servername, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   

#  Initialize for scalar declaration
$srv_index = 0;
$display_flag = 1;

while ($srv_index < $srvcnt) 
{

    @status=`../cscbin/query_all_conversations.sh $servername[$srv_index] ` or die "Node $servername[$srv_index] not recognized $!\n";


   #   Print header line
    printf("\n      Server: %s\n", $servername[$srv_index]);
    print "-------------------------------------------------------------------------------------------------------- \n";
    foreach(@status) {
      chomp;
       #  Skip headers
       next if (/^------/);
       next if (/^list_option/);
       next if (/^No/);
       next if (/^\n/);
       if (/^sess_id/) {  # Replace <> with &lt: and &gt;
           $_=~s/</&lt;/g;
           $_=~s/>/&gt;/g;
       }elsif (/^tp_id/) {   # Replace <> with &lt: and &gt;
           $_=~s/</&lt;/g;
           $_=~s/>/&gt;/g;
       }
       
       @data = split(/=/,$_);   #Break parameter = value
       
       next if (@data == 0);        # on blank line, skip
       
       if ($data[0]=~m/^lu_name/) {
           $lu_name = $data[1];
           $lu_name=~s/ //g;
           $display_flag = 1;
           next;
       }elsif ($data[0]=~m/^conv_id/) { # only display info when there are conversations
           $conv_id = $data[1];
           $conv_id=~s/ //g;
           if($display_flag == 1){
              printf ("---- LU Name:   %8s ---\n", $lu_name);
              print " conv_id                   local_tp_name      partner_tp_name           tp_id              sess_id     \n";
              print "conv_start_time             bytes_sent         bytes_received          conv_state         duplex_type       \n";
              print "--------------------  --------------------  --------------------  ------------------  ------------------ \n";
              $display_flag = 0;
           }
           next;
       } elsif ($data[0]=~m/^local_tp_name/) {
           $local_tp_name = $data[1];
           $local_tp_name=~s/ //g;
           next;
       } elsif ($data[0]=~m/^partner_tp_name/) {
           $partner_tp_name = $data[1];
           $partner_tp_name=~s/ //g;
           next;
       }elsif ($data[0]=~m/^tp_id/) {
           $tp_id = $data[1];
           $tp_id=~s/ //g;
           next;
       } elsif ($data[0]=~m/^sess_id/) {
           $sess_id = $data[1];
           $sess_id=~s/ //g;
           printf("          %10s  %20.20s  %20.20s  %18s  %18s \n",
            $conv_id, $local_tp_name, $partner_tp_name, $tp_id, $sess_id);
           next;
       } elsif ($data[0]=~m/^conv_start_time/) {
           $conv_start_time = $data[1];
           $conv_start_time=~s/ //g;
           next;
       } elsif ($data[0]=~m/^bytes_sent/) {
           $bytes_sent = $data[1];
           $bytes_sent=~s/ //g;
           next;
       } elsif ($data[0]=~m/^bytes_received/) {
           $bytes_received = $data[1];
           $bytes_received=~s/ //g;
           next;
       } elsif ($data[0]=~m/^conv_state/) {
           $conv_state = $data[1];
           $conv_state=~s/ //g;
       } elsif ($data[0]=~m/^duplex_type/){
           $duplex_type = $data[1];
           $duplex_type=~s/ //g;
           printf("%20.20s  %20.20s  %20.20s     %15s         %11s\n",
           $conv_start_time, $bytes_sent, $bytes_received, $conv_state, $duplex_type);
           print "-------------------------------------------------------------------------------------------------------- \n";
           next;
       }
       
   }

   $srv_index++;
}


