#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_user_id, $arg_description, $arg_password, $description,
    $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_user_id=param('user_id_unique');
if ($arg_user_id eq "") {
    $arg_description="";
    $arg_password="";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   * User id
    print "<tr> <td>* User id :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"user_id_unique\"  maxlength=\"10\" value=\"$arg_user_id\" required=\"required\" /></td></tr>";
    
    #    Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   * Password
   print "<tr> <td>* Password : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"password\"  maxlength=\"10\" value=\"$arg_password\" required=\"required\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
   $arg_description=param('description');
   $arg_user_id=param('user_id_unique');
   $arg_password=param('password');
    
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_userid_password, user_id=$arg_user_id, password=$arg_password $description`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_userid_password, user_id=$arg_user_id, password=$arg_password $description";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add LU 6.2 User:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

