#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_force_responses, $arg_keepalive_interval, $arg_keepalive_method, $keepalive_interval, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_force_responses=param('force_responses_unique');

if ($arg_force_responses eq "") {
    $arg_force_responses="NO";
    $arg_keepalive_interval="600";
    $arg_keepalive_method="NONE";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #    Force responses on printer sessions ?
    print "<tr> <td> Force responses on printer sessions ?</td> <td><select name=\"force_responses_unique\"  class=\"rightAligned\" value=\"$arg_force_responses\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option> </select></td></tr>";
    
    #    Keep-alive message type
    print "<tr> <td>Keep-alive message type : </td> <td><select name=\"keepalive_method\"  class=\"rightAligned\" value=\"$arg_keepalive_method\" >  ";
    print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
    print "<option value=\"NOP\">NOP</option> ";
    print "<option value=\"TM\"> TM</option> </select></td></tr>";
    
    print "<tr><td> If NOP or TM (Timing-mark), </td></tr>";
    #     Keep-alive interval (seconds)
    print "<tr> <td> Keep-alive interval (seconds) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"keepalive_interval\"  maxlength=\"4\" value=\"$arg_keepalive_interval\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
   $arg_keepalive_interval=param('keepalive_interval');
   $arg_force_responses=param('force_responses_unique');
   $arg_keepalive_method=param('keepalive_method');
    
    if ($arg_keepalive_interval eq "") {
        $keepalive_interval="";
    }else
    {
        $keepalive_interval=",keepalive_interval=$arg_keepalive_interval";
    }
    

    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_defaults, force_responses=$arg_force_responses, keepalive_method=$arg_keepalive_method $keepalive_interval`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_defaults, force_responses=$arg_force_responses, keepalive_method=$arg_keepalive_method $keepalive_interval";
   
   print "<br> Display Output from Add TN3270 Server Defaults:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

