#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_display_lu_name, $arg_description, $arg_printer_lu_name, $description, $lu_name, $len, $time, $line, @data, @contents, @dlist, @plist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_display_lu_name=param('display_lu_name_unique');
if ($arg_display_lu_name eq "") {
    $arg_description="";
    $arg_printer_lu_name="";
    $arg_display_lu_name="";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3 -d`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/^lu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            $lu_name=$data[1];
            next;
        }elsif ($line=~m/lu_model/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($data[1]=~m/3270_DISPLAY/ || $data[1]=~m/UNKNOWN/ ) {
                push @dlist, $lu_name;
            }elsif($data[1] =~/PRINTER/){
                push @plist, $lu_name;
            }
            next;
        }
    }
    $len=@dlist;
    if($len eq 0){
        print "<br> Display LU should be defined before define TN Association. ";
        exit 1;
    }
    
    $len=@plist;
    if($len eq 0){
        print "<br> Printer LU should be defined before define TN Association.  ";
        exit 1;
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #    Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  * Display LU
    print "<tr><td>* Display LU :</td> <td><select name=\"display_lu_name_unique\" class=\"rightAligned\" value=\"$arg_display_lu_name\" >  ";
    foreach $line (@dlist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #   * Printer LU
    print "<tr> <td>* Printer LU :</td> <td><select name=\"printer_lu_name\" class=\"rightAligned\" value=\"$arg_printer_lu_name\" >  ";
    foreach $line (@plist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
   $arg_description=param('description');
   $arg_printer_lu_name=param('printer_lu_name');
   $arg_display_lu_name=param('display_lu_name_unique');
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_association, display_lu_name=$arg_display_lu_name, printer_lu_name=$arg_printer_lu_name $description`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_association, display_lu_name=$arg_display_lu_name, printer_lu_name=$arg_printer_lu_name $description";
   
   print "<br> Display Output from Add TN Association:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

