#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_auth_type, $arg_ldap_addr, $arg_ldap_port, $arg_ldap_user, $arg_ldap_password, $ldap_addr, $ldap_port, $ldap_user, $ldap_password, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_auth_type=param('auth_type_unique');
if ($arg_auth_type eq "") {
    $arg_auth_type="LOCAL_ONLY";
    $arg_ldap_addr="";
    $arg_ldap_port="";
    $arg_ldap_user="";
    $arg_ldap_password="";
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn3270_ssl_ldap`;

   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
    
       if ($line=~m/auth_type/) {
           @data = split(/=/,$line);
           $data[1]=~s/^\s+|\s+$//g;
           $arg_auth_type = $data[1];
           next;
       } elsif ($line=~m/ldap_addr/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+//;
         $data[1]=~s/\s+$//;
         $arg_ldap_addr = $data[1];
         next;
      } elsif ($line=~m/ldap_user/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;
         $arg_ldap_user = $data[1];
         next;
      } elsif ($line=~m/ldap_port/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;
         $arg_ldap_port = $data[1];
         next;
      } elsif ($line=~m/ldap_password/) {
         @data = split(/=/,$line);
         $data[1]=~s/^\s+|\s+$//g;
         $arg_ldap_password = $data[1];
         next;         
      } else {
        next;
      }

   }

    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   Specifies the type of authorization
    print "<tr> <td>The type of authorization :</td> <td><select name=\"auth_type_unique\"  class=\"rightAligned\" value=\"$arg_auth_type\" >  ";
    print "<option value=\"LOCAL_ONLY\" selected=\"selected\">LOCAL_ONLY</option> ";
    print "<option value=\"LOCAL_X500\">LOCAL_X500</option> </select></td></tr>";
    
    print "<tr> <td>If YES, </td> </tr>";
    
    #    LDAP Address or name
   print "<tr> <td> LDAP Address or name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ldap_addr\"  maxlength=\"255\" value=\"$arg_ldap_addr\" /></td></tr>";
    
    #   LDAP Port
   print "<tr> <td>LDAP Port : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ldap_port\"  maxlength=\"10\" value=\"$arg_ldap_port\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    
    #   LDAP User
    print "<tr> <td> LDAP User : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ldap_user\"  maxlength=\"1024\" value=\"$arg_ldap_user\" >  ";
   
    #   LDAP Password
   print "<tr> <td>LDAP Password :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"ldap_password\"  maxlength=\"128\"  value=\"$arg_ldap_password\" /></td></tr>";

    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
   $arg_ldap_addr=param('ldap_addr');
   $arg_ldap_port=param('ldap_port');
   $arg_ldap_user=param('ldap_user');
   $arg_ldap_password=param('ldap_password');
    
    if ($arg_ldap_addr eq "") {
        $ldap_addr="";
    }else
    {
        $ldap_addr=",ldap_addr=$arg_ldap_addr";
    }
    
    if ($arg_ldap_port eq "") {
        $ldap_port="";
    }else
    {
        $ldap_port=",ldap_port=$arg_ldap_port";
    }
    if ($arg_ldap_user eq "") {
        $ldap_user="";
    }else
    {
        $ldap_user=",ldap_user=$arg_ldap_user";
    }
    if ($arg_ldap_password eq "") {
        $ldap_password="";
    }else
    {
        $ldap_password=",ldap_password=$arg_ldap_password";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_ssl_ldap, {tn3270_ssl_ldap_data}, auth_type=$arg_auth_type  $ldap_port $ldap_user $ldap_password $ldap_addr`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tn3270_ssl_ldap, {tn3270_ssl_ldap_data}, auth_type=$arg_auth_type  $ldap_port $ldap_user $ldap_password $ldap_addr";
   

   print "<br> Display Output from Add TN Server SSL Client Authentication:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

