#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_base_name, $arg_description, $arg_pu_name,$arg_min_nau, $arg_max_nau, $arg_pool_name, $arg_lu_model, $arg_sscp_id, $arg_timeout, $arg_name_attributes, $arg_base_number, $description, $pool_name, $type, $timeout, $sscp_id, $base_number, $len, $time, $line, @data, @contents, @pulist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_base_name=param('lu0-3_base_name_unique');

if ($arg_base_name eq "") {
    $arg_description="";
    $arg_pu_name="";
    $arg_pool_name="";
    $arg_lu_model="UNKNOWN";
    $arg_min_nau="1";
    $arg_max_nau="1";
    $arg_timeout="0";
    $arg_sscp_id="0";
    $arg_base_number="0";
    $arg_name_attributes="NONE";
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_ls -d`;
   foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
       
       if ($line=~m/dlc_type/) {
           @data = split(/=/,$line);
           $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
           $type=$data[1];
           next;
       }elsif ($line=~m/pu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($type=~m/ETHERNET/ ) {
                if($data[1]=~m/""/)
                {
                    next;
                }else{
                    push @pulist, $data[1];
                    next;
                }
            }
        }
   }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlur_pu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/pu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @pulist, $data[1];
            next;
        }
    }
    
   $len=@pulist;
    if($len eq 0){
        print "<br> Host LS/DLUR PU should be defined before define LU Type 0-3. ";
        exit 1;
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  Base name for LUs
    print "<tr><td>* Base name for LUs :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"lu0-3_base_name_unique\" maxlength=\"6\" value=\"$arg_base_name\" required=\"required\" /></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Host LS/DLUR PU
    print "<tr><td>* Host LS/DLUR PU :</td> <td><select name=\"pu_name\" class=\"rightAligned\" value=\"$arg_pu_name\" >  ";
    foreach $line (@pulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  * LU number of first LU
    print "<tr><td>* LU number of first LU : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"min_nau\" maxlength=\"3\" value=\"$arg_min_nau\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\"/></td></tr>";
    
    #  * LU number of last LU
    print "<tr><td>* LU number of last LU : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_nau\" maxlength=\"3\" value=\"$arg_max_nau\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\"/></td></tr>";
    
    #   Model type
    print "<tr><td> Model type </td> <td> <select name=\"lu_model\" class=\"rightAligned\" value=\"$arg_lu_model\" >  ";
    print "<option value=\"UNKNOWN\" selected=\"selected\">UNKNOWN</option> ";
    print "<option value=\"3270_DISPLAY_MODEL_2\">3270_DISPLAY_MODEL_2</option>";
    print "<option value=\"3270_DISPLAY_MODEL_3\">3270_DISPLAY_MODEL_3</option>";
    print "<option value=\"3270_DISPLAY_MODEL_4\">3270_DISPLAY_MODEL_4</option>";
    print "<option value=\"3270_DISPLAY_MODEL_5\">3270_DISPLAY_MODEL_5</option>";
    print "<option value=\"PRINTER\">PRINTER</option>";
    print "<option value=\"SCS_PRINTER\">SCS_PRINTER</option>";
    print "<option value=\"RJE_WKSTN\">RJE_WKSTN</option></select></td></tr>";
    
    #   Pool name (if pooled)
    print "<tr><td>Pool name (if pooled) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"pool_name\" maxlength=\"8\" value=\"$arg_pool_name\" /></td></tr>";
    
    #   Inactivity timeout
    print "<tr><td>Inactivity timeout(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"timeout\" maxlength=\"5\" value=\"$arg_timeout\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";

    #   Restrict SSCP to SSCP id
    print "<tr><td>Restrict SSCP to SSCP id(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"sscp_id\" maxlength=\"5\" value=\"$arg_sscp_id\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Name attributes
    print "<tr><td> Name attributes : </td> <td> <select name=\"name_attributes\" class=\"rightAligned\" value=\"$arg_name_attributes\" >  ";
    print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
    print "<option value=\"USE_BASE_NUMBER\">USE_BASE_NUMBER</option>";
    print "<option value=\"USE_HEX_IN_NAME\">USE_HEX_IN_NAME</option></select></td></tr>";
    
    #  Base number
    print "<tr><td>Base number : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"base_number\" maxlength=\"3\" value=\"$arg_base_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_base_name=param('lu0-3_base_name_unique');
   $arg_description=param('description');
   $arg_pu_name=param('pu_name');
   $arg_pool_name=param('pool_name');
   $arg_lu_model=param('lu_model');
   $arg_sscp_id=param('sscp_id');
   $arg_timeout=param('timeout');
   $arg_min_nau=param('min_nau');
   $arg_max_nau=param('max_nau');
   $arg_base_number=param('base_number');
   $arg_name_attributes=param('name_attributes');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_timeout eq "") {
        $timeout="";
    }else
    {
        $timeout=",timeout=$arg_timeout";
    }

    if ($arg_sscp_id eq "") {
        $sscp_id="";
    }else
    {
        $sscp_id=",sscp_id=$arg_sscp_id";
    }

    if ($arg_pool_name eq "") {
        $pool_name="";
    }else
    {
        $pool_name=",pool_name=$arg_pool_name";
    }
    
    if ($arg_base_number eq "") {
        $base_number="";
    }else
    {
        $base_number=",base_number=$arg_base_number";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_0_to_3_range,base_name=$arg_base_name, min_nau=$arg_min_nau, max_nau=$arg_max_nau, pu_name=$arg_pu_name, lu_model=$arg_lu_model, name_attributes=$arg_name_attributes $sscp_id $pool_name $description $timeout $base_number`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_0_to_3_range,base_name=$arg_base_name, min_nau=$arg_min_nau, max_nau=$arg_max_nau, pu_name=$arg_pu_name, lu_model=$arg_lu_model, name_attributes=$arg_name_attributes $sscp_id $pool_name $description $timeout $base_number";
   
   print "Display Output from Add Range Of LUs Type 0-3:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

