#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_list_name, $arg_description, $arg_user_name, $description, $user_name, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_list_name=param('list_name_unique');
if ($arg_list_name eq "") {
    $arg_description="";
    $arg_user_name="";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #    Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   * List name
   print "<tr> <td>* List name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"list_name_unique\"  maxlength=\"14\" value=\"$arg_list_name\" required=\"required\" /></td></tr>";
    
    #    User name
   print "<tr> <td>User name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"user_name\"  maxlength=\"10\" value=\"$arg_user_name\" /></td></tr>";
    
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
   $arg_description=param('description');
   $arg_list_name=param('list_name_unique');
   $arg_user_name=param('user_name');
    
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_user_name eq "") {
        $user_name="";
    }else
    {
        $user_name=",{security_user_data},user_name=$arg_user_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_security_access_list, list_name=$arg_list_name $user_name $description`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_security_access_list, list_name=$arg_list_name $user_name $description";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add LU 6.2 Access List:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

