#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################

use strict;

 my ( $line, $poolname, $active_lus, $avail_lus, 
      $act_appl_conn_lus, $total_num_lus, $value, $label, @status );

#  Initialize for scalar declaration
$poolname = " ";

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_pool`; # Get Dep. LU information
} else {
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $ARGV[0] query_lu_pool` or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header lines
print "\n=  POOL:   ACTIVE:  AVAIL:   APPL/CONN:     Total Number LU: \n";
print "=  =====   =======  ======   ==========     ================ ";

$line =0;
foreach(@status) {
   chomp;
   if (/^query_lu_pool/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
#  Skip headers
   next if (/^list_/);
   next if (/^-----/);
   next if (!/^\w/);

#  Break into 'label = value'
   ($label, $value) = (split(/\s+/,$_) )[0,2];

   if ($label=~m/^pool_name/) {       # get Pool name 
     $poolname = $value;
     printf( "\n %8s ",$poolname);

   } elsif ($label=~m/^num_active_lus/) {  # either number active LU
     $active_lus = $value;
     printf("    %4d  ", $active_lus);

   } elsif ($label=~m/^num_avail_lus/) { # number avaliable LUs
     $avail_lus = $value;
     printf("  %4d ", $avail_lus);

   } elsif ($label=~m/^num_act_appl_conn_lus/) { # num act api or tn LUs
     $act_appl_conn_lus = $value;
     printf("        %4d ",$act_appl_conn_lus);

   } elsif ($label=~m/^total_num_lus/) { # total num LUs in POOL
     $total_num_lus = $value;
     printf("       %4d ",$total_num_lus);

   }  else {             # skip to next line
     $line++;       
   }
}
print "\n------------------------------------------------\n";

