#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2013 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin query_session,lu_name= and display
#  in a terse format the information.


use strict;

 my ( $modename, $plualias, $fqpluname, $fqcpname, $cosname,
      $luname, $sessid, $rtpname, $numbytes, @data, @status );
# comment out pcid    $sessid, $pcid, $rtpname, $numbytes, @data, @status );

#  Initialize for scalar declaration
$rtpname = " ";

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`../cscbin/qall_lus.sh`;             # Get detailed Link Station information
} else {
  @status=`../cscbin/qall_lus.sh  -n $ARGV[0] ` or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header line


print "    Session ID      Partner LU        LU Name    Mode   CoS Name RTP Name  Total bytes  \n";
print "================== ================= ========= ======== ======== ======== ============\n";


foreach(@status) {

   chomp;
   if (/^query_session/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }

  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break label with value

   next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

   if ($data[0]=~m/^rtp_name/) {       # get rtp connection name
     $rtpname = $data[1];
     $rtpname=~s/ //g;
     next;
   }elsif ($data[0]=~m/^lu_name/) {  # partner PU name
     $luname = $data[1];
     $luname=~s/ //g;
     next;
   } elsif ($data[0]=~m/^fqplu_name/) {  # partner PU name
     $fqpluname = $data[1];
     $fqpluname=~s/ //g;
     next;
   } elsif ($data[0]=~m/^plu_alias/) { # partner lu node
     $plualias = $data[1];
     $plualias=~s/ //g;
     #  Init variables in loop for this record
     $numbytes=0;
     $rtpname="NONE";     next;
   } elsif ($data[0]=~m/^mode_name/) { # mode
     $modename = $data[1];
     $modename=~s/ //g;
     next;
   } elsif ($data[0]=~m/^cos_name/) { # Cost of service
     $cosname = $data[1];
     $cosname=~s/ //g;
     next;
   } elsif (($data[0]=~m/^send_data_bytes/) ||
            ($data[0]=~m/^rcv_data_bytes/) ) { # total number of bytes
     $data[1]=~s/ //g;
     $numbytes+=$data[1];
     next;
   } elsif ($data[0]=~m/^session_id/) { # session ID
     $data[1]=~s/</{/g;     # convert less-then because html fails
     $data[1]=~s/>/}/g;     # convert gtr-then because html fails
     $sessid = $data[1];
     $sessid=~s/ //g;
     next;
#   } elsif ($data[0]=~m/^pcid/) { # procedure ID
#     $data[1]=~s/</{/g;     # convert less-then because html fails
#     $data[1]=~s/>/}/g;     # convert gtr-then because html fails
#     $pcid = $data[1];
#     $pcid=~s/ //g;
#     next;
   } elsif ($data[0]=~m/^fqcp_name/) { # CP Name
     $fqcpname = $data[1];
     $fqcpname=~s/ //g;
   } elsif ($data[0]=~m/^session_timeout/) { # Last record we can flag on
     printf("%18s %17s %8s %8s %8s %8s %12u\n\n",
               $sessid, $fqpluname, $luname, $modename,
               $cosname, $rtpname, $numbytes);
   }
}
print "\n------------------------------------------------\n";

