/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import sun.rmi.server.RMIClassLoader;
import sun.rmi.transport.Utils;

public class MarshalInputStream
extends ObjectInputStream {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static boolean codeBaseOnly = Utils.getBoolean("java.rmi.server.useCodebaseOnly");

    public MarshalInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Object object = this.readObject();
        try {
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException classNotFoundException2 = classNotFoundException;
            String string = objectStreamClass.getName();
            RMIClassLoader rMIClassLoader = null;
            String string2 = null;
            try {
                if (!codeBaseOnly && object != null && object instanceof String) {
                    string2 = (String)object;
                    URL uRL = new URL(string2);
                    rMIClassLoader = RMIClassLoader.getClassLoader(uRL);
                } else {
                    rMIClassLoader = RMIClassLoader.getLocalLoader();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Malformed URL " + string2 + ": " + malformedURLException);
            }
            if (rMIClassLoader != null) {
                return MarshalInputStream.loadClassFromLoader(string, rMIClassLoader);
            }
            throw classNotFoundException2;
        }
    }

    private static Class loadClassFromLoader(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int n;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != '[') break;
            ++n2;
        }
        if (n2 == 0) {
            return classLoader.loadClass(string);
        }
        if (string.length() > n2 && string.charAt(n2) == 'L' && (n = string.indexOf(59, n2)) == string.length() - 1) {
            String string2 = string.substring(n2 + 1, n);
            Class clazz = classLoader.loadClass(string2);
            int[] nArray = new int[n2];
            Object object = Array.newInstance(clazz, nArray);
            return object.getClass();
        }
        return Class.forName(string);
    }
}

