/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;

public class JdbcOdbcResultSetMetaData
extends JdbcOdbcObject
implements ResultSetMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcResultSetInterface resultSet;
    protected int hStmt;

    public JdbcOdbcResultSetMetaData(JdbcOdbc jdbcOdbc, JdbcOdbcResultSetInterface jdbcOdbcResultSetInterface) {
        this.OdbcApi = jdbcOdbc;
        this.resultSet = jdbcOdbcResultSetInterface;
        this.hStmt = jdbcOdbcResultSetInterface.getHSTMT();
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isAutoIncrement (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 11);
        return bl;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isCaseSensitive (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 12);
        return bl;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isSearchable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 13)) != 0;
        return bl;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isCurrency (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 9);
        return bl;
    }

    public int isNullable(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isNullable (" + n + ")");
        }
        int n2 = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? 0 : this.getColAttribute(n, 7);
        return n2;
    }

    public boolean isSigned(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isSigned (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : !this.getColAttributeBoolean(n, 8);
        return bl;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getColumnDisplaySize (" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() : this.getColAttribute(n, 6);
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getColumnLabel (" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n, 18);
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getColumnName (" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n, 1);
        string = this.resultSet.mapColumnName(string, n);
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getSchemaName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 16);
    }

    public int getPrecision(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getPrecision (" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() - 1 : this.getColAttribute(n, 4);
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getScale (" + n + ")");
        }
        return this.resultSet.getScale(n);
    }

    public String getTableName(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getTableName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 15);
    }

    public String getCatalogName(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getCatalogName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 17);
    }

    public int getColumnType(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getColumnType (" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n)) != null ? jdbcOdbcPseudoCol.getColumnType() - 1 : this.resultSet.getColumnType(n);
        return n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.getColumnTypeName (" + n + ")");
        }
        String string = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? "" : this.getColAttributeString(n, 14);
        return string;
    }

    public boolean isReadOnly(int n) throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isReadOnly (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? true : (n2 = this.getColAttribute(n, 10)) == 0;
        return bl;
    }

    public boolean isWritable(int n) throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isWritable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 2;
        return bl;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*ResultSetMetaData.isDefinitelyWritable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 1;
        return bl;
    }

    protected int getColAttribute(int n, int n2) throws SQLException {
        return this.resultSet.getColAttribute(n, n2);
    }

    protected boolean getColAttributeBoolean(int n, int n2) throws SQLException {
        int n3 = this.getColAttribute(n, n2);
        boolean bl = false;
        if (n3 == 1) {
            bl = true;
        }
        return bl;
    }

    protected String getColAttributeString(int n, int n2) throws SQLException {
        String string = "";
        this.resultSet.clearWarnings();
        try {
            string = this.OdbcApi.SQLColAttributesString(this.hStmt, n, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.resultSet.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }
}

