/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcLimits;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSet;

public class JdbcOdbcDatabaseMetaData
extends JdbcOdbcObject
implements DatabaseMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcConnectionInterface Con;
    protected int hDbc;

    public JdbcOdbcDatabaseMetaData(JdbcOdbc jdbcOdbc, JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        this.OdbcApi = jdbcOdbc;
        this.Con = jdbcOdbcConnectionInterface;
        this.hDbc = this.Con.getHDBC();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.allProceduresAreCallable");
        }
        return this.getInfoBooleanString((short)20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.allTablesAreSelectable");
        }
        return this.getInfoBooleanString((short)19);
    }

    public String getURL() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getURL");
        }
        return this.Con.getURL();
    }

    public String getUserName() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getUserName");
        }
        return this.getInfoString((short)47);
    }

    public boolean isReadOnly() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.isReadOnly");
        }
        return this.getInfoBooleanString((short)25);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedHigh");
        }
        return (n = this.getInfoShort((short)85)) == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedLow");
        }
        return (n = this.getInfo((short)85)) == 1;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedAtStart");
        }
        return (n = this.getInfo((short)85)) == 2;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedAtEnd");
        }
        return (n = this.getInfo((short)85)) == 4;
    }

    public String getDatabaseProductName() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDatabaseProductName");
        }
        return this.getInfoString((short)17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDatabaseProductVersion");
        }
        return this.getInfoString((short)18);
    }

    public String getDriverName() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDriverName");
        }
        return "JDBC-ODBC Bridge (" + this.getInfoString((short)6) + ")";
    }

    public String getDriverVersion() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDriverVersion");
        }
        int n = this.getDriverMinorVersion();
        String string = "";
        if (n < 1000) {
            string = String.valueOf(string) + "0";
        }
        if (n < 100) {
            string = String.valueOf(string) + "0";
        }
        if (n < 10) {
            string = String.valueOf(string) + "0";
        }
        string = String.valueOf(string) + "" + n;
        return this.getDriverMajorVersion() + "." + string + " (" + this.getInfoString((short)7) + ")";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 2001;
    }

    public boolean usesLocalFiles() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.usesLocalFiles");
        }
        return (n = this.getInfoShort((short)84)) == 2;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.usesLocalFilePerTable");
        }
        return (n = this.getInfoShort((short)84)) == 1;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMixedCaseIdentifiers");
        }
        return (n = this.getInfoShort((short)28)) == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesUpperCaseIdentifiers");
        }
        return (n = this.getInfoShort((short)28)) == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesLowerCaseIdentifiers");
        }
        return (n = this.getInfoShort((short)28)) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesMixedCaseIdentifiers");
        }
        return (n = this.getInfoShort((short)28)) == 4;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMixedCaseQuotedIdentifiers");
        }
        return (n = this.getInfoShort((short)93)) == 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesUpperCaseQuotedIdentifiers");
        }
        return (n = this.getInfoShort((short)93)) == 1;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesLowerCaseQuotedIdentifiers");
        }
        return (n = this.getInfoShort((short)93)) == 2;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesMixedCaseQuotedIdentifiers");
        }
        return (n = this.getInfoShort((short)93)) == 4;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getIdentifierQuoteString");
        }
        return this.getInfoString((short)29);
    }

    public String getSQLKeywords() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSQLKeywords");
        }
        return this.getInfoString((short)89, JdbcOdbcLimits.MAX_GET_DATA_LENGTH);
    }

    public String getNumericFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getNumericFunctions");
        }
        String string = "";
        int n = this.getInfo((short)49);
        if ((n & 1) != 0) {
            string = String.valueOf(string) + "ABS,";
        }
        if ((n & 2) != 0) {
            string = String.valueOf(string) + "ACOS,";
        }
        if ((n & 4) != 0) {
            string = String.valueOf(string) + "ASIN,";
        }
        if ((n & 8) != 0) {
            string = String.valueOf(string) + "ATAN,";
        }
        if ((n & 0x10) != 0) {
            string = String.valueOf(string) + "ATAN2,";
        }
        if ((n & 0x20) != 0) {
            string = String.valueOf(string) + "CEILING,";
        }
        if ((n & 0x40) != 0) {
            string = String.valueOf(string) + "COS,";
        }
        if ((n & 0x80) != 0) {
            string = String.valueOf(string) + "COT,";
        }
        if ((n & 0x40000) != 0) {
            string = String.valueOf(string) + "DEGREES,";
        }
        if ((n & 0x100) != 0) {
            string = String.valueOf(string) + "EXP,";
        }
        if ((n & 0x200) != 0) {
            string = String.valueOf(string) + "FLOOR,";
        }
        if ((n & 0x400) != 0) {
            string = String.valueOf(string) + "LOG,";
        }
        if ((n & 0x80000) != 0) {
            string = String.valueOf(string) + "LOG10,";
        }
        if ((n & 0x800) != 0) {
            string = String.valueOf(string) + "MOD,";
        }
        if ((n & 0x10000) != 0) {
            string = String.valueOf(string) + "PI,";
        }
        if ((n & 0x100000) != 0) {
            string = String.valueOf(string) + "POWER,";
        }
        if ((n & 0x200000) != 0) {
            string = String.valueOf(string) + "RADIANS,";
        }
        if ((n & 0x20000) != 0) {
            string = String.valueOf(string) + "RAND,";
        }
        if ((n & 0x400000) != 0) {
            string = String.valueOf(string) + "ROUND,";
        }
        if ((n & 0x1000) != 0) {
            string = String.valueOf(string) + "SIGN,";
        }
        if ((n & 0x2000) != 0) {
            string = String.valueOf(string) + "SIN,";
        }
        if ((n & 0x4000) != 0) {
            string = String.valueOf(string) + "SQRT,";
        }
        if ((n & 0x8000) != 0) {
            string = String.valueOf(string) + "TAN,";
        }
        if ((n & 0x800000) != 0) {
            string = String.valueOf(string) + "TRUNCATE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getStringFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getStringFunctions");
        }
        String string = "";
        int n = this.getInfo((short)50);
        if ((n & 0x2000) != 0) {
            string = String.valueOf(string) + "ASCII,";
        }
        if ((n & 0x4000) != 0) {
            string = String.valueOf(string) + "CHAR,";
        }
        if ((n & 1) != 0) {
            string = String.valueOf(string) + "CONCAT,";
        }
        if ((n & 0x8000) != 0) {
            string = String.valueOf(string) + "DIFFERENCE,";
        }
        if ((n & 2) != 0) {
            string = String.valueOf(string) + "INSERT,";
        }
        if ((n & 0x40) != 0) {
            string = String.valueOf(string) + "LCASE,";
        }
        if ((n & 4) != 0) {
            string = String.valueOf(string) + "LEFT,";
        }
        if ((n & 0x10) != 0) {
            string = String.valueOf(string) + "LENGTH,";
        }
        if ((n & 0x20) != 0) {
            string = String.valueOf(string) + "LOCATE,";
        }
        if ((n & 0x10000) != 0) {
            string = String.valueOf(string) + "LOCATE_2,";
        }
        if ((n & 8) != 0) {
            string = String.valueOf(string) + "LTRIM,";
        }
        if ((n & 0x80) != 0) {
            string = String.valueOf(string) + "REPEAT,";
        }
        if ((n & 0x100) != 0) {
            string = String.valueOf(string) + "REPLACE,";
        }
        if ((n & 0x200) != 0) {
            string = String.valueOf(string) + "RIGHT,";
        }
        if ((n & 0x400) != 0) {
            string = String.valueOf(string) + "RTRIM,";
        }
        if ((n & 0x20000) != 0) {
            string = String.valueOf(string) + "SOUNDEX,";
        }
        if ((n & 0x40000) != 0) {
            string = String.valueOf(string) + "SPACE,";
        }
        if ((n & 0x800) != 0) {
            string = String.valueOf(string) + "SUBSTRING,";
        }
        if ((n & 0x1000) != 0) {
            string = String.valueOf(string) + "UCASE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSystemFunctions");
        }
        String string = "";
        int n = this.getInfo((short)51);
        if ((n & 2) != 0) {
            string = String.valueOf(string) + "DBNAME,";
        }
        if ((n & 4) != 0) {
            string = String.valueOf(string) + "IFNULL,";
        }
        if ((n & 1) != 0) {
            string = String.valueOf(string) + "USERNAME,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getTimeDateFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTimeDateFunctions");
        }
        String string = "";
        int n = this.getInfo((short)52);
        if ((n & 2) != 0) {
            string = String.valueOf(string) + "CURDATE,";
        }
        if ((n & 0x200) != 0) {
            string = String.valueOf(string) + "CURTIME,";
        }
        if ((n & 0x8000) != 0) {
            string = String.valueOf(string) + "DAYNAME,";
        }
        if ((n & 4) != 0) {
            string = String.valueOf(string) + "DAYOFMONTH,";
        }
        if ((n & 8) != 0) {
            string = String.valueOf(string) + "DAYOFWEEK,";
        }
        if ((n & 0x10) != 0) {
            string = String.valueOf(string) + "DAYOFYEAR,";
        }
        if ((n & 0x400) != 0) {
            string = String.valueOf(string) + "HOUR,";
        }
        if ((n & 0x800) != 0) {
            string = String.valueOf(string) + "MINUTE,";
        }
        if ((n & 0x20) != 0) {
            string = String.valueOf(string) + "MONTH,";
        }
        if ((n & 0x10000) != 0) {
            string = String.valueOf(string) + "MONTHNAME,";
        }
        if ((n & 1) != 0) {
            string = String.valueOf(string) + "NOW,";
        }
        if ((n & 0x40) != 0) {
            string = String.valueOf(string) + "QUARTER,";
        }
        if ((n & 0x1000) != 0) {
            string = String.valueOf(string) + "SECOND,";
        }
        if ((n & 0x2000) != 0) {
            string = String.valueOf(string) + "TIMESTAMPADD,";
        }
        if ((n & 0x4000) != 0) {
            string = String.valueOf(string) + "TIMESTAMPDIFF,";
        }
        if ((n & 0x80) != 0) {
            string = String.valueOf(string) + "WEEK,";
        }
        if ((n & 0x100) != 0) {
            string = String.valueOf(string) + "YEAR,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSearchStringEscape() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSearchStringEscape");
        }
        return this.getInfoString((short)14);
    }

    public String getExtraNameCharacters() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getExtraNameCharacters");
        }
        return this.getInfoString((short)94);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsAlterTableWithAddColumn");
        }
        return ((n = this.getInfo((short)86)) & 1) > 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsAlterTableWithDropColumn");
        }
        return ((n = this.getInfo((short)86)) & 2) > 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsColumnAliasing");
        }
        return this.getInfoBooleanString((short)87);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullPlusNullIsNull");
        }
        return (n = this.getInfoShort((short)22)) == 0;
    }

    public boolean supportsConvert() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsConvert");
        }
        return (n = this.getInfo((short)48)) == 1;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsConvert (" + n + "," + n2 + ")");
        }
        short s = 0;
        int n3 = 0;
        switch (n) {
            case -7: {
                s = 55;
                break;
            }
            case -6: {
                s = 68;
                break;
            }
            case 5: {
                s = 65;
                break;
            }
            case 4: {
                s = 61;
                break;
            }
            case -5: {
                s = 53;
                break;
            }
            case 6: {
                s = 60;
                break;
            }
            case 7: {
                s = 64;
                break;
            }
            case 8: {
                s = 59;
                break;
            }
            case 2: {
                s = 63;
                break;
            }
            case 3: {
                s = 58;
                break;
            }
            case 1: {
                s = 56;
                break;
            }
            case 12: {
                s = 70;
                break;
            }
            case -1: {
                s = 62;
                break;
            }
            case 91: {
                s = 57;
                break;
            }
            case 92: {
                s = 66;
                break;
            }
            case 93: {
                s = 67;
                break;
            }
            case -2: {
                s = 54;
                break;
            }
            case -3: {
                s = 69;
                break;
            }
            case -4: {
                s = 71;
                break;
            }
        }
        int n4 = this.getInfo(s);
        switch (n2) {
            case -7: {
                n3 = 4096;
                break;
            }
            case -6: {
                n3 = 8192;
                break;
            }
            case 5: {
                n3 = 16;
                break;
            }
            case 4: {
                n3 = 8;
                break;
            }
            case -5: {
                n3 = 16384;
                break;
            }
            case 6: {
                n3 = 32;
                break;
            }
            case 7: {
                n3 = 64;
                break;
            }
            case 8: {
                n3 = 128;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 12: {
                n3 = 256;
                break;
            }
            case -1: {
                n3 = 512;
                break;
            }
            case 91: {
                n3 = 32768;
                break;
            }
            case 92: {
                n3 = 65536;
                break;
            }
            case 93: {
                n3 = 131072;
                break;
            }
            case -2: {
                n3 = 1024;
                break;
            }
            case -3: {
                n3 = 2048;
                break;
            }
            case -4: {
                n3 = 262144;
                break;
            }
        }
        return (n4 & n3) > 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsTableCorrelationNames");
        }
        return (n = this.getInfoShort((short)74)) == 1 || n == 2;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsDifferentTableCorrelationNames");
        }
        return (n = this.getInfoShort((short)74)) == 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsExpressionsInOrderBy");
        }
        return this.getInfoBooleanString((short)27);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOrderByUnrelated");
        }
        return this.getInfoBooleanString((short)90);
    }

    public boolean supportsGroupBy() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsGroupBy");
        }
        return (n = this.getInfoShort((short)88)) != 0;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsGroupByUnrelated");
        }
        return (n = this.getInfoShort((short)88)) == 3;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsGroupByBeyondSelect");
        }
        return (n = this.getInfoShort((short)88)) == 2;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsLikeEscapeClause");
        }
        return this.getInfoBooleanString((short)113);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMultipleResultSets");
        }
        return this.getInfoBooleanString((short)36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMultipleTransactions");
        }
        return this.getInfoBooleanString((short)37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsNonNullableColumns");
        }
        return (n = this.getInfoShort((short)75)) == 1;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMinimumSQLGrammar");
        }
        return (n = this.getInfoShort((short)15)) == 0 || n == 1 || n == 2;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCoreSQLGrammar");
        }
        return (n = this.getInfoShort((short)15)) == 1 || n == 2;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsExtendedSQLGrammar");
        }
        return (n = this.getInfoShort((short)15)) == 2;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsIntegrityEnhancementFacility");
        }
        return this.getInfoBooleanString((short)73);
    }

    public boolean supportsOuterJoins() throws SQLException {
        String string;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOuterJoins");
        }
        return !(string = this.getInfoString((short)38)).equalsIgnoreCase("N");
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsFullOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("F");
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsLimitedOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("P");
    }

    public String getSchemaTerm() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSchemaTerm");
        }
        return this.getInfoString((short)39);
    }

    public String getProcedureTerm() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getProcedureTerm");
        }
        return this.getInfoString((short)40);
    }

    public String getCatalogTerm() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCatalogTerm");
        }
        return this.getInfoString((short)42);
    }

    public boolean isCatalogAtStart() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.isCatalogAtStart");
        }
        return (n = this.getInfoShort((short)114)) == 1;
    }

    public String getCatalogSeparator() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCatalogSeparator");
        }
        return this.getInfoString((short)41);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInDataManipulation");
        }
        return ((n = this.getInfo((short)91)) & 1) > 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInProcedureCalls");
        }
        return ((n = this.getInfo((short)91)) & 2) > 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInTableDefinitions");
        }
        return ((n = this.getInfo((short)91)) & 4) > 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInIndexDefintions");
        }
        return ((n = this.getInfo((short)91)) & 8) > 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInPrivilegeDefintions");
        }
        return ((n = this.getInfo((short)91)) & 0x10) > 0;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInDataManipulation");
        }
        return ((n = this.getInfo((short)92)) & 1) > 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInProcedureCalls");
        }
        return ((n = this.getInfo((short)92)) & 2) > 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInTableDefinitions");
        }
        return ((n = this.getInfo((short)92)) & 4) > 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInIndexDefinitions");
        }
        return ((n = this.getInfo((short)92)) & 8) > 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInPrivilegeDefintions");
        }
        return ((n = this.getInfo((short)92)) & 0x10) > 0;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsPositionedDelete");
        }
        return ((n = this.getInfo((short)80)) & 1) > 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsPositionedUpdate");
        }
        return ((n = this.getInfo((short)80)) & 2) > 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSelectForUpdate");
        }
        return ((n = this.getInfo((short)80)) & 4) > 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsStoredProcedures");
        }
        return this.getInfoBooleanString((short)21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInComparisions");
        }
        return ((n = this.getInfo((short)95)) & 1) > 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInExists");
        }
        return ((n = this.getInfo((short)95)) & 2) > 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInIns");
        }
        return ((n = this.getInfo((short)95)) & 4) > 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInQuantifieds");
        }
        return ((n = this.getInfo((short)95)) & 8) > 0;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCorrelatedSubqueries");
        }
        return ((n = this.getInfo((short)95)) & 0x10) > 0;
    }

    public boolean supportsUnion() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsUnion");
        }
        return ((n = this.getInfo((short)96)) & 1) > 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsUnionAll");
        }
        return ((n = this.getInfo((short)96)) & 2) > 0;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenCursorsAcrossCommit");
        }
        return (n = this.getInfoShort((short)23)) == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenCursorsAcrossRollback");
        }
        return (n = this.getInfoShort((short)24)) == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenStatementsAcrossCommit");
        }
        return (n = this.getInfoShort((short)23)) == 2 || n == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenStatementsAcrossRollback");
        }
        return (n = this.getInfoShort((short)24)) == 2 || n == 1;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxBinaryLiteralLength");
        }
        return this.getInfo((short)112);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxCharLiteralLength");
        }
        return this.getInfo((short)108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnNameLength");
        }
        return this.getInfoShort((short)30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInGroupBy");
        }
        return this.getInfoShort((short)97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInIndex");
        }
        return this.getInfoShort((short)98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInOrderBy");
        }
        return this.getInfoShort((short)99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInSeleted");
        }
        return this.getInfoShort((short)100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInTable");
        }
        return this.getInfoShort((short)101);
    }

    public int getMaxConnections() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxConnections");
        }
        return this.getInfoShort((short)0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxCursorNameLength");
        }
        return this.getInfo((short)31);
    }

    public int getMaxIndexLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxIndexLength");
        }
        return this.getInfo((short)102);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxSchemaNameLength");
        }
        return this.getInfoShort((short)32);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxProcedureNameLength");
        }
        return this.getInfoShort((short)33);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxCatalogNameLength");
        }
        return this.getInfoShort((short)34);
    }

    public int getMaxRowSize() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxRowSize");
        }
        return this.getInfo((short)104);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
        }
        return this.getInfoBooleanString((short)103);
    }

    public int getMaxStatementLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxStatementLength");
        }
        return this.getInfo((short)105);
    }

    public int getMaxStatements() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxStatements");
        }
        return this.getInfoShort((short)1);
    }

    public int getMaxTableNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxTableNameLength");
        }
        return this.getInfoShort((short)35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxTablesInSelect");
        }
        return this.getInfoShort((short)106);
    }

    public int getMaxUserNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxUserNameLength");
        }
        return this.getInfoShort((short)107);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDefaultTransactionIsolation");
        }
        int n = this.getInfo((short)26);
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
        }
        return n2;
    }

    public boolean supportsTransactions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsTransactions");
        }
        return (n = this.getInfoShort((short)46)) != 0;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsTransactionIsolationLevel (" + n + ")");
        }
        if (n == 0) {
            return !this.supportsTransactions();
        }
        int n2 = this.getInfo((short)72);
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = (n2 & 1) > 0;
                break;
            }
            case 2: {
                bl = (n2 & 2) > 0;
                break;
            }
            case 4: {
                bl = (n2 & 4) > 0;
                break;
            }
            case 8: {
                bl = (n2 & 8) > 0;
                break;
            }
        }
        return bl;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
        }
        return ((n = this.getInfoShort((short)46)) & 2) > 0;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsDataManipulationTransactionsOnly");
        }
        return ((n = this.getInfoShort((short)46)) & 1) > 0;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.dataDefintionCausesTransactionCommit");
        }
        return ((n = this.getInfoShort((short)46)) & 3) > 0;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.dataDefintionIgnoredInTransactions");
        }
        return ((n = this.getInfoShort((short)46)) & 4) > 0;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getProcedures (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLProcedures(n, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getProcedureColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLProcedureColumns(n, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        int n2 = this.Con.getODBCVer();
        if (n2 >= 2) {
            jdbcOdbcResultSet.setSQLTypeColumn(6);
            if (n2 >= 3) {
                jdbcOdbcResultSet.setAliasColumnName("PRECISION", 8);
                jdbcOdbcResultSet.setAliasColumnName("LENGTH", 9);
                jdbcOdbcResultSet.setAliasColumnName("SCALE", 10);
                jdbcOdbcResultSet.setAliasColumnName("RADIX", 11);
            }
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        String string4 = null;
        SQLWarning sQLWarning = null;
        if (stringArray != null) {
            string4 = "";
            int n = 0;
            n = 0;
            while (n < stringArray.length) {
                String string5 = stringArray[n];
                if (n > 0) {
                    string4 = String.valueOf(string4) + ",";
                }
                string4 = String.valueOf(string4) + string5;
                n = (short)(n + 1);
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTables (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLTables(n, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSchemas");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("", "%", "", null);
        int[] nArray = new int[]{2};
        jdbcOdbcResultSet.setColumnMappings(nArray);
        return jdbcOdbcResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCatalogs");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("%", "", "", null);
        int[] nArray = new int[]{1};
        jdbcOdbcResultSet.setColumnMappings(nArray);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTableTypes");
        }
        String[] stringArray = new String[]{"%"};
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("", "", "", stringArray);
        int[] nArray = new int[]{4};
        jdbcOdbcResultSet.setColumnMappings(nArray);
        return jdbcOdbcResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLColumns(n, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        int n2 = this.Con.getODBCVer();
        if (n2 == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("COLUMN_DEF", 12, 254), new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0), new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0), new JdbcOdbcPseudoCol("CHAR_OCTET_LENGTH", 4, 0), new JdbcOdbcPseudoCol("ORDINAL_POSITION", 4, 0), new JdbcOdbcPseudoCol("IS_NULLABLE", 12, 254)};
            jdbcOdbcResultSet.setPseudoCols(13, 18, jdbcOdbcPseudoColArray);
            jdbcOdbcResultSet.setSQLTypeColumn(5);
        } else if (n2 >= 3) {
            jdbcOdbcResultSet.setSQLTypeColumn(5);
            jdbcOdbcResultSet.setAliasColumnName("SQL_DATETIME_SUB", 15);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getColumnPrivileges (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLColumnPrivileges(n, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTablePrivileges (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLTablePrivileges(n, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getBestRowIdentifier (" + string + "," + string2 + "," + string3 + "," + n + "," + bl + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLSpecialColumns(n2, (short)1, string, string2, string3, n, bl);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() >= 2) {
            jdbcOdbcResultSet.setSQLTypeColumn(3);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getVersionColumns (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLSpecialColumns(n, (short)2, string, string2, string3, 0, false);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() >= 2) {
            jdbcOdbcResultSet.setSQLTypeColumn(3);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getPrimaryKeys (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLPrimaryKeys(n, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getImportedKeys (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(n, null, null, null, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            jdbcOdbcResultSet.setPseudoCols(14, 14, jdbcOdbcPseudoColArray);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getExportedKeys (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(n, string, string2, string3, null, null, null);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            jdbcOdbcResultSet.setPseudoCols(14, 14, jdbcOdbcPseudoColArray);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCrossReference (" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(n, string, string2, string3, string4, string5, string6);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            jdbcOdbcResultSet.setPseudoCols(14, 14, jdbcOdbcPseudoColArray);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTypeInfo");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLGetTypeInfo(n, (short)0);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        int n2 = this.Con.getODBCVer();
        if (n2 == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[5];
            jdbcOdbcPseudoColArray[0] = new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0);
            jdbcOdbcPseudoColArray[1] = new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0);
            jdbcOdbcPseudoColArray[2] = new JdbcOdbcPseudoCol("NUM_PREC_RADIX", 5, 0);
            jdbcOdbcResultSet.setPseudoCols(16, 18, jdbcOdbcPseudoColArray);
            jdbcOdbcResultSet.setSQLTypeColumn(2);
        } else if (n2 >= 3) {
            jdbcOdbcResultSet.setSQLTypeColumn(2);
            jdbcOdbcResultSet.setAliasColumnName("PRECISION", 3);
            jdbcOdbcResultSet.setAliasColumnName("AUTO_INCREMENT", 12);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getIndexInfo (" + string + "," + string2 + "," + string3 + bl + "," + bl2 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLStatistics(n, string, string2, string3, bl, bl2);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, n, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    protected void validateConnection() throws SQLException {
        this.Con.validateConnection();
    }

    protected int getInfo(short s) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfo(this.hDbc, s);
    }

    protected int getInfoShort(short s) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoShort(this.hDbc, s);
    }

    protected boolean getInfoBooleanString(short s) throws SQLException {
        this.validateConnection();
        String string = this.OdbcApi.SQLGetInfoString(this.hDbc, s);
        return string.equalsIgnoreCase("Y");
    }

    protected String getInfoString(short s) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, s);
    }

    protected String getInfoString(short s, int n) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, s, n);
    }
}

