/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import sun.io.CharToByteDefault;
import sun.io.CharacterEncoding;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class CharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected int charOff;
    protected int byteOff;
    protected int badInputLength;
    private static String pkgString = System.getProperty("file.encoding.pkg");
    private static Class defClassCache;

    private static Class getConverterClass(String string) throws ClassNotFoundException {
        String string2 = null;
        string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        return Class.forName(String.valueOf(pkgString) + ".CharToByte" + string2);
    }

    public static CharToByteConverter getDefault() {
        if (defClassCache == null) {
            return new CharToByteDefault();
        }
        try {
            return (CharToByteConverter)defClassCache.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return new CharToByteDefault();
        }
        catch (IllegalAccessException illegalAccessException) {
            return new CharToByteDefault();
        }
    }

    public static CharToByteConverter getConverter(String string) throws UnsupportedEncodingException {
        Class clazz;
        CharToByteConverter charToByteConverter = null;
        try {
            clazz = CharToByteConverter.getConverterClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException();
        }
        try {
            charToByteConverter = (CharToByteConverter)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException();
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException();
        }
        return charToByteConverter;
    }

    public abstract String getCharacterEncoding();

    public abstract int convert(char[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException;

    public byte[] convertAll(char[] cArray) throws MalformedInputException {
        this.reset();
        boolean bl = this.subMode;
        this.subMode = true;
        byte[] byArray = new byte[this.getMaxBytesPerChar() * cArray.length];
        try {
            try {
                int n = this.convert(cArray, 0, cArray.length, byArray, 0, byArray.length);
                byte[] byArray2 = new byte[n += this.flush(byArray, this.nextByteIndex(), byArray.length)];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byte[] byArray3 = byArray2;
                Object var6_7 = null;
                this.subMode = bl;
                return byArray3;
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                throw new InternalError("this.getMaxBytesPerChar returned bad value");
            }
            catch (UnknownCharacterException unknownCharacterException) {
                throw new InternalError();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.subMode = bl;
            throw throwable;
        }
    }

    public abstract int flush(byte[] var1, int var2, int var3) throws MalformedInputException, ConversionBufferFullException;

    public abstract void reset();

    public boolean canConvert(char c) {
        try {
            char[] cArray = new char[1];
            byte[] byArray = new byte[3];
            cArray[0] = c;
            this.convert(cArray, 0, 1, byArray, 0, 3);
            return true;
        }
        catch (CharConversionException charConversionException) {
            return false;
        }
    }

    public abstract int getMaxBytesPerChar();

    public int getBadInputLength() {
        return this.badInputLength;
    }

    public int nextCharIndex() {
        return this.charOff;
    }

    public int nextByteIndex() {
        return this.byteOff;
    }

    public void setSubstitutionMode(boolean bl) {
        this.subMode = bl;
    }

    public void setSubstitutionBytes(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length > this.getMaxBytesPerChar()) {
            throw new IllegalArgumentException();
        }
        this.subBytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.subBytes, 0, byArray.length);
    }

    public String toString() {
        return "CharToByteConverter: " + this.getCharacterEncoding();
    }

    static {
        try {
            String string = System.getProperty("file.encoding", "8859_1");
            defClassCache = CharToByteConverter.getConverterClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            defClassCache = null;
        }
    }
}

