/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharDefault;
import sun.io.CharacterEncoding;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class ByteToCharConverter {
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'\ufffd'};
    protected int charOff;
    protected int byteOff;
    protected int badInputLength;
    private static String pkgString = System.getProperty("file.encoding.pkg");
    private static Class defClassCache;

    private static Class getConverterClass(String string) throws ClassNotFoundException {
        String string2 = null;
        string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        return Class.forName(String.valueOf(pkgString) + ".ByteToChar" + string2);
    }

    public static ByteToCharConverter getDefault() {
        if (defClassCache == null) {
            return new ByteToCharDefault();
        }
        try {
            return (ByteToCharConverter)defClassCache.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return new ByteToCharDefault();
        }
        catch (IllegalAccessException illegalAccessException) {
            return new ByteToCharDefault();
        }
    }

    public static ByteToCharConverter getConverter(String string) throws UnsupportedEncodingException {
        Class clazz;
        ByteToCharConverter byteToCharConverter = null;
        try {
            clazz = ByteToCharConverter.getConverterClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException();
        }
        try {
            byteToCharConverter = (ByteToCharConverter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException();
        }
        return byteToCharConverter;
    }

    public abstract String getCharacterEncoding();

    public abstract int convert(byte[] var1, int var2, int var3, char[] var4, int var5, int var6) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException;

    public char[] convertAll(byte[] byArray) throws MalformedInputException {
        this.reset();
        boolean bl = this.subMode;
        this.subMode = true;
        char[] cArray = new char[this.getMaxCharsPerByte() * byArray.length];
        try {
            try {
                int n = this.convert(byArray, 0, byArray.length, cArray, 0, cArray.length);
                char[] cArray2 = new char[n += this.flush(cArray, this.nextByteIndex(), cArray.length)];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                char[] cArray3 = cArray2;
                Object var6_7 = null;
                this.subMode = bl;
                return cArray3;
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                throw new InternalError("this.getMaxCharsBerByte returned bad value");
            }
            catch (UnknownCharacterException unknownCharacterException) {
                throw new InternalError();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.subMode = bl;
            throw throwable;
        }
    }

    public abstract int flush(char[] var1, int var2, int var3) throws MalformedInputException, ConversionBufferFullException;

    public abstract void reset();

    public int getMaxCharsPerByte() {
        return 1;
    }

    public int getBadInputLength() {
        return this.badInputLength;
    }

    public int nextCharIndex() {
        return this.charOff;
    }

    public int nextByteIndex() {
        return this.byteOff;
    }

    public void setSubstitutionMode(boolean bl) {
        this.subMode = bl;
    }

    public void setSubstitutionChars(char[] cArray) throws IllegalArgumentException {
        if (cArray.length > this.getMaxCharsPerByte()) {
            throw new IllegalArgumentException();
        }
        this.subChars = new char[cArray.length];
        System.arraycopy(cArray, 0, this.subChars, 0, cArray.length);
    }

    public String toString() {
        return "ByteToCharConverter: " + this.getCharacterEncoding();
    }

    static {
        try {
            String string = System.getProperty("file.encoding", "8859_1");
            defClassCache = ByteToCharConverter.getConverterClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            defClassCache = null;
        }
    }
}

