/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.MenuContainer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuComponentPeer;
import java.io.Serializable;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    Font font;
    private String name;
    private boolean nameExplicitlySet = false;
    boolean newEventsOnly = false;
    static final String actionListenerK = "actionL";
    static final String itemListenerK = "itemL";
    private static final long serialVersionUID = -4536902356223894379L;

    String constructComponentName() {
        return null;
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            MenuComponent menuComponent = this;
            synchronized (menuComponent) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    public void setName(String string) {
        MenuComponent menuComponent = this;
        synchronized (menuComponent) {
            this.name = string;
            this.nameExplicitlySet = true;
            return;
        }
    }

    public MenuContainer getParent() {
        return this.parent;
    }

    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            return menuContainer.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuComponentPeer menuComponentPeer = this.peer;
            if (menuComponentPeer != null) {
                Toolkit.getEventQueue().removeSourceEvents(this);
                this.peer = null;
                menuComponentPeer.dispose();
            }
            return;
        }
    }

    public boolean postEvent(Event event) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            menuContainer.postEvent(event);
        }
        return false;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.newEventsOnly || this.parent != null && this.parent instanceof MenuComponent && ((MenuComponent)((Object)this.parent)).newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
                return;
            }
            if (aWTEvent instanceof ActionEvent && this.parent != null) {
                ((MenuComponent)((Object)this.parent)).dispatchEvent(new ActionEvent(this.parent, aWTEvent.getID(), ((ActionEvent)aWTEvent).getActionCommand()));
                return;
            }
        } else {
            Event event = aWTEvent.convertToOld();
            if (event != null) {
                this.postEvent(event);
            }
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return false;
    }

    protected void processEvent(AWTEvent aWTEvent) {
    }

    protected String paramString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    protected final Object getTreeLock() {
        return Component.LOCK;
    }
}

