/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.parts.StatusLine;
import com.ibm.ivb.jface.parts.TaskIndicator;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.sun.java.swing.SwingUtilities;

abstract class ProgressiveExecution
extends Thread
implements TranslatableConstants {
    protected BrowserFrame frame;
    protected String normalText = new String();
    protected String canceledText = LogBrowser.getLBString("ComIbmIvbLogUiStatusTaskCanceled");
    protected String doneText = LogBrowser.getLBString("ComIbmIvbLogUiStatusTaskCompleted");
    private int progressedPercentage;
    private StatusLine status;
    private TaskIndicator task;

    public ProgressiveExecution(BrowserFrame browserFrame) {
        this.frame = browserFrame;
        this.status = browserFrame.getJFaceContext().getStatusLine();
        this.task = this.status.getTaskIndicator();
    }

    public void run() {
        boolean bl = false;
        int n = this.getTotalNumberOfSteps();
        int n2 = 1;
        while (n2 <= n && !bl) {
            if (this.status.isCanceled()) {
                bl = true;
                break;
            }
            if (!this.performStep(n2 - 1)) {
                bl = true;
                break;
            }
            this.progressedPercentage = n2 * 100 / n;
            SwingUtilities.invokeLater((Runnable)new 1());
            ++n2;
        }
        if (!bl && !this.actionCompletion()) {
            bl = true;
        }
        SwingUtilities.invokeLater((Runnable)new 2());
    }

    protected abstract int getTotalNumberOfSteps();

    protected abstract boolean performStep(int var1);

    protected boolean actionCompletion() {
        return true;
    }

    protected void actionFinalize() {
        this.setActionEndStatus();
    }

    public void setActionBeginStatus() {
        this.status.setMessage(this.normalText);
        this.status.setCancelEnabled(true);
        this.status.setStatusIcon(StatusLine.waitIcon);
        this.task.setStyle(4);
        this.task.initializeProgress(0, 100, 0);
        this.task.setPostfixText("%");
    }

    public void setActionEndStatus() {
        this.task.setActive(false);
        this.status.setMessage(this.status.isCanceled() ? this.canceledText : this.doneText);
        this.status.setCancelEnabled(false);
        this.status.setStatusIcon(StatusLine.okIcon);
    }

    public void setActionNormalText(String string) {
        this.normalText = string;
    }

    public void setActionCanceledText(String string) {
        this.canceledText = string;
    }

    public void setActionCompletedText(String string) {
        this.doneText = string;
    }

    private final class 1
    implements Runnable {
        public void run() {
            ProgressiveExecution.this.task.setValue(ProgressiveExecution.this.progressedPercentage);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Runnable {
        public synchronized void run() {
            ProgressiveExecution.this.actionFinalize();
        }

        /* synthetic */ 2() {
        }
    }
}

