/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.log.tree.LogTreeModel;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.LogChooser;
import com.ibm.ivb.log.ui.LogView;
import com.ibm.ivb.log.ui.OpenLogExecution;
import com.ibm.ivb.log.ui.ProgressiveAction;
import com.ibm.ivb.log.ui.ProgressiveExecution;
import com.ibm.ivb.log.ui.TranslatableConstants;
import java.awt.Component;
import java.io.File;

public class OpenLogAction
extends ProgressiveAction
implements TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected File[] logFiles;
    protected LogTreeModel model;
    protected LogView logView;

    public OpenLogAction(LogView logView) {
        super(logView.getParentFrame(), LogBrowser.getLBString("ComIbmIvbLogUiStatusOpenLogs"));
        this.setTool(logView);
        this.logView = logView;
    }

    public OpenLogAction(BrowserFrame browserFrame, String[] stringArray) {
        super(browserFrame, LogBrowser.getLBString("ComIbmIvbLogUiStatusOpenLogs"));
        if (stringArray != null) {
            this.logFiles = new File[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.logFiles[n] = LogTreeModel.getFullPath(stringArray[n]);
                ++n;
            }
        }
        this.logView = null;
    }

    protected boolean actionPreparation() {
        this.model = new LogTreeModel();
        if (this.logFiles != null) {
            return true;
        }
        if (this.logView != null && this.logView.closeOpenedLogs()) {
            this.logFiles = LogChooser.getLogs(0, (Component)this.getTool().getParentFrame());
            return this.logFiles != null;
        }
        return false;
    }

    protected ProgressiveExecution getProgressiveExecution() {
        OpenLogExecution openLogExecution = new OpenLogExecution(this.frame, this.logFiles, this.model, this.logView);
        openLogExecution.setActionNormalText(LogBrowser.getLBString("ComIbmIvbLogUiStatusOpenLogs"));
        this.logFiles = null;
        return openLogExecution;
    }

    public LogTreeModel getModel() {
        return this.model;
    }
}

