/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.HelpHandler;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.ui.AdvAnalyzeSelectedAction;
import com.ibm.ivb.log.ui.AnalyzeSelectedAction;
import com.ibm.ivb.log.ui.FindAndReplaceDialog;
import com.ibm.ivb.log.ui.InformationPanel;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.MenuItemAction;
import com.ibm.ivb.log.ui.SaveSelectedAction;
import com.ibm.ivb.log.ui.TextSelectionManager;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.util.FindAndReplace;
import com.sun.java.swing.Action;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.HyperlinkEvent;
import com.sun.java.swing.event.HyperlinkListener;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.JTextComponent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class InfoHtmlPanel
extends JScrollPane
implements InformationPanel,
HyperlinkListener,
TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private JEditorPane html = new JEditorPane();
    private RecordNode node;
    private JPopupMenu popup;
    private static AnalyzeSelectedAction actAnalyze;
    private static AdvAnalyzeSelectedAction actAdvAnalyze;
    private static SaveSelectedAction actSave;
    private static CopyAction actCopy;
    private static FindAction actFind;
    private static FindAgainAction actFindAgain;
    private static SelectAllAction actSelectAll;

    public InfoHtmlPanel() {
        super(20, 30);
        this.html.addMouseListener(new MouseHandler());
        this.html.setEditable(false);
        this.html.addHyperlinkListener((HyperlinkListener)this);
        this.getViewport().add((Component)this.html);
    }

    public int search(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return FindAndReplace.find(this.getText(), string, n, bl, bl2, bl3, bl4);
    }

    public void processSearchResult(int n, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch((Component)((Object)this));
            return;
        }
        this.select(n, n + string.length());
    }

    public int getSearchStart(boolean bl) {
        if (bl) {
            return this.getSelectionEnd();
        }
        return this.getSelectionStart();
    }

    public int getReplaceStart() {
        return this.getSelectionEnd();
    }

    public void processRepeatSearchResult(int n, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch();
            return;
        }
        this.select(n, n + string.length());
    }

    public void searchAndReplace(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
        int n2 = this.search(string, n, bl, bl2, bl3, bl4);
        this.processReplace(n2, string.length(), string2);
    }

    public void processReplace(int n, int n2, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch((Component)this.html);
            return;
        }
        String string2 = this.getText();
        this.html.setText(String.valueOf(string2.substring(0, n)) + string + string2.substring(n + n2));
        this.select(n, n + string.length());
    }

    public boolean isEditable() {
        return false;
    }

    public boolean hasSelection() {
        return this.html.getSelectionEnd() > this.html.getSelectionStart();
    }

    public String getSelection() {
        return this.html.getSelectedText();
    }

    public RecordNode getNode() {
        return this.node;
    }

    public void setNode(RecordNode recordNode) {
        this.node = recordNode;
    }

    public JTextComponent getTextComponent() {
        return this.html;
    }

    public void requestFocus() {
        this.html.requestFocus();
    }

    public void cut() {
    }

    public void copy() {
        this.html.copy();
    }

    public void paste() {
    }

    public void find() {
        new FindAndReplaceDialog((JFrame)LBUtilities.getBrowserFrame((Component)((Object)this)), this, false);
    }

    public void findAgain() {
        FindAndReplaceDialog.findAgain(this);
    }

    public void replace() {
    }

    public void selectAll() {
        this.html.selectAll();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            if (this.getContentUrl().getFile().equals(uRL.getFile())) {
                this.handleLinkWithinPage(uRL.getRef());
                return;
            }
            HelpHandler helpHandler = LogBrowser.getLBApplication().getHelpHandler();
            helpHandler.showURL(helpHandler.getURLName(uRL.toString()));
        }
    }

    URL getContentUrl() {
        return this.html.getPage();
    }

    void loadPage(String string) {
        if (string != null) {
            try {
                URL uRL = new URL(string);
                SwingUtilities.invokeLater((Runnable)new PageLoader(uRL, false));
                return;
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = LogBrowser.getLBString("ComIbmIvbLogUiMsgErrorUrl");
                string2 = FindAndReplace.replace(string2, "%1", string);
                this.displayErrorMessage(String.valueOf(string2) + "\n" + malformedURLException);
                return;
            }
        }
    }

    void handleAnalysisResult(String string) {
        int n = string.lastIndexOf("#");
        if (n > -1) {
            this.scrollToReference(string.substring(n + 1));
        }
    }

    private void displayErrorMessage(String string) {
        SwingUtilities.invokeLater((Runnable)new 1(string, this));
    }

    private String getText() {
        return this.html.getText();
    }

    private void select(int n, int n2) {
        this.html.setCaretPosition(n);
        this.html.moveCaretPosition(n2);
    }

    private int getSelectionStart() {
        return this.html.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.html.getSelectionEnd();
    }

    void scrollToReference(String string) {
        if (string == null || string.trim().length() < 1) {
            return;
        }
        this.scrollTo(string);
    }

    private void scrollTo(String string) {
        int n;
        if (!Character.isDigit(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = this.search(string, 0, true, false, false, false)) == -1) {
            n = 0;
        }
        this.scrollTo(n);
    }

    private void scrollTo(int n) {
        if (this.html.getPage() == null) {
            return;
        }
        this.html.setCaretPosition(n);
        SwingUtilities.invokeLater((Runnable)new 2(n, this));
    }

    private void handleLinkWithinPage(String string) {
        this.scrollToReference(string);
    }

    private boolean handlePopup(JPopupMenu jPopupMenu) {
        if (this.node == null) {
            return false;
        }
        actAnalyze = new AnalyzeSelectedAction((Component)this.html, this.node);
        actAdvAnalyze = new AdvAnalyzeSelectedAction((Component)this.html, this.node);
        actSave = new SaveSelectedAction((Component)this.html, this.node);
        actCopy = new CopyAction();
        actFind = new FindAction();
        actFindAgain = new FindAgainAction();
        actSelectAll = new SelectAllAction();
        jPopupMenu.add((Action)actAnalyze);
        jPopupMenu.add((Action)actAdvAnalyze);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actSave);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actCopy);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actFind);
        jPopupMenu.add((Action)actFindAgain);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actSelectAll);
        if (this.node.isAnalysisDone()) {
            actAnalyze.setEnabled(false);
        }
        if (this.node.isAdvanceAnalysisDone()) {
            actAdvAnalyze.setEnabled(false);
        }
        if (!this.hasSelection()) {
            actCopy.setEnabled(false);
        }
        if (!FindAndReplaceDialog.canFindAgain()) {
            actFindAgain.setEnabled(false);
        }
        return true;
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ String val$msg;
        private final /* synthetic */ InfoHtmlPanel this$0;

        public void run() {
            JOptionPane.showMessageDialog((Component)LBUtilities.getBrowserFrame((Component)this.this$0.html), (Object)this.val$msg, (String)LogBrowser.getLBString("ComIbmIvbLogUiTitleErrorMsgBox"), (int)0);
        }

        /* synthetic */ 1(String string, InfoHtmlPanel infoHtmlPanel) {
            this.val$msg = string;
            this.this$0 = infoHtmlPanel;
        }
    }

    private static final class 2
    implements Runnable {
        private final /* synthetic */ int val$index;
        private final /* synthetic */ InfoHtmlPanel this$0;

        public synchronized void run() {
            try {
                Rectangle rectangle = this.this$0.html.modelToView(this.val$index);
                if (rectangle != null) {
                    int n = rectangle.y;
                    int n2 = this.this$0.getViewport().getViewPosition().x;
                    this.this$0.getViewport().setViewPosition(new Point(n2, n));
                    return;
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        /* synthetic */ 2(int n, InfoHtmlPanel infoHtmlPanel) {
            this.val$index = n;
            this.this$0 = infoHtmlPanel;
        }
    }

    class PageLoader
    implements Runnable {
        private URL url;
        private boolean keep;

        PageLoader(URL uRL, boolean bl) {
            InfoHtmlPanel.this = InfoHtmlPanel.this;
            this.url = uRL;
            this.keep = bl;
        }

        public void run() {
            if (this.url != null) {
                Document document = InfoHtmlPanel.this.html.getDocument();
                try {
                    InfoHtmlPanel.this.html.setPage(this.url);
                    return;
                }
                catch (IOException iOException) {
                    if (this.keep) {
                        InfoHtmlPanel.this.html.setDocument(document);
                    } else {
                        InfoHtmlPanel.this.html.setText(new String());
                    }
                    Toolkit.getDefaultToolkit().beep();
                    String string = LogBrowser.getLBString("ComIbmIvbLogUiMsgErrorAccessingUrl");
                    string = FindAndReplace.replace(string, "%1", this.url.toString());
                    InfoHtmlPanel.this.displayErrorMessage(String.valueOf(string) + "\n" + iOException);
                    return;
                }
            }
        }
    }

    class MouseHandler
    extends MouseAdapter
    implements Runnable {
        private Point location;

        public void mousePressed(MouseEvent mouseEvent) {
            if (InfoHtmlPanel.this.html.getCursor().getType() != 3 && mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent.getPoint());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (InfoHtmlPanel.this.html.getCursor().getType() != 3 && mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent.getPoint());
            }
        }

        private void createPopup(Point point) {
            if (InfoHtmlPanel.this.popup == null) {
                InfoHtmlPanel.this.popup = new JPopupMenu();
            }
            InfoHtmlPanel.this.popup.removeAll();
            if (InfoHtmlPanel.this.handlePopup(InfoHtmlPanel.this.popup)) {
                this.location = point;
                SwingUtilities.invokeLater((Runnable)this);
            }
        }

        public synchronized void run() {
            InfoHtmlPanel.this.select(TextSelectionManager.getSelectionStart(), TextSelectionManager.getSelectionEnd());
            InfoHtmlPanel.this.popup.show((Component)InfoHtmlPanel.this.html, this.location.x, this.location.y);
        }

        MouseHandler() {
            InfoHtmlPanel.this = InfoHtmlPanel.this;
        }
    }

    class CopyAction
    extends MenuItemAction
    implements TranslatableConstants {
        CopyAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupCopy"));
            InfoHtmlPanel.this = InfoHtmlPanel.this;
        }

        public synchronized void run() {
            InfoHtmlPanel.this.copy();
        }
    }

    class FindAction
    extends MenuItemAction
    implements TranslatableConstants {
        FindAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupFind"));
            InfoHtmlPanel.this = InfoHtmlPanel.this;
        }

        public synchronized void run() {
            InfoHtmlPanel.this.find();
        }
    }

    class FindAgainAction
    extends MenuItemAction
    implements TranslatableConstants {
        FindAgainAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupFindAgain"));
            InfoHtmlPanel.this = InfoHtmlPanel.this;
        }

        public synchronized void run() {
            InfoHtmlPanel.this.findAgain();
        }
    }

    class SelectAllAction
    extends MenuItemAction
    implements TranslatableConstants {
        SelectAllAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupSelectAll"));
            InfoHtmlPanel.this = InfoHtmlPanel.this;
        }

        public synchronized void run() {
            InfoHtmlPanel.this.selectAll();
        }
    }
}

