/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef HWSERROR_HPP
#define HWSERROR_HPP

#include "hws.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hwsutil.hpp"

#define ERRBUF_LEN   MAX_NUM_ERRORS*ERRDATA_LEN

typedef enum  { HWSNON
               ,HWSCOM
               ,HWSUTL
               ,HWSFMT
               ,HWSMSG
               ,HWSLPG
               ,HWSSEG
               ,HWSFLD
               ,HWSTRN} COMPID;   /* Component Id */

//  The HWSError class defines the error handling object.
//  An HWSError object will be passed as the first parameter of all
//  IMS WWW Connection's internal methods.
class DllExport HWSError {

  // Public access
  public:

     // Member functions
     HWSError(char * logFilePath);      // Constructor.
     ~HWSError();                   // Destructor.

     // ...Return current error code or 0;
     int  error();

     // ...Return current error string or null;
     char * errorStr();

     // ...resets the current error pointer;
     void reset();

     // ...Add error to object.  Push down if no room.
     void addErr(int errCode, char *errStr );

     // ...Add log record to the log file if DEBUG mode 
     void logEntry(COMPID compID, char * logMsg );
     void logMsg  (COMPID compID, char * logMsg );
     void logExit (COMPID compID, char * logMsg );

     // ...Return error information as string.
     char *export();

  // Private access
  private:

     // Member data
     int       errCode;
     char      errString[ERRDATA_LEN+1];
     short     numError;
     char      buffer[ERRBUF_LEN];

     FILE * logFile;
     COMPID currentCompID;
     int    logLevel;

     HWSUtil * util;
};

#endif
