/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/**********************************************************************/
/* Change History:                                                    */
/*                                                                    */
/* 05/06/98  JEH  PTM2467  Clean up error messages for 2.1.           */
/*                                                                    */
/**********************************************************************/
#ifndef HWSECVTE_H
#define HWSECVTE_H

/*--------------------------------------------------------------------*/
/* HWSConverter class external error messages.                        */
/* 2100 - 2199                                                       */
/*--------------------------------------------------------------------*/
#define  HWSC_PRIOR_OPEN                         2500
#define  HWSC_PRIOR_OPEN_S                       "Prior open; this open is invalid."
// Explanation:  The open method may only be invoked once per HWSConverter instance.
// User Action:  If you wish to change the language or Endian information for the
//               HWSConverter instance you must invoke the close method before
//               re-invoking the open method.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_INVALID_LANG                       2501
#define  HWSC_INVALID_LANG_S                     "Invalid language."
// Explanation:  The value you specified for the language parameter of the open method
//               is not supported.
// User Action:  Refer to the docmentation of the HWSConverter class for the supported
//               values for the language parameter.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_UNKNOWN_ENDIAN                     2502
#define  HWSC_UNKNOWN_ENDIAN_S                   "Unknown endian."
// Explanation:  The value you specified for the clientEndian parameter of the open method
//               is not supported.
// User Action:  Refer to the docmentation of the HWSConverter class for the supported
//               values for the clientEndian parameter.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_CONVID_TBL                      2503
#define  HWSC_NO_CONVID_TBL_S                    "Conversion table missing or invalid."
// Explanation:  A file containing one of the tables used to convert IMS message data
//               was missing or invalid.
// User Action:  This is most likely an installation error.
//               For OS/2, verify that the HWSPATH environment variable is set
//               to the path where IMS Web Runtime is installed.
//               For Windows NT, use REGEDIT to verify that the value of HWSPATH in the registry
//               is set to the path where IMS Web Runtime is installed.  For AIX and OS/390 IMS Web Runtime
//               is installed in /usr/lpp/imsweb.  In addition, verify that the installation directory contains
//               conversion table files of the form ctblxxxx.tbl for all the languages supported by IMS Web.
#define  HWSC_NO_PRIOR_OPEN                      2504
#define  HWSC_NO_PRIOR_OPEN_S                    "Open not performed prior to close."
// Explanation:  The HWSConverter instance must be open in order to invoke the close method.
// User Action:  Inovke the open method prior to invoking the close method.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_XLATE_TARGET_LENGTH_EXCEEDED       2505
#define  HWSC_XLATE_TARGET_LENGTH_EXCEEDED_S     "Target length exceeded during conversion."
// Explanation:  The number of bytes provided for the coverted data (tarLength) is not
//               sufficient for the conversion.
// User Action:  Check the length of the source data and adjust the target length accordingly.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_OPEN                            2506
#define  HWSC_NO_OPEN_S                          "Open must be invoked prior to convert."
// Explanation:  The HWSConverter instance must be open in order to invoke the conversion methods.
// User Action:  Inovke the open method, prior to invoking the conversion methods, to establish
//               the language and endian for conversion,
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_XLATE_SOURCE_LENGTH_EXCEEDED       2507
#define  HWSC_XLATE_SOURCE_LENGTH_EXCEEDED_S     "Source string length exceeded during conversion."
// Explanation:  The data provided for conversion was invalid.
// User Action:  Verify that the length provided for the data to be converted includes all the bytes to be
//               converted, including both bytes of any double byte data and any shiftout/shiftin characters, if applicable.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_SHORT_TARGET_LENGTH_FOR_SI         2508
#define  HWSC_SHORT_TARGET_LENGTH_FOR_SI_S       "Could not add ShiftIn - target length too small."
// Explanation:  The number of bytes provided for the converted data (tarLength) is not
//               sufficient for conversion.
// User Action:  Keep in mind that, for double byte data, the target length must allow for additional
//               (shiftout/shiftin) characters when converting to IMS format.  Adjust the target length
//               accordingly.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_NO_TRAIL                           2509
#define  HWSC_NO_TRAIL_S                         "No trailing (second) byte found for a DBCS character."
// Explanation:  The data provided for conversion is incomplete.
// User Action:  Ensure that, in the case of double byte data, the length of the source includes
//               both bytes of trailing double byte data.  Adjust the target length accordingly.
//               If you received this message from IMS Web, contact your IBM service representative.
#define  HWSC_OUT_OF_STORAGE                     2510
#define  HWSC_OUT_OF_STORAGE_S                   "Unable to obtain sufficient virtual storage."
// Explanation:  The HWSConverter class was unable to obtain sufficient virtural storage for use by the
//               conversion methods.
// User Action:  Reduce your system's demands for virtal storage.
#define  HWSC_NO_HWSPATH                         2511
#define  HWSC_NO_HWSPATH_S                       "Path to conversion tables missing."
// Explanation:  You failed to provide a path to the conversion tables when the HWSConverter instance was
//               created.
// User Action:  Refer to the documentation of the HWSConverter class for a description of the path
//               parameter.
//               If you received this message from IMS Web, contact your IBM service representative.
#endif
