/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.multimedia.AnimatorImage;

public class Animator
extends Canvas
implements Runnable,
PropertyChangeListener {
    protected int delay = 500;
    protected int numLoops = 1;
    protected boolean forever = true;
    protected Vector images = new Vector();
    protected transient Image currentImage = null;
    protected transient Thread displayThread;
    protected int maxWidth = 0;
    protected int maxHeight = 0;
    protected boolean clearFrame = false;
    protected boolean previewMode = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public Animator() {
        this.changes.addPropertyChangeListener(this);
    }

    public void setDelay(int newDelay) throws PropertyVetoException {
        if (this.delay != newDelay) {
            Integer oldDelayInt = new Integer(this.delay);
            Integer newDelayInt = new Integer(newDelay);
            this.vetos.fireVetoableChange("Delay", oldDelayInt, newDelayInt);
            this.delay = newDelay;
            this.changes.firePropertyChange("Delay", oldDelayInt, newDelayInt);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setNumLoops(int newNumLoops) throws PropertyVetoException {
        if (this.numLoops != newNumLoops) {
            Integer oldNumLoopsInt = new Integer(this.numLoops);
            Integer newNumLoopsInt = new Integer(newNumLoops);
            this.vetos.fireVetoableChange("NumLoops", oldNumLoopsInt, newNumLoopsInt);
            this.numLoops = newNumLoops;
            this.changes.firePropertyChange("NumLoops", oldNumLoopsInt, newNumLoopsInt);
        }
    }

    public int getNumLoops() {
        return this.numLoops;
    }

    public void setRepeatMode(boolean newRepeatMode) throws PropertyVetoException {
        if (this.forever != newRepeatMode) {
            Boolean oldRepeatModeBool = new Boolean(this.forever);
            Boolean newRepeatModeLoopsBool = new Boolean(newRepeatMode);
            this.vetos.fireVetoableChange("RepeatMode", oldRepeatModeBool, newRepeatModeLoopsBool);
            this.forever = newRepeatMode;
            this.changes.firePropertyChange("RepeatMode", oldRepeatModeBool, newRepeatModeLoopsBool);
        }
    }

    public boolean getRepeatMode() {
        return this.isRepeatMode();
    }

    public boolean isRepeatMode() {
        return this.forever;
    }

    public synchronized void setImageList(URL[] newImageList) throws PropertyVetoException {
        boolean wasAnimating;
        boolean bl = wasAnimating = this.displayThread != null;
        if (wasAnimating) {
            this.stopAnimation();
        }
        URL[] oldImageList = this.getImageList();
        this.vetos.fireVetoableChange("ImageList", oldImageList, newImageList);
        this.currentImage = null;
        this.images = new Vector();
        int i = 0;
        while (i < newImageList.length) {
            this.addImage(newImageList[i]);
            ++i;
        }
        this.changes.firePropertyChange("ImageList", oldImageList, newImageList);
        if (wasAnimating || this.previewMode || !Beans.isDesignTime()) {
            this.startAnimation();
        } else if (newImageList.length > 0) {
            this.currentImage = ((AnimatorImage)this.images.elementAt((int)0)).image;
        }
        this.repaint();
    }

    public synchronized URL[] getImageList() {
        URL[] list = new URL[this.images.size()];
        int i = 0;
        Enumeration enumeration = this.images.elements();
        while (enumeration.hasMoreElements()) {
            list[i++] = ((AnimatorImage)enumeration.nextElement()).url;
        }
        return list;
    }

    public void setClearFrame(boolean newClearFrame) throws PropertyVetoException {
        this.clearFrame = newClearFrame;
        if (this.clearFrame) {
            Boolean oldClearFrameBool = new Boolean(this.clearFrame);
            Boolean newClearFrameBool = new Boolean(newClearFrame);
            this.vetos.fireVetoableChange("ClearFrame", oldClearFrameBool, newClearFrameBool);
            this.clearFrame = newClearFrame;
            this.changes.firePropertyChange("ClearFrame", oldClearFrameBool, newClearFrameBool);
        }
    }

    public boolean getClearFrame() {
        return this.isClearFrame();
    }

    public boolean isClearFrame() {
        return this.clearFrame;
    }

    public void setPreviewMode(boolean newPreviewMode) {
        if (this.previewMode != newPreviewMode && Beans.isDesignTime()) {
            this.previewMode = newPreviewMode;
            if (this.previewMode && this.images.size() > 0) {
                this.startAnimation();
            } else {
                this.stopAnimation();
            }
        }
    }

    public boolean getPreviewMode() {
        return this.isPreviewMode();
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    public synchronized void addImage(URL url) {
        boolean loadWait;
        Image image = this.getToolkit().getImage(url);
        boolean bl = loadWait = this.images.size() == 0 || this.previewMode || !Beans.isDesignTime();
        if (loadWait) {
            this.imageLoadWait(image);
        }
        this.images.addElement(new AnimatorImage(url, image, loadWait, this));
    }

    public void startAnimation() {
        if (this.displayThread == null) {
            this.displayThread = new Thread(this);
            this.displayThread.start();
        } else {
            try {
                this.displayThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.displayThread = new Thread(this);
            this.displayThread.start();
        }
    }

    public void stopAnimation() {
        if (this.displayThread != null) {
            this.displayThread.stop();
            this.displayThread = null;
        }
    }

    public synchronized void run() {
        int i = 0;
        while (i < this.numLoops || this.forever) {
            if (this.images.size() == 0) {
                try {
                    this.wait(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                int j = 0;
                while (j < this.images.size()) {
                    Animator animator = this;
                    synchronized (animator) {
                        try {
                            this.wait(this.delay);
                        }
                        catch (InterruptedException interruptedException) {}
                        AnimatorImage ai = (AnimatorImage)this.images.elementAt(j);
                        if (!ai.loaded) {
                            this.imageLoadWait(ai.image);
                            this.images.setElementAt(new AnimatorImage(ai.url, ai.image, true), j);
                        }
                        this.currentImage = ai.image;
                    }
                    this.repaint();
                    ++j;
                }
            }
            ++i;
        }
    }

    public synchronized void paint(Graphics g) {
        if (this.currentImage != null) {
            g.drawImage(this.currentImage, 0, 0, this);
        }
    }

    public void update(Graphics g) {
        if (this.clearFrame) {
            super.update(g);
        } else {
            this.paint(g);
        }
    }

    public Dimension preferredSize() {
        if (this.images == null || this.images.size() == 0) {
            return new Dimension(10, 10);
        }
        return new Dimension(this.maxWidth, this.maxHeight);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property != null && property.equalsIgnoreCase("RepeatMode")) {
            this.startAnimation();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    void imageLoadWait(Image image) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        int size = image.getWidth(this);
        if (size > this.maxWidth) {
            this.maxWidth = size;
        }
        if ((size = image.getHeight(this)) > this.maxHeight) {
            this.maxHeight = size;
        }
    }
}

