/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.awt.BorderPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public class RadioButtonGroupPanel
extends BorderPanel
implements ItemSelectable {
    protected CheckboxGroup group;
    protected Vector rbList;
    protected ItemListener itemListener;
    protected int tempSelectionIndex;
    protected boolean isAdded = false;
    protected transient ResourceBundle errors;
    private IL item;
    private IV indexVeto;
    private Checkbox lastItem;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public RadioButtonGroupPanel() {
        this.group = new CheckboxGroup();
        try {
            this.setPaddingTop(0);
            this.setPaddingBottom(0);
            this.setPaddingLeft(0);
            this.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.rbList = new Vector();
        this.item = new IL();
        this.tempSelectionIndex = -1;
    }

    public Object[] getSelectedObjects() {
        Object[] object = new Object[]{this.getSelectedRadioButton()};
        return object;
    }

    public synchronized void setSelectedRadioButton(Checkbox rb) throws PropertyVetoException {
        Checkbox oldValue = this.getSelectedRadioButton();
        if (!GeneralUtils.objectsEqual(rb, oldValue)) {
            this.vetos.fireVetoableChange("selectedRadioButton", oldValue, rb);
            this.group.setSelectedCheckbox(rb);
            this.sourceItemEvent(rb);
            this.changes.firePropertyChange("selectedRadioButton", oldValue, this.getSelectedRadioButton());
        }
    }

    public Checkbox getSelectedRadioButton() {
        return this.group.getSelectedCheckbox();
    }

    public synchronized void setSelectedRadioButtonIndex(int index) throws PropertyVetoException {
        Integer oldValue;
        this.tempSelectionIndex = index;
        if (this.isAdded && (oldValue = new Integer(this.getSelectedRadioButtonIndex())) != index) {
            Integer newValue = new Integer(index);
            this.vetos.fireVetoableChange("selectedRadioButtonIndex", oldValue, newValue);
            this.setSelectedRadioButton((Checkbox)this.rbList.elementAt(index));
            this.changes.firePropertyChange("selectedRadioButtonIndex", oldValue, newValue);
        }
    }

    public int getSelectedRadioButtonIndex() {
        Checkbox cb = this.getSelectedRadioButton();
        if (cb != null && this.rbList.contains(cb)) {
            int i = 0;
            while (i < this.rbList.size()) {
                if ((Checkbox)this.rbList.elementAt(i) == cb) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[selectedRadioButton=" + this.getSelectedRadioButton() + "]";
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        if (comp instanceof Checkbox) {
            ((Checkbox)comp).removeItemListener(this.item);
            this.rbList.removeElement(comp);
        }
        super.remove(index);
    }

    public void removeAll() {
        Component[] comp = this.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] instanceof Checkbox) {
                ((Checkbox)comp[i]).removeItemListener(this.item);
            }
            ++i;
        }
        this.rbList = new Vector();
        super.removeAll();
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        if (this.indexVeto == null) {
            this.indexVeto = new IV();
            this.addSelectedRadioButtonIndexListener(this.indexVeto);
        }
        this.isAdded = true;
    }

    public synchronized void removeNotify() {
        if (this.indexVeto != null) {
            this.removeSelectedRadioButtonIndexListener(this.indexVeto);
            this.indexVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addSelectedRadioButtonIndexListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("selectedRadioButtonIndex", listener);
    }

    public synchronized void removeSelectedRadioButtonIndexListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("selectedRadioButtonIndex", listener);
    }

    public synchronized void addSelectedRadioButtonIndexListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("selectedRadioButtonIndex", listener);
    }

    public synchronized void removeSelectedRadioButtonIndexListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("selectedRadioButtonIndex", listener);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    protected boolean isValidSelectedRadioButtonIndex(int index) {
        return this.rbList != null && index < this.rbList.size() && index >= 0;
    }

    protected void sourceItemEvent(Checkbox item) {
        if (item != this.lastItem) {
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, item, item.getState() ? 1 : 2));
            }
            this.lastItem = item;
        }
    }

    protected void addImpl(Component component, Object constraints, int index) {
        block2: {
            this.moveIntoGroup(component);
            super.addImpl(component, constraints, index);
            if (!this.isValidSelectedRadioButtonIndex(this.tempSelectionIndex)) break block2;
            try {
                this.setSelectedRadioButtonIndex(this.tempSelectionIndex);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    protected void moveIntoGroup(Component component) {
        if (!(component instanceof Checkbox)) {
            return;
        }
        Checkbox checkBox = (Checkbox)component;
        boolean savedState = checkBox.getState();
        checkBox.setCheckboxGroup(this.group);
        if (savedState) {
            checkBox.setState(savedState);
        }
        checkBox.addItemListener(this.item);
        this.rbList.addElement(checkBox);
    }

    class IL
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            RadioButtonGroupPanel.this.sourceItemEvent((Checkbox)e.getSource());
        }

        IL() {
            RadioButtonGroupPanel.this = RadioButtonGroupPanel.this;
        }
    }

    class IV
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!RadioButtonGroupPanel.this.isValidSelectedRadioButtonIndex(i)) {
                throw new PropertyVetoException(String.valueOf(RadioButtonGroupPanel.this.errors.getString("InvalidSelectedRadioButtonIndex")) + i, e);
            }
        }

        IV() {
            RadioButtonGroupPanel.this = RadioButtonGroupPanel.this;
        }
    }
}

