/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.SoftBevelBorder;

public class hlcsearchBook
extends JDialog {
    private JComboBox prevSearchCBox;
    private JTextField searchReqTField;
    private hlcHelperList searchResList;
    private int numHits;
    private JLabel nHits;
    private JButton run;
    private JButton reset;
    private JButton cancel;
    private JButton help;
    private JToggleButton exact;
    private JToggleButton exactnocase;
    private JToggleButton fuzzy;
    private JToggleButton sequence;
    private JToggleButton importance;
    private JToggleButton title;
    private JToggleButton text;
    private JToggleButton words;
    private JToggleButton operators;
    private JButton b_and;
    private JButton b_or;
    private JButton b_not;
    private JButton b_quote;
    private JButton b_paren;
    private JButton b_comma;
    private JButton b_equal;
    private JButton b_qmark;
    private JLabel sReqLabel;
    private JLabel sResLabel;
    private JScrollPane searchResScroll;
    private String bname = "";
    private String runDir;
    private String userDataDirectory = "";
    private Vector hitList;
    private int searchtoken;
    public static final String SEARCH_HIT_PROPERTY = "SEARCH_HIT_PROPERTY";
    public static final String EXIT_PROPERTY = "EXIT_SEARCH_PROPERTY";
    public static final String SEARCH_RUN_PROPERTY = "SEARCH_RUN_PROPERTY";
    public static final String SEARCH_OPTIONS_PROPERTY = "SEARCH_OPTIONS_PROPERTY";
    public static final String EXIT_SIZE_PROPERTY = "EXIT_SIZE_PROPERTY_BOOK";
    public static final String RESET_SEARCH_PROPERTY = "RESET_SEARCH_PROPERTY";
    private static String searchArgument = new String();
    Font lt = new Font("Dialog", 0, 11);
    private String spref;
    private String defaultSpref;
    int width = 537;
    int height = 415;
    JDialog dialog = this;
    private boolean state = false;

    public void setButtonsOn(boolean state) {
        this.state = state;
        if (state) {
            this.operators.setBorder(new SoftBevelBorder(1));
            this.operators.setSelected(true);
        } else {
            this.operators.setBorder(new SoftBevelBorder(0));
            this.operators.setSelected(false);
        }
        this.b_and.setEnabled(state);
        this.b_and.setVisible(state);
        this.b_or.setEnabled(state);
        this.b_or.setVisible(state);
        this.b_not.setEnabled(state);
        this.b_not.setVisible(state);
        this.b_quote.setEnabled(state);
        this.b_quote.setVisible(state);
        this.b_paren.setEnabled(state);
        this.b_paren.setVisible(state);
        this.b_comma.setEnabled(state);
        this.b_comma.setVisible(state);
        this.b_equal.setEnabled(state);
        this.b_equal.setVisible(state);
        this.b_qmark.setEnabled(state);
        this.b_qmark.setVisible(state);
    }

    public void setOptions(String sOptions) {
        char[] sOp = sOptions.toCharArray();
        boolean[] bSOp = new boolean[]{false, false, false, false, false, false, false, false, false};
        for (int j = 0; j < sOp.length; ++j) {
            bSOp[j] = sOp[j] != '0';
        }
        this.exact.setSelected(bSOp[0]);
        this.exact.setBorder(new SoftBevelBorder(Character.digit(sOp[0], 10)));
        this.exactnocase.setSelected(bSOp[1]);
        this.exactnocase.setBorder(new SoftBevelBorder(Character.digit(sOp[1], 10)));
        this.fuzzy.setSelected(bSOp[2]);
        this.fuzzy.setBorder(new SoftBevelBorder(Character.digit(sOp[2], 10)));
        this.sequence.setSelected(bSOp[3]);
        this.sequence.setBorder(new SoftBevelBorder(Character.digit(sOp[3], 10)));
        this.importance.setSelected(bSOp[4]);
        this.importance.setBorder(new SoftBevelBorder(Character.digit(sOp[4], 10)));
        this.text.setSelected(bSOp[5]);
        this.text.setBorder(new SoftBevelBorder(Character.digit(sOp[5], 10)));
        this.title.setSelected(bSOp[6]);
        this.title.setBorder(new SoftBevelBorder(Character.digit(sOp[6], 10)));
        this.words.setSelected(bSOp[7]);
        this.words.setBorder(new SoftBevelBorder(Character.digit(sOp[7], 10)));
        this.setButtonsOn(bSOp[8]);
    }

    public int getSearchToken() {
        return this.searchtoken;
    }

    public void runSearch() {
        int openCode;
        searchArgument = new String(this.searchReqTField.getText());
        hlcjbook J = new hlcjbook(this.bname, this.runDir, this.userDataDirectory);
        this.hitList.removeAllElements();
        boolean thisSearchHasBeenRunBefore = false;
        for (int q = 0; q < this.prevSearchCBox.getItemCount(); ++q) {
            if (!this.searchReqTField.getText().equals(this.prevSearchCBox.getItemAt(q).toString())) continue;
            thisSearchHasBeenRunBefore = true;
            this.prevSearchCBox.setSelectedIndex(q);
        }
        if (!thisSearchHasBeenRunBefore) {
            this.prevSearchCBox.insertItemAt(this.searchReqTField.getText(), 0);
            this.prevSearchCBox.setSelectedIndex(0);
        }
        if ((openCode = J.jbOpen()) == 0) {
            J.setSearchOptions(this.exact.isSelected(), this.exactnocase.isSelected(), this.fuzzy.isSelected(), this.title.isSelected(), this.text.isSelected(), this.words.isSelected(), this.importance.isSelected(), this.sequence.isSelected());
            this.searchtoken = J.Search(this.searchReqTField.getText());
            this.numHits = J.getNumSearchHits();
            this.nHits.setText(this.numHits + " Results.");
            if (this.numHits != 0) {
                for (int i = 0; i < this.numHits; ++i) {
                    this.hitList.addElement(J.getNextHit((short)0));
                }
                this.searchResList.setEnabled(true);
            } else {
                this.hitList.addElement("No Search Hits Found.");
                this.searchResList.setEnabled(false);
            }
            this.searchResList.setListData(this.hitList);
            J.jbClose();
            Integer hitCounter = new Integer(this.numHits);
            this.searchResList.firePropertyChangeEvent(SEARCH_RUN_PROPERTY, "", hitCounter);
        } else {
            JOptionPane.showMessageDialog(this, "Unable to open book:\n" + this.bname, "Error", 0);
        }
    }

    public hlcsearchBook(JFrame f, String BookName, String rDir, String userDataDirectoryIn, String searchOptions, String searchWIDTH, String searchHEIGHT) {
        super(f, "Search Book: " + BookName, false);
        this.setDefaultCloseOperation(0);
        this.width = new Integer(searchWIDTH);
        this.height = new Integer(searchHEIGHT);
        this.setSize(this.width, this.height);
        this.setResizable(true);
        this.setModal(false);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().setLayout(gbl);
        this.runDir = new String(rDir);
        this.userDataDirectory = new String(userDataDirectoryIn);
        this.bname = BookName;
        this.hitList = new Vector();
        this.spref = new String(searchOptions);
        this.defaultSpref = new String(searchOptions);
        this.searchReqTField = new JTextField();
        this.searchReqTField.setSize(313, 35);
        this.searchReqTField.setLocation(8, 65);
        this.searchReqTField.requestFocus();
        this.b_and = new JButton(" & ");
        this.b_and.setMargin(new Insets(1, 1, 1, 1));
        this.b_and.setSize(22, 22);
        this.b_and.setLocation(131, 31);
        this.b_and.setToolTipText("logical AND");
        this.b_or = new JButton(" |  ");
        this.b_or.setMargin(new Insets(1, 1, 1, 1));
        this.b_or.setSize(22, 22);
        this.b_or.setLocation(155, 31);
        this.b_or.setToolTipText("logical OR");
        this.b_not = new JButton(" !  ");
        this.b_not.setMargin(new Insets(1, 1, 1, 1));
        this.b_not.setSize(22, 22);
        this.b_not.setLocation(179, 31);
        this.b_not.setToolTipText("logical NOT");
        this.b_quote = new JButton(" '' ");
        this.b_quote.setMargin(new Insets(1, 1, 1, 1));
        this.b_quote.setSize(22, 22);
        this.b_quote.setLocation(203, 31);
        this.b_quote.setToolTipText("quoted phrase");
        this.b_paren = new JButton(" [] ");
        this.b_paren.setMargin(new Insets(1, 1, 1, 1));
        this.b_paren.setSize(22, 22);
        this.b_paren.setLocation(227, 31);
        this.b_paren.setToolTipText("parenthesized expression");
        this.b_comma = new JButton(" ,  ");
        this.b_comma.setMargin(new Insets(1, 1, 1, 1));
        this.b_comma.setSize(22, 22);
        this.b_comma.setLocation(251, 31);
        this.b_comma.setToolTipText("list separator");
        this.b_equal = new JButton(" = ");
        this.b_equal.setMargin(new Insets(1, 1, 1, 1));
        this.b_equal.setSize(22, 22);
        this.b_equal.setToolTipText("equal sign");
        this.b_equal.setLocation(275, 31);
        this.b_qmark = new JButton(" ? ");
        this.b_qmark.setMargin(new Insets(1, 1, 1, 1));
        this.b_qmark.setSize(22, 22);
        this.b_qmark.setLocation(299, 31);
        this.b_qmark.setToolTipText("wildcard character");
        this.exact = new JToggleButton("", new ImageIcon(this.runDir + "searchexact.gif"), false);
        this.exact.setMargin(new Insets(1, 1, 1, 1));
        this.exact.setToolTipText("Find exact matches only");
        this.exact.setSize(25, 25);
        this.exact.setLocation(8, 4);
        this.exact.setBorder(new SoftBevelBorder(0));
        this.exactnocase = new JToggleButton("", new ImageIcon(this.runDir + "searchnocase.gif"), false);
        this.exactnocase.setMargin(new Insets(1, 1, 1, 1));
        this.exactnocase.setToolTipText("Find exact matches ignoring case");
        this.exactnocase.setSize(25, 25);
        this.exactnocase.setLocation(39, 4);
        this.exactnocase.setBorder(new SoftBevelBorder(0));
        this.fuzzy = new JToggleButton("", new ImageIcon(this.runDir + "searchfuzzy.gif"), true);
        this.fuzzy.setMargin(new Insets(1, 1, 1, 1));
        this.fuzzy.setToolTipText("Use fuzzy search");
        this.fuzzy.setSize(25, 25);
        this.fuzzy.setLocation(70, 4);
        this.fuzzy.setBorder(new SoftBevelBorder(1));
        this.sequence = new JToggleButton("", new ImageIcon(this.runDir + "vwicn040.gif"), false);
        this.sequence.setMargin(new Insets(1, 1, 1, 1));
        this.sequence.setToolTipText("List results in sequence");
        this.sequence.setSize(25, 25);
        this.sequence.setLocation(109, 4);
        this.sequence.setBorder(new SoftBevelBorder(0));
        this.importance = new JToggleButton("", new ImageIcon(this.runDir + "vwicn039.gif"), true);
        this.importance.setMargin(new Insets(1, 1, 1, 1));
        this.importance.setToolTipText("List results in order of importance");
        this.importance.setSize(25, 25);
        this.importance.setLocation(139, 4);
        this.importance.setBorder(new SoftBevelBorder(1));
        this.title = new JToggleButton("", new ImageIcon(this.runDir + "actn132.gif"), true);
        this.title.setMargin(new Insets(1, 1, 1, 1));
        this.title.setToolTipText("Search in topic titles");
        this.title.setSize(25, 25);
        this.title.setLocation(178, 4);
        this.title.setBorder(new SoftBevelBorder(1));
        this.text = new JToggleButton("", new ImageIcon(this.runDir + "actn134.gif"), true);
        this.text.setMargin(new Insets(1, 1, 1, 1));
        this.text.setToolTipText("Search in topic text");
        this.text.setSize(25, 25);
        this.text.setLocation(209, 4);
        this.text.setBorder(new SoftBevelBorder(1));
        this.words = new JToggleButton("", new ImageIcon(this.runDir + "actn133.gif"), false);
        this.words.setMargin(new Insets(1, 1, 1, 1));
        this.words.setToolTipText("Search indexed words");
        this.words.setSize(25, 25);
        this.words.setLocation(240, 4);
        this.words.setBorder(new SoftBevelBorder(0));
        this.operators = new JToggleButton("", new ImageIcon(this.runDir + "actn091.gif"), false);
        this.operators.setMargin(new Insets(1, 1, 1, 1));
        this.operators.setToolTipText("Advanced search");
        this.operators.setSize(25, 25);
        this.operators.setLocation(296, 4);
        this.operators.setBorder(new SoftBevelBorder(0));
        this.nHits = new JLabel("Awaiting Search...");
        this.nHits.setFont(this.lt);
        this.nHits.setForeground(Color.black);
        this.prevSearchCBox = new JComboBox();
        this.prevSearchCBox.setSize(313, 21);
        this.prevSearchCBox.setLocation(8, 112);
        this.sReqLabel = new JLabel("Search Request:      ");
        this.sReqLabel.setFont(this.lt);
        this.sReqLabel.setForeground(Color.black);
        this.sReqLabel.setSize(120, 13);
        this.sReqLabel.setLocation(8, 40);
        this.sResLabel = new JLabel("Search Results:");
        this.sResLabel.setFont(this.lt);
        this.sResLabel.setForeground(Color.black);
        this.sResLabel.setSize(120, 13);
        this.sResLabel.setLocation(8, 176);
        this.run = new JButton();
        this.run.setFont(this.lt);
        this.run.setText("Search");
        this.run.setSize(73, 25);
        this.run.setLocation(8, 140);
        this.reset = new JButton();
        this.reset.setFont(this.lt);
        this.reset.setText("Reset");
        this.reset.setSize(73, 25);
        this.reset.setLocation(88, 140);
        this.cancel = new JButton();
        this.cancel.setFont(this.lt);
        this.cancel.setText("Close");
        this.cancel.setSize(73, 25);
        this.cancel.setLocation(168, 140);
        this.help = new JButton();
        this.help.setFont(this.lt);
        this.help.setText("Help");
        this.help.setSize(73, 25);
        this.help.setLocation(248, 140);
        this.searchResList = new hlcHelperList();
        this.searchResScroll = new JScrollPane(this.searchResList);
        JPanel checkButtonPanel = new JPanel(new FlowLayout(0, 5, 5));
        gbl.setConstraints(checkButtonPanel, gbc);
        checkButtonPanel.add(this.exact);
        checkButtonPanel.add(this.exactnocase);
        checkButtonPanel.add(this.fuzzy);
        checkButtonPanel.add(new JLabel(" "));
        checkButtonPanel.add(this.sequence);
        checkButtonPanel.add(this.importance);
        checkButtonPanel.add(new JLabel(" "));
        checkButtonPanel.add(this.title);
        checkButtonPanel.add(this.text);
        checkButtonPanel.add(this.words);
        checkButtonPanel.add(new JLabel(" "));
        checkButtonPanel.add(this.operators);
        JPanel checkButtonPanel1 = new JPanel(new FlowLayout(0, 5, 5));
        checkButtonPanel1.add(this.sReqLabel);
        checkButtonPanel1.add(this.b_and);
        checkButtonPanel1.add(this.b_or);
        checkButtonPanel1.add(this.b_not);
        checkButtonPanel1.add(this.b_quote);
        checkButtonPanel1.add(this.b_paren);
        checkButtonPanel1.add(this.b_comma);
        checkButtonPanel1.add(this.b_equal);
        checkButtonPanel1.add(this.b_qmark);
        this.getContentPane().add(checkButtonPanel);
        gbc.gridy = -1;
        gbl.setConstraints(checkButtonPanel1, gbc);
        this.getContentPane().add(checkButtonPanel1);
        gbl.setConstraints(this.searchReqTField, gbc);
        this.getContentPane().add(this.searchReqTField);
        this.searchReqTField.requestFocus();
        gbl.setConstraints(this.prevSearchCBox, gbc);
        this.getContentPane().add(this.prevSearchCBox);
        JPanel functionButtonPanel = new JPanel(new FlowLayout(0, 5, 5));
        functionButtonPanel.add(this.run);
        functionButtonPanel.add(this.reset);
        functionButtonPanel.add(this.cancel);
        functionButtonPanel.add(this.help);
        gbl.setConstraints(functionButtonPanel, gbc);
        this.getContentPane().add(functionButtonPanel);
        gbl.setConstraints(this.sResLabel, gbc);
        this.getContentPane().add(this.sResLabel);
        gbc.fill = 1;
        gbc.weighty = 20.0;
        gbl.setConstraints(this.searchResScroll, gbc);
        this.getContentPane().add(this.searchResScroll);
        gbc.weighty = 0.0;
        gbl.setConstraints(this.nHits, gbc);
        this.getContentPane().add(this.nHits);
        this.prevSearchCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.searchReqTField.setText((String)hlcsearchBook.this.prevSearchCBox.getSelectedItem());
            }
        });
        this.run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.setCursor(new Cursor(3));
                hlcsearchBook.this.runSearch();
                hlcsearchBook.this.setCursor(new Cursor(0));
            }
        });
        this.searchReqTField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    hlcsearchBook.this.setCursor(new Cursor(3));
                    hlcsearchBook.this.runSearch();
                    if (hlcsearchBook.this.searchResList.isEnabled()) {
                        hlcsearchBook.this.searchResList.requestFocus();
                        hlcsearchBook.this.searchResList.setSelectedIndex(0);
                    }
                    hlcsearchBook.this.setCursor(new Cursor(0));
                }
            }
        });
        this.run.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    hlcsearchBook.this.setCursor(new Cursor(3));
                    hlcsearchBook.this.runSearch();
                    hlcsearchBook.this.setCursor(new Cursor(0));
                }
            }
        });
        this.reset.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    searchArgument = new String();
                    hlcsearchBook.this.searchReqTField.setText("");
                    hlcsearchBook.this.searchResList.setListData(new Vector());
                    hlcsearchBook.this.setButtonsOn(false);
                    hlcsearchBook.this.fuzzy.setSelected(true);
                    hlcsearchBook.this.fuzzy.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.importance.setSelected(true);
                    hlcsearchBook.this.importance.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.title.setSelected(true);
                    hlcsearchBook.this.title.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.text.setSelected(true);
                    hlcsearchBook.this.text.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.exact.setSelected(false);
                    hlcsearchBook.this.exact.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.exactnocase.setSelected(false);
                    hlcsearchBook.this.exactnocase.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.words.setSelected(false);
                    hlcsearchBook.this.words.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.sequence.setSelected(false);
                    hlcsearchBook.this.sequence.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.RESET_SEARCH_PROPERTY, "", " ");
                    hlcsearchBook.this.numHits = 0;
                }
            }
        });
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    Integer hitCounter = new Integer(hlcsearchBook.this.numHits);
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.SEARCH_OPTIONS_PROPERTY, "", hlcsearchBook.this.spref);
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_PROPERTY, "", hitCounter);
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_SIZE_PROPERTY, "", hlcsearchBook.this.getSize());
                    hlcsearchBook.this.setVisible(false);
                }
            }
        });
        this.help.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    hlcsearchBook.this.setCursor(new Cursor(3));
                    hlcgetStart g = new hlcgetStart("SearchHelp.html", hlcsearchBook.this.runDir, hlcsearchBook.this.dialog);
                    hlcsearchBook.this.setCursor(new Cursor(0));
                }
            }
        });
        this.exact.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.exact.isSelected()) {
                    hlcsearchBook.this.exact.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.exactnocase.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.exactnocase.setSelected(false);
                    hlcsearchBook.this.fuzzy.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.fuzzy.setSelected(false);
                } else {
                    hlcsearchBook.this.exact.setSelected(true);
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.exact.isSelected()) {
                    sprefBuffer.setCharAt(0, '1');
                    sprefBuffer.setCharAt(1, '0');
                    sprefBuffer.setCharAt(2, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.exactnocase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.exactnocase.isSelected()) {
                    hlcsearchBook.this.exactnocase.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.fuzzy.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.fuzzy.setSelected(false);
                    hlcsearchBook.this.exact.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.exact.setSelected(false);
                } else {
                    hlcsearchBook.this.exactnocase.setSelected(true);
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.exactnocase.isSelected()) {
                    sprefBuffer.setCharAt(1, '1');
                    sprefBuffer.setCharAt(0, '0');
                    sprefBuffer.setCharAt(2, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.fuzzy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.fuzzy.isSelected()) {
                    hlcsearchBook.this.fuzzy.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.exactnocase.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.exactnocase.setSelected(false);
                    hlcsearchBook.this.exact.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.exact.setSelected(false);
                } else {
                    hlcsearchBook.this.fuzzy.setSelected(true);
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.fuzzy.isSelected()) {
                    sprefBuffer.setCharAt(2, '1');
                    sprefBuffer.setCharAt(0, '0');
                    sprefBuffer.setCharAt(1, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.sequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.sequence.isSelected()) {
                    hlcsearchBook.this.sequence.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.importance.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.importance.setSelected(false);
                } else {
                    hlcsearchBook.this.sequence.setSelected(true);
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.sequence.isSelected()) {
                    sprefBuffer.setCharAt(3, '1');
                    sprefBuffer.setCharAt(4, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.importance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.importance.isSelected()) {
                    hlcsearchBook.this.importance.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.sequence.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.sequence.setSelected(false);
                } else {
                    hlcsearchBook.this.importance.setSelected(true);
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.importance.isSelected()) {
                    sprefBuffer.setCharAt(4, '1');
                    sprefBuffer.setCharAt(3, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.title.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.title.isSelected()) {
                    hlcsearchBook.this.title.setBorder(new SoftBevelBorder(1));
                } else {
                    hlcsearchBook.this.title.setBorder(new SoftBevelBorder(0));
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.title.isSelected()) {
                    sprefBuffer.setCharAt(6, '1');
                } else {
                    sprefBuffer.setCharAt(6, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.text.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.text.isSelected()) {
                    hlcsearchBook.this.text.setBorder(new SoftBevelBorder(1));
                } else {
                    hlcsearchBook.this.text.setBorder(new SoftBevelBorder(0));
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.text.isSelected()) {
                    sprefBuffer.setCharAt(5, '1');
                } else {
                    sprefBuffer.setCharAt(5, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.words.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.words.isSelected()) {
                    hlcsearchBook.this.words.setBorder(new SoftBevelBorder(1));
                } else {
                    hlcsearchBook.this.words.setBorder(new SoftBevelBorder(0));
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.words.isSelected()) {
                    sprefBuffer.setCharAt(7, '1');
                } else {
                    sprefBuffer.setCharAt(7, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.operators.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (hlcsearchBook.this.operators.isSelected()) {
                    hlcsearchBook.this.operators.setBorder(new SoftBevelBorder(1));
                    hlcsearchBook.this.setButtonsOn(true);
                } else {
                    hlcsearchBook.this.operators.setBorder(new SoftBevelBorder(0));
                    hlcsearchBook.this.setButtonsOn(false);
                }
                StringBuffer sprefBuffer = new StringBuffer(hlcsearchBook.this.spref);
                if (hlcsearchBook.this.operators.isSelected()) {
                    sprefBuffer.setCharAt(8, '1');
                } else {
                    sprefBuffer.setCharAt(8, '0');
                }
                hlcsearchBook.this.spref = new String(sprefBuffer.toString());
            }
        });
        this.searchResList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    hlcsearchBook.this.setCursor(new Cursor(3));
                    String selectedTopic = (String)hlcsearchBook.this.searchResList.getSelectedValue();
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.SEARCH_HIT_PROPERTY, "", selectedTopic);
                    hlcsearchBook.this.searchResList.requestFocus();
                    hlcsearchBook.this.setCursor(new Cursor(0));
                }
            }
        });
        this.searchResList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    hlcsearchBook.this.setCursor(new Cursor(3));
                    String selectedTopic = (String)hlcsearchBook.this.searchResList.getSelectedValue();
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.SEARCH_HIT_PROPERTY, "", selectedTopic);
                    hlcsearchBook.this.setCursor(new Cursor(0));
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Integer hitCounter = new Integer(hlcsearchBook.this.numHits);
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.SEARCH_OPTIONS_PROPERTY, "", hlcsearchBook.this.spref);
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_PROPERTY, "", hitCounter);
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_SIZE_PROPERTY, "", hlcsearchBook.this.getSize());
                hlcsearchBook.this.setVisible(false);
            }
        });
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.setCursor(new Cursor(3));
                hlcgetStart g = new hlcgetStart("SearchHelp.html", hlcsearchBook.this.runDir, hlcsearchBook.this.dialog);
                hlcsearchBook.this.setCursor(new Cursor(0));
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Integer hitCounter = new Integer(hlcsearchBook.this.numHits);
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.SEARCH_OPTIONS_PROPERTY, "", hlcsearchBook.this.spref);
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_PROPERTY, "", hitCounter);
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_SIZE_PROPERTY, "", hlcsearchBook.this.getSize());
                hlcsearchBook.this.setVisible(false);
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                searchArgument = new String();
                hlcsearchBook.this.searchReqTField.setText("");
                hlcsearchBook.this.searchResList.setListData(new Vector());
                hlcsearchBook.this.setButtonsOn(false);
                hlcsearchBook.this.fuzzy.setSelected(true);
                hlcsearchBook.this.fuzzy.setBorder(new SoftBevelBorder(1));
                hlcsearchBook.this.importance.setSelected(true);
                hlcsearchBook.this.importance.setBorder(new SoftBevelBorder(1));
                hlcsearchBook.this.title.setSelected(true);
                hlcsearchBook.this.title.setBorder(new SoftBevelBorder(1));
                hlcsearchBook.this.text.setSelected(true);
                hlcsearchBook.this.text.setBorder(new SoftBevelBorder(1));
                hlcsearchBook.this.exact.setSelected(false);
                hlcsearchBook.this.exact.setBorder(new SoftBevelBorder(0));
                hlcsearchBook.this.exactnocase.setSelected(false);
                hlcsearchBook.this.exactnocase.setBorder(new SoftBevelBorder(0));
                hlcsearchBook.this.words.setSelected(false);
                hlcsearchBook.this.words.setBorder(new SoftBevelBorder(0));
                hlcsearchBook.this.sequence.setSelected(false);
                hlcsearchBook.this.sequence.setBorder(new SoftBevelBorder(0));
                hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.RESET_SEARCH_PROPERTY, "", " ");
                hlcsearchBook.this.numHits = 0;
            }
        });
        this.b_and.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, " & ");
                hlcsearchBook.this.searchReqTField.requestFocus();
            }
        });
        this.b_or.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, " | ");
                hlcsearchBook.this.searchReqTField.requestFocus();
            }
        });
        this.b_not.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, " ! ");
                hlcsearchBook.this.searchReqTField.requestFocus();
            }
        });
        this.b_quote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, "''");
                hlcsearchBook.this.searchReqTField.requestFocus();
                hlcsearchBook.this.searchReqTField.setCaretPosition(hlcsearchBook.this.searchReqTField.getCaretPosition() - 1);
            }
        });
        this.b_paren.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, "()");
                hlcsearchBook.this.searchReqTField.requestFocus();
                hlcsearchBook.this.searchReqTField.setCaretPosition(hlcsearchBook.this.searchReqTField.getCaretPosition() - 1);
            }
        });
        this.b_comma.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, ",");
                hlcsearchBook.this.searchReqTField.requestFocus();
            }
        });
        this.b_equal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, "=");
                hlcsearchBook.this.searchReqTField.requestFocus();
            }
        });
        this.b_qmark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                hlcsearchBook.this.insert(hlcsearchBook.this.searchReqTField, "?");
                hlcsearchBook.this.searchReqTField.requestFocus();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    Integer hitCounter = new Integer(hlcsearchBook.this.numHits);
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.SEARCH_OPTIONS_PROPERTY, "", hlcsearchBook.this.spref);
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_PROPERTY, "", hitCounter);
                    hlcsearchBook.this.searchResList.firePropertyChangeEvent(hlcsearchBook.EXIT_SIZE_PROPERTY, "", hlcsearchBook.this.getSize());
                    hlcsearchBook.this.setVisible(false);
                }
            }
        });
        this.setOptions(this.spref);
        Rectangle r = f.getBounds();
        int w = f.getSize().width;
        int h = f.getSize().height;
        int xFrame = (int)r.getX();
        int yFrame = (int)r.getY();
        this.setLocation(xFrame + w - this.width - 30, yFrame + h - this.height - 30);
        this.setVisible(true);
        this.searchReqTField.requestFocus();
    }

    public void closeWindow() {
        Integer hitCounter = new Integer(this.numHits);
        this.searchResList.firePropertyChangeEvent(SEARCH_OPTIONS_PROPERTY, "", this.spref);
        this.searchResList.firePropertyChangeEvent(EXIT_PROPERTY, "", hitCounter);
        this.searchResList.firePropertyChangeEvent(EXIT_SIZE_PROPERTY, "", this.getSize());
        this.setVisible(false);
        this.dispose();
    }

    public String getSearchOptions() {
        return this.spref;
    }

    private void insert(JTextField jtf, String item) {
        int cp = jtf.getCaretPosition();
        String currText = new String(jtf.getText());
        jtf.setText(currText.substring(0, cp) + item + currText.substring(cp, currText.length()));
        jtf.setCaretPosition(cp + item.length());
    }

    public void execSearch(String searchOpts, String searchArg, String topic) {
        this.spref = new String(searchOpts);
        this.defaultSpref = new String(searchOpts);
        this.searchReqTField.setText(searchArg);
        this.setOptions(searchOpts);
        this.runSearch();
        this.searchResList.setSelectedValue(topic, true);
        this.searchResList.firePropertyChangeEvent(SEARCH_HIT_PROPERTY, "", topic);
    }

    public void showSearchResults() {
        this.setTitle("Search Results - " + this.searchReqTField.getText());
        this.searchResScroll.setSize(313, 357);
        this.searchResScroll.setLocation(8, 4);
        this.prevSearchCBox.setVisible(false);
        this.searchReqTField.setVisible(false);
        this.run.setVisible(false);
        this.reset.setVisible(false);
        this.cancel.setVisible(false);
        this.help.setVisible(false);
        this.exact.setVisible(false);
        this.exactnocase.setVisible(false);
        this.fuzzy.setVisible(false);
        this.sequence.setVisible(false);
        this.importance.setVisible(false);
        this.title.setVisible(false);
        this.text.setVisible(false);
        this.words.setVisible(false);
        this.operators.setVisible(false);
        this.sReqLabel.setVisible(false);
        this.sResLabel.setVisible(false);
        this.setButtonsOn(false);
        this.setVisible(true);
    }

    public void showSearch() {
        this.prevSearchCBox.setVisible(true);
        this.searchReqTField.setText("");
        this.searchReqTField.setVisible(true);
        this.run.setVisible(true);
        this.reset.setVisible(true);
        this.cancel.setVisible(true);
        this.help.setVisible(true);
        this.exact.setVisible(true);
        this.exactnocase.setVisible(true);
        this.fuzzy.setVisible(true);
        this.sequence.setVisible(true);
        this.importance.setVisible(true);
        this.title.setVisible(true);
        this.text.setVisible(true);
        this.words.setVisible(true);
        this.operators.setVisible(true);
        this.sReqLabel.setVisible(true);
        this.sResLabel.setVisible(true);
        this.setButtonsOn(this.state);
        this.searchResList.setListData(new Vector());
        this.setVisible(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.searchResList.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.searchResList.removePropertyChangeListener(l);
    }

    public boolean prevMatchExists() {
        return this.searchResList.getSelectedIndex() > 0;
    }

    public boolean nextMatchExists() {
        return this.searchResList.getSelectedIndex() < this.numHits - 1;
    }

    public void gotoPrevMatch() {
        int matchSelection = this.searchResList.getSelectedIndex();
        if (matchSelection >= 1 & matchSelection < this.numHits) {
            this.searchResList.setSelectedIndex(matchSelection - 1);
            String selectedTopic = (String)this.searchResList.getSelectedValue();
            this.searchResList.firePropertyChangeEvent(SEARCH_HIT_PROPERTY, "", selectedTopic);
        }
    }

    public void gotoNextMatch() {
        int matchSelection = this.searchResList.getSelectedIndex();
        if (matchSelection >= 0 & matchSelection < this.numHits - 1) {
            this.searchResList.setSelectedIndex(matchSelection + 1);
            String selectedTopic = (String)this.searchResList.getSelectedValue();
            this.searchResList.firePropertyChangeEvent(SEARCH_HIT_PROPERTY, "", selectedTopic);
        }
    }
}

