/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class hlcjcase {
    private Vector fileNames = new Vector(10, 10);
    private Vector names = new Vector(10, 10);
    private Vector dates = new Vector(10, 10);
    private Vector descriptions = new Vector(10, 10);
    private Vector pDir;
    private Vector indexFileNames = new Vector(10, 10);
    private Vector indexDates = new Vector(10, 10);
    private Vector indexNumberOfBooks = new Vector(10, 10);
    private Vector indexDictionaryNames = new Vector(10, 10);
    static final String fsep = new String(System.getProperty("file.separator"));
    String runDir;
    private String userDataDirectory = "";

    public hlcjcase(Vector fDir, String rDir, String userDataDirectoryIn, String shelfName, boolean ignore) {
        this.runDir = new String(rDir);
        this.userDataDirectory = new String(userDataDirectoryIn);
        this.pDir = fDir;
        if (shelfName.length() > 0) {
            int size = this.pDir.size();
            int index = shelfName.lastIndexOf(fsep);
            String shelfPath = index >= 0 ? shelfName.substring(0, index) : shelfName;
            boolean pathExists = false;
            for (int i = 0; i < size; ++i) {
                if (!shelfPath.equalsIgnoreCase((String)this.pDir.elementAt(i))) continue;
                pathExists = true;
                break;
            }
            if (!pathExists) {
                try {
                    hlcjshelf js = new hlcjshelf(shelfName, false, this.runDir, this.userDataDirectory);
                    if (js.invalidShelf) {
                        JOptionPane.showMessageDialog(null, "The shelf " + shelfName + " is invalid and cannot be opened.", "IBM Softcopy Reader", 0);
                    } else {
                        this.fileNames.addElement(js.getShelfFileName());
                        this.names.addElement(js.getShelfName());
                        this.descriptions.addElement(js.getShelfDescription());
                        this.dates.addElement(js.getShelfDate());
                        this.indexFileNames.addElement(js.getIndexFileName());
                        this.indexDates.addElement(js.getIndexDate());
                        this.indexNumberOfBooks.addElement(js.getIndexNumberOfBooks());
                        this.indexDictionaryNames.addElement(js.getShelfIndexDictionaryName());
                    }
                }
                catch (XKOopsException e) {
                    StringBuffer message = new StringBuffer("");
                    String nl = System.getProperty("line.separator");
                    if (e.noLocalDTD) {
                        message.append("No local DTD was found.  " + nl);
                    }
                    message.append("The shelf " + shelfName + " cannot be opened.  " + nl);
                    message.append("If the shelf is not corrupted, " + nl + "and upgrading your software to the latest SCR " + nl + "does not resolve the problem, " + nl + "then report the problem to the owner of the shelf.");
                    JOptionPane.showMessageDialog(null, message, "IBM Softcopy Reader", 0);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "The shelf " + shelfName + " is invalid and cannot be opened.", "IBM Softcopy Reader", 0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "The shelf " + shelfName + " is invalid and cannot be opened.", "IBM Softcopy Reader", 0);
                }
            }
        }
        if (!ignore) {
            int size = this.pDir.size();
            hlcjshelf js = new hlcjshelf(this.runDir, this.userDataDirectory);
            for (int k = 0; k < size; ++k) {
                try {
                    File bcFile = new File((String)this.pDir.elementAt(k));
                    String[] allFiles = bcFile.list();
                    if (allFiles == null) continue;
                    int length = allFiles.length;
                    for (int i = 0; i < length; ++i) {
                        if (!allFiles[i].toUpperCase().endsWith(".BKS") && !allFiles[i].toUpperCase().endsWith(".XKS")) continue;
                        try {
                            js.readBookshelf(this.pDir.elementAt(k) + fsep + allFiles[i], false);
                            this.fileNames.addElement(js.getShelfFileName());
                            this.names.addElement(js.getShelfName());
                            this.descriptions.addElement(js.getShelfDescription());
                            this.dates.addElement(js.getShelfDate());
                            this.indexFileNames.addElement(js.getIndexFileName());
                            this.indexDates.addElement(js.getIndexDate());
                            this.indexNumberOfBooks.addElement(js.getIndexNumberOfBooks());
                            this.indexDictionaryNames.addElement(js.getShelfIndexDictionaryName());
                            continue;
                        }
                        catch (XKOopsException e) {
                            StringBuffer message = new StringBuffer("");
                            String nl = System.getProperty("line.separator");
                            if (e.noLocalDTD) {
                                message.append("No local DTD was found.  " + nl);
                            }
                            message.append("The shelf " + allFiles[i] + " is invalid and cannot be opened.  " + nl);
                            message.append("If the shelf is not corrupted, and upgrading your software " + nl + "to the latest SCR does not resolve the problem, " + nl + "then report the problem to the owner of the shelf.");
                            JOptionPane.showMessageDialog(null, message, "IBM Softcopy Reader", 0);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Error er) {
                    er.printStackTrace();
                }
            }
        }
    }

    public hlcjcase(Vector fDir, String rDir, String userDataDirectoryIn, String searchDocNo, String searchDocTitle, String searchDocName, Vector bookTitle, Vector bookAddress, Vector shelfTitle) {
        this.runDir = new String(rDir);
        this.userDataDirectory = new String(userDataDirectoryIn);
        this.pDir = fDir;
        int size = this.pDir.size();
        hlcjshelf js = new hlcjshelf(this.runDir, this.userDataDirectory);
        for (int k = 0; k < size; ++k) {
            try {
                File bcFile = new File((String)this.pDir.elementAt(k));
                String[] allFiles = bcFile.list();
                if (allFiles == null) continue;
                int length = allFiles.length;
                for (int i = 0; i < length; ++i) {
                    if (!allFiles[i].toUpperCase().endsWith(".BKS") && !allFiles[i].toUpperCase().endsWith(".XKS")) continue;
                    try {
                        js.resetBookInfo();
                        js.readBookshelf(this.pDir.elementAt(k) + fsep + allFiles[i], true);
                        if (!this.isInBookSelectionCriteria(js, searchDocNo, searchDocTitle, searchDocName, this.pDir.elementAt(k) + fsep, bookTitle, bookAddress, shelfTitle)) continue;
                        this.fileNames.addElement(js.getShelfFileName());
                        this.names.addElement(js.getShelfName());
                        this.descriptions.addElement(js.getShelfDescription());
                        this.dates.addElement(js.getShelfDate());
                        this.indexFileNames.addElement(js.getIndexFileName());
                        this.indexDates.addElement(js.getIndexDate());
                        this.indexNumberOfBooks.addElement(js.getIndexNumberOfBooks());
                        this.indexDictionaryNames.addElement(js.getShelfIndexDictionaryName());
                        continue;
                    }
                    catch (XKOopsException e) {
                        StringBuffer message = new StringBuffer("");
                        String nl = System.getProperty("line.separator");
                        if (e.noLocalDTD) {
                            message.append("No local DTD was found.  " + nl);
                        }
                        message.append("The shelf " + allFiles[i] + " is invalid and cannot be opened.  " + nl);
                        message.append("If the shelf is not corrupted, and upgrading your software " + nl + "to the latest SCR does not resolve the problem, " + nl + "then report the problem to the owner of the shelf.");
                        JOptionPane.showMessageDialog(null, message, "IBM Softcopy Reader", 0);
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            catch (Error er) {
                er.printStackTrace();
            }
        }
    }

    private boolean isInBookSelectionCriteria(hlcjshelf loadedBookShelf, String searchDocNoPattern, String searchDocTitlePattern, String searchDocNamePattern, String bookPath, Vector bookTitle, Vector bookAddress, Vector shelfTitle) {
        int tempIndex;
        int tempSize;
        boolean passed;
        Vector loadedDocNo = loadedBookShelf.getDocNumbers();
        Vector loadedDocTitle = loadedBookShelf.getDocumentInstanceTitles();
        Vector loadedDocName = loadedBookShelf.getDocumentInstanceNames();
        if (!searchDocNoPattern.equals("*") && !searchDocNoPattern.equals("")) {
            passed = false;
            tempSize = loadedDocNo.size();
            for (tempIndex = 0; tempIndex < tempSize && !passed; ++tempIndex) {
                if (!hlcjcase.regExMatch(loadedDocNo.elementAt(tempIndex).toString().trim(), searchDocNoPattern, false)) continue;
                passed = true;
            }
        } else {
            passed = true;
        }
        if (passed) {
            if (!searchDocTitlePattern.equals("*") && !searchDocTitlePattern.equals("")) {
                passed = false;
                tempSize = loadedDocTitle.size();
                for (tempIndex = 0; tempIndex < tempSize && !passed; ++tempIndex) {
                    if (!hlcjcase.regExMatch(loadedDocTitle.elementAt(tempIndex).toString().trim(), searchDocTitlePattern, false)) continue;
                    passed = true;
                }
            } else {
                passed = true;
            }
        }
        if (passed) {
            if (!searchDocNamePattern.equals("*") && !searchDocNamePattern.equals("")) {
                passed = false;
                tempSize = loadedDocName.size();
                for (tempIndex = 0; tempIndex < tempSize && !passed; ++tempIndex) {
                    if (!hlcjcase.regExMatch(loadedDocName.elementAt(tempIndex).toString().trim(), searchDocNamePattern, false)) continue;
                    passed = true;
                }
            } else {
                passed = true;
            }
        }
        if (passed && bookAddress != null) {
            tempSize = loadedDocNo.size();
            for (tempIndex = 0; tempIndex < tempSize; ++tempIndex) {
                if (!loadedDocNo.elementAt(tempIndex).toString().equals(searchDocNoPattern) && (!searchDocNoPattern.endsWith("*") || !loadedDocNo.elementAt(tempIndex).toString().toUpperCase().startsWith(searchDocNoPattern.substring(0, searchDocNoPattern.length() - 1).toUpperCase())) || !searchDocTitlePattern.equals("*") && !loadedDocTitle.elementAt(tempIndex).toString().equals(searchDocTitlePattern) || !searchDocNamePattern.equals("*") && !loadedDocNo.elementAt(tempIndex).toString().equals(searchDocNoPattern)) continue;
                bookAddress.addElement(bookPath + loadedBookShelf.getFileNames().elementAt(tempIndex).toString().toUpperCase());
                if (bookTitle != null) {
                    bookTitle.addElement(loadedDocTitle.elementAt(tempIndex).toString());
                }
                if (shelfTitle == null) continue;
                shelfTitle.addElement(loadedBookShelf.getShelfName());
            }
        }
        return passed;
    }

    private static boolean regExMatch(String itext, String ipattern, boolean matchCase) {
        String text;
        String pattern;
        int i = 0;
        int state = 0;
        int lastWC = -1;
        char singWC = '?';
        char multWC = '*';
        boolean matched = true;
        boolean invert = false;
        if (!matchCase) {
            pattern = new String(ipattern.toUpperCase());
            text = new String(itext.toUpperCase());
        } else {
            pattern = new String(ipattern);
            text = new String(itext);
        }
        if (pattern.charAt(0) == '!') {
            invert = true;
            pattern = new String(pattern.substring(1));
        }
        int tlen = text.length();
        int plen = pattern.length();
        int matchstate = pattern.endsWith("*") ? plen - 1 : plen;
        while (i < tlen) {
            if (state >= plen) {
                if (lastWC >= 0) {
                    state = lastWC;
                } else {
                    matched = false;
                }
            }
            if (matched) {
                if (pattern.charAt(state) == multWC) {
                    lastWC = state;
                    if (state < plen - 1 && text.charAt(i) == pattern.charAt(state + 1)) {
                        state += 2;
                    }
                } else if (text.charAt(i) == pattern.charAt(state) || pattern.charAt(state) == singWC) {
                    ++state;
                } else if (lastWC >= 0) {
                    state = lastWC;
                    if (state < plen - 1 && text.charAt(i) == pattern.charAt(state + 1)) {
                        state += 2;
                    }
                } else {
                    matched = false;
                }
            }
            ++i;
        }
        if (invert) {
            return !matched || state != matchstate || i != tlen;
        }
        return matched && state == matchstate && i == tlen;
    }

    public void addNewBookShelf(Vector newShelfInfo) {
        int shelfMatch = this.findRow(newShelfInfo);
        if (shelfMatch < 0) {
            this.fileNames.insertElementAt(newShelfInfo.elementAt(0).toString(), 0);
            this.names.insertElementAt(newShelfInfo.elementAt(1).toString(), 0);
            this.dates.insertElementAt(newShelfInfo.elementAt(2).toString(), 0);
            this.descriptions.insertElementAt(newShelfInfo.elementAt(3).toString(), 0);
            this.indexFileNames.insertElementAt(newShelfInfo.elementAt(4).toString(), 0);
            this.indexDates.insertElementAt(newShelfInfo.elementAt(5).toString(), 0);
            this.indexNumberOfBooks.insertElementAt(newShelfInfo.elementAt(6).toString(), 0);
            this.indexDictionaryNames.insertElementAt(newShelfInfo.elementAt(7).toString(), 0);
        } else {
            this.fileNames.setElementAt(newShelfInfo.elementAt(0).toString(), shelfMatch);
            this.names.setElementAt(newShelfInfo.elementAt(1).toString(), shelfMatch);
            this.dates.setElementAt(newShelfInfo.elementAt(2).toString(), shelfMatch);
            this.descriptions.setElementAt(newShelfInfo.elementAt(3).toString(), shelfMatch);
            this.indexFileNames.setElementAt(newShelfInfo.elementAt(4).toString(), 0);
            this.indexDates.setElementAt(newShelfInfo.elementAt(5).toString(), 0);
            this.indexNumberOfBooks.setElementAt(newShelfInfo.elementAt(6).toString(), 0);
            this.indexDictionaryNames.setElementAt(newShelfInfo.elementAt(7).toString(), 0);
        }
    }

    public Vector delete(Vector itemsToDelete) {
        Vector<String> notDeleted = new Vector<String>();
        boolean deleted = false;
        for (int i = 0; i < itemsToDelete.size(); ++i) {
            int rmatch = this.findRow((Vector)itemsToDelete.elementAt(i));
            if (rmatch < 0) continue;
            try {
                File ftod = new File(this.fileNames.elementAt(rmatch).toString());
                deleted = ftod.delete();
                if (!deleted) {
                    notDeleted.addElement(ftod.getName());
                    continue;
                }
                this.fileNames.removeElementAt(rmatch);
                this.names.removeElementAt(rmatch);
                this.dates.removeElementAt(rmatch);
                this.descriptions.removeElementAt(rmatch);
                this.indexFileNames.removeElementAt(rmatch);
                this.indexDates.removeElementAt(rmatch);
                this.indexNumberOfBooks.removeElementAt(rmatch);
                this.indexDictionaryNames.removeElementAt(rmatch);
                continue;
            }
            catch (SecurityException e) {
                JOptionPane.showMessageDialog(null, "The shelf could not be deleted.", "IBM Softcopy Reader", 0);
            }
        }
        return notDeleted;
    }

    private int findRow(Vector rowVec) {
        int findex = -1;
        for (int i = 0; i < this.fileNames.size(); ++i) {
            if (!this.fileNames.elementAt(i).toString().equalsIgnoreCase(rowVec.elementAt(0).toString())) continue;
            findex = i;
        }
        return findex;
    }

    public Vector getNames() {
        return this.names;
    }

    public Vector getFileNames() {
        return this.fileNames;
    }

    public Vector getDates() {
        return this.dates;
    }

    public Vector getDescriptions() {
        return this.descriptions;
    }

    public Vector getIndexFileNames() {
        return this.indexFileNames;
    }

    public Vector getIndexDates() {
        return this.indexDates;
    }

    public Vector getIndexNumberOfBooks() {
        return this.indexNumberOfBooks;
    }

    public Vector getIndexDictionaryNames() {
        return this.indexDictionaryNames;
    }
}

