/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class hlcjXPicture {
    JDialog pf;
    RandomAccessFile myBook;
    String DesPic = new String();
    int picWidth = 0;
    int picHeight = 0;
    static final String fsep = new String(System.getProperty("file.separator"));
    static final char fsepChar = fsep.charAt(0);
    private boolean picIsOpen = false;
    Rectangle picSize = null;
    String userDataDirectory;
    String errorMessage;

    hlcjXPicture() {
    }

    public void setUserDataDirectory(String directoryIn) {
        this.userDataDirectory = new String(directoryIn);
    }

    public long getPicture(String bName, String pName, Dimension bookFrameSize) {
        boolean badMetafile = false;
        String fixPName = new String(bName.replace(fsepChar, '_'));
        if (fixPName.indexOf(":") >= 0) {
            fixPName = fixPName.substring(0, fixPName.indexOf(":")) + fixPName.substring(fixPName.indexOf(":") + 1);
        }
        if (!this.checkPictureExists(fixPName = this.userDataDirectory + "cache" + fsep + pName + "_" + fixPName) || hlcBFrame.lowResolution) {
            try {
                this.myBook = new RandomAccessFile(bName, "r");
                int locVersionInfo = this.myBook.readUnsignedShort();
                long savecurroffset = this.myBook.getFilePointer();
                this.myBook.seek(locVersionInfo *= 4096);
                long unused = this.myBook.readLong();
                int t2 = this.myBook.readUnsignedByte();
                int t3 = this.myBook.readUnsignedByte();
                int t4 = this.myBook.readUnsignedByte();
                this.myBook.seek(savecurroffset);
                int temp = this.myBook.readUnsignedShort();
                int picNum = this.myBook.readInt();
                this.myBook.close();
                if (t3 == 0 || t4 == 3 || hlcBFrame.lowResolution) {
                    if (hlcBFrame.lowResolution) {
                        fixPName = fixPName + "_low";
                    }
                    hlcBFrame.lowResolution = false;
                    if (!System.getProperty("os.name").toUpperCase().startsWith("LINUX")) {
                        hlccallGraphics cg = new hlccallGraphics(bName, pName, fixPName, picNum, this.getPicInfoOffset(t3, t4, picNum));
                        long rc = cg.convertPicture();
                        if (rc == 0L) {
                            this.DesPic = fixPName + ".gif";
                            this.extractSize();
                            this.picSize = new Rectangle(this.picWidth, this.picHeight);
                        }
                        return rc;
                    }
                    this.errorMessage = "Graphics conversion not supported.";
                    return -1L;
                }
                if (t3 == 1 && t4 == 0) {
                    hlcjXObj wobj = new hlcjXObj(bName, pName, fixPName, picNum, bookFrameSize);
                    hlcBFrame.lowResolution = false;
                    int temp2 = wobj.extractPicture();
                    if (temp2 == 0) {
                        this.picSize = wobj.getWebObjectHW();
                        this.DesPic = wobj.getObjName();
                        return temp2;
                    }
                    if (temp2 == -1) {
                        this.errorMessage = "Unsupported picture type.";
                        return temp2;
                    }
                    if (temp == -2) {
                        this.errorMessage = "Unable to locate picture.";
                        return temp2;
                    }
                    if (temp == -3) {
                        this.errorMessage = "Bad mime type formatin picture.";
                        return temp2;
                    }
                    return temp2;
                }
                this.errorMessage = "Unknown Book Architecture.";
                return -1L;
            }
            catch (IOException doh) {
                this.errorMessage = "Error converting picture.";
                return -1L;
            }
        }
        return 11L;
    }

    public boolean isOpen() {
        return this.picIsOpen;
    }

    public Rectangle getPicSize(Rectangle minSize, Rectangle maxSize, boolean doScale) {
        if (this.picHeight * this.picWidth == 0) {
            this.extractSize();
        }
        Rectangle picSize = new Rectangle(this.picWidth, this.picHeight);
        if (!(!doScale || picSize.contains(minSize) && maxSize.contains(picSize))) {
            if (picSize.contains(minSize)) {
                double reducFac = Math.min(maxSize.getWidth() / picSize.getWidth(), maxSize.getHeight() / picSize.getHeight());
                picSize.setRect(0.0, 0.0, (double)this.picWidth * reducFac, (double)this.picHeight * reducFac);
            } else {
                double magFac = Math.max(minSize.getWidth() / picSize.getWidth(), minSize.getHeight() / picSize.getHeight());
                picSize.setRect(0.0, 0.0, (double)this.picWidth * magFac, (double)this.picHeight * magFac);
            }
        }
        return picSize;
    }

    public Rectangle scalePicSize(Rectangle minSize, Rectangle maxSize, Rectangle oldPicSize) {
        Rectangle newPicSize = new Rectangle(oldPicSize);
        this.picWidth = (int)newPicSize.getWidth();
        this.picHeight = (int)newPicSize.getHeight();
        if (!newPicSize.contains(minSize) || !maxSize.contains(newPicSize)) {
            if (newPicSize.contains(minSize)) {
                double reducFac = Math.min(maxSize.getWidth() / newPicSize.getWidth(), maxSize.getHeight() / newPicSize.getHeight());
                newPicSize.setRect(0.0, 0.0, (double)this.picWidth * reducFac, (double)this.picHeight * reducFac);
            } else {
                double magFac = Math.max(minSize.getWidth() / newPicSize.getWidth(), minSize.getHeight() / newPicSize.getHeight());
                newPicSize.setRect(0.0, 0.0, (double)this.picWidth * magFac, (double)this.picHeight * magFac);
            }
        }
        return newPicSize;
    }

    public String getPictureLocName() {
        return this.DesPic;
    }

    private boolean checkPictureExists(String fixPName) {
        File gif_pic = new File(fixPName + ".gif");
        this.DesPic = fixPName + ".gif";
        if (gif_pic.exists() && gif_pic.length() > 0L) {
            return true;
        }
        File jpg_pic = new File(fixPName + ".jpg");
        if (jpg_pic.exists() && jpg_pic.length() > 0L) {
            this.DesPic = fixPName + ".jpg";
            return true;
        }
        File png_pic = new File(fixPName + ".png");
        if (png_pic.exists() && png_pic.length() > 0L) {
            this.DesPic = fixPName + ".png";
            return true;
        }
        return false;
    }

    private void extractSize() {
        if (this.DesPic.endsWith(".gif")) {
            try {
                RandomAccessFile myGif = new RandomAccessFile(this.DesPic, "r");
                myGif.seek(10L);
                int mapByte = myGif.readUnsignedByte();
                int mapOffset = 0;
                if ((mapByte & 0x80) != 0) {
                    mapOffset = (1 << (mapByte & 7) + 1) * 3 + 13;
                }
                myGif.seek(mapOffset);
                int code = myGif.readUnsignedByte();
                if (code == 33) {
                    myGif.seek((long)mapOffset + 2L);
                    int extBlkSize = myGif.readUnsignedByte();
                    myGif.seek(mapOffset += 4 + extBlkSize);
                    code = myGif.readUnsignedByte();
                }
                if (code == 44) {
                    myGif.seek((long)mapOffset + 5L);
                    this.picWidth = myGif.readUnsignedByte() + 256 * myGif.readUnsignedByte();
                    this.picHeight = myGif.readUnsignedByte() + 256 * myGif.readUnsignedByte();
                }
                myGif.close();
            }
            catch (IOException doh) {
                JOptionPane.showMessageDialog(null, "Error reading picture information.", "IBM Softcopy Reader", 0);
            }
        } else if (this.DesPic.endsWith(".jpg")) {
            try {
                int code;
                boolean startOfQuant = false;
                boolean startOfFrame0 = false;
                RandomAccessFile myJpeg = new RandomAccessFile(this.DesPic, "r");
                while (!startOfQuant) {
                    code = myJpeg.readUnsignedByte();
                    if (code != 255 || (code = myJpeg.readUnsignedByte()) != 219) continue;
                    startOfQuant = true;
                }
                while (!startOfFrame0) {
                    code = myJpeg.readUnsignedByte();
                    if (code != 255 || (code = myJpeg.readUnsignedByte()) != 192) continue;
                    startOfFrame0 = true;
                }
                code = myJpeg.readUnsignedByte();
                code = myJpeg.readUnsignedByte();
                code = myJpeg.readUnsignedByte();
                code = myJpeg.readUnsignedByte();
                this.picHeight = code * 256 + myJpeg.readUnsignedByte();
                code = myJpeg.readUnsignedByte();
                this.picWidth = code * 256 + myJpeg.readUnsignedByte();
                myJpeg.close();
            }
            catch (IOException doh) {
                JOptionPane.showMessageDialog(null, "Error reading picture information.", "IBM Softcopy Reader", 0);
            }
        }
    }

    public void showPic(JFrame f, Rectangle pictureSize) {
        this.pf = new JDialog((Frame)f, this.DesPic);
        this.pf.setTitle("IBM Softcopy Reader Image");
        ImageIcon dPic = new ImageIcon(this.DesPic);
        JPanel p = (JPanel)this.pf.getContentPane();
        int newW = (int)pictureSize.getWidth();
        int newH = (int)pictureSize.getHeight();
        ImageIcon sPic = new ImageIcon(dPic.getImage().getScaledInstance(newW, newH, 4));
        JLabel imageContainer = new JLabel(sPic);
        imageContainer.setLocation(5, 15);
        imageContainer.setSize(newW, newH);
        JScrollPane jsp = new JScrollPane(imageContainer);
        this.pf.getContentPane().add(jsp);
        this.pf.setSize(newW + 10, newH + 30);
        this.pf.setLocationRelativeTo(f);
        this.pf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    hlcjXPicture.this.pf.setVisible(false);
                    hlcjXPicture.this.picIsOpen = false;
                    hlcjXPicture.this.pf.dispose();
                }
            }
        });
        this.pf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                hlcjXPicture.this.pf.setVisible(false);
                hlcjXPicture.this.picIsOpen = false;
                hlcjXPicture.this.pf.dispose();
            }
        });
        this.pf.setVisible(true);
        this.picIsOpen = true;
    }

    private int getPicInfoOffset(int v1, int v2, int pNum) {
        if (v1 == 1 && v2 == 3) {
            return 280 + pNum * 16;
        }
        return 280;
    }
}

