/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class hlcDTree
extends JTree {
    private String pathToAdd;
    static final String fsep = System.getProperty("file.separator");

    public hlcDTree(final JDialog dialog) {
        DefaultMutableTreeNode rootNode = this.getDrives();
        ((DefaultTreeSelectionModel)this.getSelectionModel()).setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setFont(new Font("Dialog", 0, 11));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent evt) {
                dialog.setCursor(new Cursor(3));
                hlcDTree.this.expandNode(evt.getPath());
                dialog.setCursor(new Cursor(0));
            }

            public void treeCollapsed(TreeExpansionEvent evt) {
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (!hlcDTree.this.isSelectionEmpty()) {
                    TreePath selectedTreePath = hlcDTree.this.getSelectionPath();
                    hlcDTree.this.pathToAdd = ((File)((DefaultMutableTreeNode)selectedTreePath.getLastPathComponent()).getUserObject()).toString();
                }
            }
        });
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        model.setAsksAllowsChildren(true);
        this.setModel(model);
        this.setCellRenderer(new directoryTreeCellRenderer());
        this.setRootVisible(false);
        this.expandRow(0);
        this.setShowsRootHandles(true);
    }

    private void expandNode(TreePath tp) {
        File[] files;
        File file;
        DefaultMutableTreeNode node;
        if (tp != null && (node = (DefaultMutableTreeNode)tp.getLastPathComponent()).getChildCount() == 0 && (file = (File)node.getUserObject()).exists() && (files = file.listFiles()) != null) {
            int length = files.length;
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            for (int i = 0; i < length; ++i) {
                if (!files[i].isDirectory()) continue;
                model.insertNodeInto(new DefaultMutableTreeNode(files[i]), node, node.getChildCount());
            }
        }
    }

    private DefaultMutableTreeNode getDrives() {
        File[] rootList = File.listRoots();
        DefaultMutableTreeNode systemNode = new DefaultMutableTreeNode("Computer");
        if (rootList != null) {
            for (int i = 0; i < rootList.length; ++i) {
                String drive = rootList[i].toString().toUpperCase();
                if (drive.startsWith("A") || drive.startsWith("B") || !rootList[i].exists()) continue;
                systemNode.add(new DefaultMutableTreeNode(rootList[i]));
            }
        }
        return systemNode;
    }

    public String getPathToAdd() {
        return this.pathToAdd;
    }

    private class directoryTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private directoryTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(Color.blue);
                this.setForeground(Color.white);
                if (hasFocus) {
                    this.setBorder(BorderFactory.createLineBorder(Color.yellow));
                } else {
                    this.setBorder(BorderFactory.createLineBorder(Color.blue));
                }
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                this.setBorder(BorderFactory.createLineBorder(Color.white));
            }
            if (!leaf && !node.isRoot()) {
                String directory = ((File)node.getUserObject()).toString();
                if (directory.endsWith(":" + fsep)) {
                    this.setIcon(new ImageIcon("HardDrive.gif"));
                    this.setText(directory);
                } else {
                    if (expanded) {
                        this.setIcon(new ImageIcon("TreeOpen.gif"));
                    } else {
                        this.setIcon(new ImageIcon("TreeClosed.gif"));
                    }
                    int length = directory.length();
                    int index = directory.lastIndexOf(fsep);
                    this.setText(directory.substring(index + 1, length));
                }
            }
            return this;
        }
    }
}

