#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        tput.cmd                                                    */
/* Function:    Put the whole directory tree                                */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/
      
curmode = .true
 
ftp = .xFtp~new                         -- create ftp object
--ftp~debug = .true                       -- request debug messages 
                                        -- connect to server 
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'remote slash' ftp~rslash           -- remote slash   
say 'current local directory:' directory()
say 'files/directories found therein:'
rc = ftp~showLDir()                     -- show what's in there 
say

if curmode then do
  /*------------------------------------------------------------------------*/
  /* Put contents of current directory including all its subdirectories     */
  /*------------------------------------------------------------------------*/
  rc = directory('testdir')             -- switch locally to "testdir" 
  say 'files/directories found in "testdir":'
  rc = ftp~showLDir()                   -- show what's in there 
  say
  say '-----tput(, rdir)---------'
  say 'put all current files/directories to the remote directory "yourdir"'      
  rc = ftp~tput(, 'yourdir')            -- get current dir content into yourdir
  say 'current local directory tree transferred to "yourdir" with rc =' rc 
end 
else do
  /*------------------------------------------------------------------------*/
  /* Put local directory ldir including all its subdirectories              */
  /*------------------------------------------------------------------------*/
  say 'remote dir:' ftp~pwd
  say
  say '-----tput(ldir,rdir)------'
  say 'put local directory "testdir" and all its subdirectories'      
  rc = ftp~tput('testdir', 'yourdir')   -- put the whole directory tree
  say 'local directory tree transferred to "yourdir" with rc =' rc 
end
say '---------------------------'
say 'current local dir:' directory()    -- show that it returned to current directory 

error:
  say 'logoff:' ftp~logoff              -- logoff from server
  exit 0

::REQUIRES "xftp.cls"                                          