#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        mput.cmd                                                    */
/* Function:    Put multiple files                                          */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      

ftp = .xFtp~new                         -- create ftp object
ftp~debug = .true                       -- request debug messages 
                                        -- connect to server 
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'remote slash' ftp~rslash           -- remote slash   
say 'remote dir:' ftp~pwd               -- display remote directory
say 'local dir:' directory('testdir')   -- display local directory 
say
ftp~cd('putdir')
say 'remote dir:' ftp~pwd
rc = ftp~getRDirList()
if rc \= -1 & rc \= 0 then do
  say 'directories found and created:'
  do dir over rc; say dir; end
end 
say
say '-----put(fname)------------'
say 'puts a local file to current remote directory'      
rc = ftp~put('myfile.txt')              -- use base ftp method
say 'local file sent with rc =' rc 
say
ftp~cd('target1')
say 'remote dir:' ftp~pwd

say '-----mput()----------------'
say 'puts all files to the current remote directory'      
rc = ftp~mput()                         -- use xftp method (multiple put)
say 'local files sent with rc =' rc 
say
say '-----mput(,dir)------------'
say 'puts all files to remote directory "target2"'      
rc = ftp~mput(, '..\target2')           -- use xftp method (multiple put) 
say 'local files sent with rc =' rc 
say  
say '-----mput(pattern,dir)-----'
say 'puts all files to remote directory "target3" matching pattern "*.txt"'      
rc = ftp~mput('*.txt', '..\target3')    -- use xftp method (multiple put) 
say 'local files sent with rc =' rc 

say 'logoff:' ftp~logoff 
exit 0 

::REQUIRES "xftp.cls" 