/********************************************************/
/*                                                      */
/* MCLIENT.CMD - IBM REXX Sample Program                */
/*                                                      */
/* Client program for the mirror server. Ask the user   */
/* for a string, send the string to the mirror server   */
/* and print the mirrored string.                       */
/*                                                      */
/* Parameters:                                          */
/*   Server: alias name of mirror server                */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1996 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/
Parse Arg Server

/* Load REXX Socket library if not already loaded       */
If RxFuncQuery("SockLoadFuncs") Then
 Do
   Call RxFuncAdd "SockLoadFuncs","RXSOCK","SockLoadFuncs"
   Call SockLoadFuncs
 End

/* Ask user for string to send to the mirror server     */
Say "Please enter a string that should be mirrored"
Parse Pull InpString

/* create a TCP socket                                  */
Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")

/* resolve server name alias to dotted IP address       */
Call SockGetHostByName Server, "Host.!"

/* connect the new socket to the specified server       */
Host.!family = "AF_INET"
Host.!port = 1996
Call SockConnect Socket, "Host.!"

/* send the input string to the mirror server           */
Call SockSend Socket, InpString

/* receive answer from mirror server and close socket   */
Call SockRecv Socket, "OutString", 256
Call SockShutDown Socket, 2
Call SockClose Socket

Say "The string '" || InpString || "' was mirrored to"
Say "'" || OutString || "'."
