/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  NetCentric Computing with Object Rexx                                    */
/*  Programming Example                                                      */
/*                                                                           */
/*  (c) Copyright IBM Corporation 1999                                       */
/*                                                                           */
/*  myHtml.cls - My Personal HTML Class for dynamic HTML generation          */
/*                                                                           */
/*  Requirements:                                                            */
/*    html.frm  - HTML Support Framework  (the base HTML Support Class)      */
/*                                                                           */
/*  This code is sample code, provided "AS IS", without warranty of any kind */
/*                                                                           */
/*---------------------------------------------------------------------------*/

::REQUIRES "html.frm"                  /* setup html framework               */ 

::CLASS myHtml PUBLIC SUBCLASS html

/*---------------------------------------------------------------------------*/
::METHOD home                          /* home page reference                */
  return self~aref('/orxwww/main.htm', "<br>- Home Page -", '/orxwww/orxok.gif')

/*---------------------------------------------------------------------------*/
::METHOD myAddress                     /* my home address                    */
  self~pc~b('Object REXX Development')
  return self~br('IBM SWSD Boeblingen, Germany')~br~i('rexxhelp@de.ibm.com')

/*---------------------------------------------------------------------------*/
::METHOD signature                     /* signature and address              */
  return self~img('/orxwww/orxok.gif', 'align=center')~myAddress

/*---------------------------------------------------------------------------*/
::METHOD footing                       /* footing([codefile])                */
                                       /* table with 2 or 3 cells            */ 
  self~table('width =100% border=5 cellpadding=3 cellspacing=1')
  self~tr                              /* table row                          */
                                       /* home reference cell                */
  self~td(.html~new~aref('/orxwww/main.htm', , '/orxwww/orxok.gif'),'align=center') 
                                       /* Body cell of footing               */  
  self~td(.myhtml~new~myAddress)       
  if arg(1, 'e') then                  /* optional "display code" cell       */ 
    self~td(.html~new~aref(arg(1), 'Download<br>CGI<br>Program'),'align=center')   
  return self~etable                   /* end of table                       */ 

/*---------------------------------------------------------------------------*/
::METHOD errormsg                      /* generate an error message          */
  use arg text

  if self~items = 0 then               /* if it is the first entry           */
    self~title('Error Message')        /* put in a title                     */
  else 
    self~h2('Error Message')           /* or a header otherwise              */

  self~p(text)                         /* error message text                 */
  self~p~footing                       /* home reference and address         */
  return self~end                      /* end the error document             */

