/***************************************************************************/
/*                                                                         */
/*  rexxasp2.c               Object REXX samples                           */
/*                                                                         */
/*  Licensed Materials - Property of IBM                                   */
/*  IBM Object REXX for AIX                                                */
/*  (C) Copyright IBM Corp. 1998,  2004                                    */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                     */
/* code is sample code created by IBM Corporation. This                    */
/* sample code is not part of any standard or IBM                          */
/* product and is provided to you solely for the                           */
/* purpose of assisting you in the development of your                     */
/* applications.  The code is provided "AS IS", without                    */
/* warranty of any kind.  IBM shall not be liable for                      */
/* any damages arising out of your use of the sample                       */
/* code,  even if they have been advised of the                            */
/* possibility of such damages.                                            */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  Description:       functions used by Object REXX script                */
/*                                                                         */
/***************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define  INCL_REXXSAA
#define  INCL_DOSMEMMGR
#include <rexx.h>

/*********************************************************************/
/* Numeric Return calls                                              */
/*********************************************************************/

#define  INVALID_ROUTINE 40            /* Raise Rexx error           */
#define  VALID_ROUTINE    0            /* Successful completion      */

#ifdef __cplusplus
extern "C" {
#endif


/*********************************************************************/
/* AspiFncTable                                                      */
/*   Array of names of the REXXASPI functions.                       */
/*   This list is used for registration and deregistration.          */
/*********************************************************************/
static PSZ  AspiFncTable[] =
   {
      "AspiDeregFunc2",
      "Aspi_Fill_REXX_Variable_Pool"
   };


/*************************************************************************
* Function:  AspiLoadFuncs2                                              *
*                                                                        *
* Syntax:    call AspiLoadFuncs2                                         *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    null string                                                 *
*************************************************************************/

LONG APIENTRY AspiLoadFuncs2(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */


  entries = sizeof(AspiFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++)
  {
    RexxRegisterFunctionDll(AspiFncTable[j],
          "rexxasp2", AspiFncTable[j]);
  }
  return VALID_ROUTINE;
}


/*************************************************************************
* Function:  AspiDeregFunc2                                              *
*                                                                        *
* Syntax:    call AspiDeregFuncs2                                        *
*                                                                        *
* Params:    none                                                        *
*                                                                        *
* Return:    null string                                                 *
*************************************************************************/

LONG APIENTRY AspiDeregFunc2(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */

  retstr->strlength = 0;               /* set return value           */

  if (numargs > 0)
    return INVALID_ROUTINE;


  entries = sizeof(AspiFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++)
  {
    RexxDeregisterFunction(AspiFncTable[j]);
  }
  return VALID_ROUTINE;
}



/*************************************************************************
* Function:  AspiRead                                                    *
*                                                                        *
* Syntax:    call Aspi_Fill_REXX_Variable_Pool                           *
*                                                                        *
* Params:    outbuf - variable that will be filled with data             *
* Return:    0 - success, 1 - failure                                    *
*************************************************************************/

LONG APIENTRY Aspi_Fill_REXX_Variable_Pool(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  char   *outbuf = NULL;
  char   *ptr;
  int    i;
  SHVBLOCK shvb;

  /* we expect 1 argument */

  if (numargs != 1 )                    /* validate arg count         */
  {
    strcpy(retstr->strptr, "Aspi_Fill_REXX_Variable_Pool expects 1 Arguments");
    retstr->strlength = strlen(retstr->strptr);
    return VALID_ROUTINE;
  }

  /* preset the return value */

  strcpy(retstr->strptr, "0");
  retstr->strlength = strlen(retstr->strptr);

  outbuf = (char *) malloc(300);
  if (outbuf == NULL)
  {
    strcpy(retstr->strptr, "Aspi_Fill_REXX_Variable_Pool received a allocation fault");
    retstr->strlength = strlen(retstr->strptr);
    return VALID_ROUTINE;
  }

  ptr = outbuf;
  for (i=0; i<300; i++)
  {
     *ptr = i % 256;
     ptr++;
  }

/* copying the buffer to the REXX Variable Pool ****************/

  shvb.shvnext = NULL;
  shvb.shvname.strptr = args[0].strptr;
  shvb.shvname.strlength = strlen(args[0].strptr);
  shvb.shvnamelen = shvb.shvname.strlength;
  shvb.shvvalue.strptr = outbuf;
  shvb.shvvalue.strlength = 300;
  shvb.shvvaluelen = 300;
  shvb.shvcode = RXSHV_SYSET;
  shvb.shvret = 0;
  if (RexxVariablePool(&shvb) == RXSHV_BADN)
  {
    free(outbuf);
    strcpy(retstr->strptr, "1");
    return INVALID_ROUTINE;
  }

  free(outbuf);
  return VALID_ROUTINE;
}


#ifdef __cplusplus
}
#endif



