/***************************************************************************/
/*                                                                         */
/*  aspitest                 Object REXX samples                           */
/*                                                                         */
/*  Licensed Materials - Property of IBM                                   */
/*  IBM Object REXX for AIX                                                */
/*  (C) Copyright IBM Corp. 1998,  2004                                    */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                     */
/* code is sample code created by IBM Corporation. This                    */
/* sample code is not part of any standard or IBM                          */
/* product and is provided to you solely for the                           */
/* purpose of assisting you in the development of your                     */
/* applications.  The code is provided "AS IS", without                    */
/* warranty of any kind.  IBM shall not be liable for                      */
/* any damages arising out of your use of the sample                       */
/* code,  even if they have been advised of the                            */
/* possibility of such damages.                                            */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  Description:                                                           */
/*                                                                         */
/* Object REXX starts a C-function that reads all variables that exist     */
/* in the variable pool of a running REXX program.                         */
/*                                                                         */
/***************************************************************************/

Call RxFuncAdd "AspiLoadFuncs2", "rexxasp2", "AspiLoadFuncs2"
Call AspiLoadFuncs2

call Aspi_Fill_REXX_Variable_Pool "ReadBuf"
Say 'Length of Buffer allocated by the C-function: ' Length(ReadBuf)

Say 'The C-function Aspi_Fill_REXX_Variable_Pool has put the following data into the buffer: '

Do i = 1 To Length(ReadBuf)
  Say 'Position in buffer:' i 'Decimal Value:' C2D(SubStr(ReadBuf, i, 1)) 'Hex Value: ' C2X(SubStr(ReadBuf, i, 1))
End

call AspiDeregFunc2

exit
