#-------------------------------------------------------------------------
# rexxasp1.mak : makefile to build librexxasp1.so
#-------------------------------------------------------------------------

# -----------------------  Path Definitions  ----------------------------
BLD_PATH = .
INC_PATH = -I. -I/usr/local/orexx
LIB_PATH = -L. -L/usr/local/orexx/lib 
#
# Compiler macros
#
cc = g++ -fPIC
link = gcc
DEL_CMD	 = rm -f
#
CFLAGS	   = -c	-ggdb -D__cplusplus
link_lib_flags_librxasp1 = -shared -rdynamic -lpthreads -lrexxapi -lc  -lm  
 
RXAPI_OBJ  = rexxasp1.o

# *************************************************************************** #
# Rules									      #
# *************************************************************************** #
.c.o:
	$(cc) $(CFLAGS) -o$*.o $(INC_PATH) $(LIB_PATH) $*.c

#---------------------------------------------------------- Generate library

librexxasp1.so: $(RXAPI_OBJ)
	rm -f $(BLD_PATH)/$@
	$(link) -Wl,-soname,$@ -o $(BLD_PATH)/$@ $(RXAPI_OBJ) \
	$(LIB_PATH) $(link_lib_flags_librxasp1)

#----------------------------------------------------------
all: librexxasp1.so

#---------------------------------------------------------- END	section
clean:
	- $(DEL_CMD) $(RXAPI_OBJ)
	- $(DEL_CMD) $(BLD_PATH)/librexxasp1.so

