         TITLE 'EAG   3.0 * EAGSTC stub C/370 "OS" Type PLIST'
***********************************************************************
*
* Module name:       EAGSTC
*
* Descriptive name:  Stub for C/370 "OS" linkage PLIST
*
* Author:            Thorsten Schaper, IBM
*                    thorsten.schaper@de.ibm.com
*
* Created:           07/19/2000
* Last modfication: 11/30/2000
*
* Function:
*   This module serves as stub and is linked together with a compiled
*   REXX program of OBJ type - such a linked load module can be linked
*   with C/370 load modules from where these compiled external REXX
*   functions can directly be invoked, using a simple function call!
*
*   - EAGSTC expects to be supplied with a C/370 "OS"-linkage type
*     parameter list.
*   - EAGSTC converts the input parameter list handed over by C
*     into arguments for invoking IRXEXEC.
*   - IRXEXEC takes care of executing the REXX code under a REXX
*     Environment. It branches to the compiled preloaded REXX code.
*   - EAGSTC also prepares the outcome (return value or abend) for
*     C/370s needs.
*
* Parameter list for the invocation of IRXEXEC:
*   1.  Address of exec block         (not supplied - 0).
*   2.  Address of the argument list.
*   3.  Address of invocation type    (Subroutine, ext. return codes).
*   4.  Address of in-storage block - describes the compiled program.
*   5.  Address of the CPPL           (not supplied - 0).
*   6.  Address of an EVALBLOCK       (max. 256 byte return value).
*   7.  Address of a work area vector (not supplied - 0).
*   8.  Address of user field         (not supplied - 0).
*   9.  Address of Environment block  (created with IRXINIT in batch).
*
* Processing sequence:
*   1. Save registers.
*   2. Determine number of actually passed arguments.
*   3. Obtain storage required for execution of the stub.
*       - unconditionally -> terminate if GETMAIN fails.
*       - with subppol number = 0
*   4. LOAD IRXINIT.
*   5. Test if there is already an active REXX Environment
*       - done with IRXINIT/FINDENVB
*       - under TSO/E you get it initialized during Logon.
*       - under MVS you don't have an initialized environment.
*   6. If in MVS environment initiailze a new MVS-REXX Environment.
*       - done with IRXINIT/INITENVB
*   7. Build IRXEXEC parameter list (including arg-conversion).
*      The C-stub uses only parameters 1-8 of IRXEXEC.
*   8  Initialize control blocks (CB)
*       - in-storage CB (describing preloaded EXEC)
*       - EVALBLOCK  CB (describing result passed back by REXX EXEC)
*   9. Invoke IRXEXEC.
*  10. Convert the result supplied by IRXEXEC.
*      Set reg 15 in caller's save area:
*       - in case of success the return code, which is the address of
*         the result string (-> CHAR*), is passed back in reg 15.
*       - in case of abend (IRXxxx ret code is 100 or 104) reg 0 will
*         additionaly be set and contain the abend and reason code.
*       - in case IRXEXEC has passed back a truncated result (because
*         the whole result string wouldn't fit in the initialized 256
*         byte EVALBLOCK) we must GETMAIN place for a bigger EVALBLOCK
*         and let it be filled by invoking IRXRLT/GETRLT.
*  11. DELETE IRXINIT, do not care about errors.
*  12. Free obtained storage.
*       - conditionally -> do NOT terminate if FREEMAIN fails.
*  13. Restore registers
*  14. Return to the caller.
*
*             ------------------------------
*                                           |
* -------   --------------               |
* |       -->| a  r  g  l 00|               |
* ----   ----------                |
* |       - --------------------         |
* ---- >| s  p  a  r  g  l 00|         |
*             --------------          |
*   ...                                     |
*             -----------------------------|
* ----   -----------------           ||
* |'      -->| H  e  l  l  o 00|           ||
* ----   ------------            ||
*                                          ||
*             ----------------------------||
* -------   -----------                |||
* |       Ӳ->|00 00 00 00|                |||
* -------  --------                |||
* |       |----------------->------------->----------------------
* -------|  -----------   --------||           |00 00 Len 1|
* |       |->|90 00 00 00|                || ----------------
* -------|  --------   -----------|-           |00 00 Len 2|
* |       |->------------->| INSTBLK   ||  ----------------
* -------|  --------   -----------|
* |                                      |  ----------------
* -------                  -------------           |00 00 Len n|
* |       |->------------->| EVALBLOK  |   ----------------
* -------|  --------   -----------   |FF FF FF FF|FF FF FF FF|
* |                                         ----------------
* -------
* |       Ө
* -------
*
***********************************************************************
                                                                EJECT
***********************************************************************
* Stub entry coding:
* - AMODE=31 and RMODE=ANY is REXX/370 standard.
* - Keep in mind that the names "EAGSTUB" and "EAGOBJ" will get CHANGED
*   during linkage.
* - Save registers.
* - Establish code addressability.
* - Insert ID string into module.
***********************************************************************
                                                                SPACE 1
EAGSTUB  AMODE 31
EAGSTUB  RMODE ANY
EAGSTUB  CSECT
         ENTRY EAGSTUB
         EXTRN EAGOBJ
                                                                SPACE 1
         STM   R14,R12,12(R13)      Save regs in caller's save area
         LR    R12,R15              Set base reg to start of load mod
         USING EAGSTUB,R12          CSECT EAGSTUB addressability
         B     COUNTARG             Branch around ID string in load mod
                                                                SPACE 1
STIDL    DC    AL2(L'STID+L'STIDX)  ID string
STID     DC    C' EAGSTC - C/370 "OS" LINKAGE'
STIDX    DC    C' Stub compiled at: &SYSDATE &SYSTIME'
         DS   0D
         DC    A(EAGSTBL)           Length of stub
         DC    F'0'
                                                                SPACE 1
***********************************************************************
* Determine the number of arguments passed:
* - R2 is used to remember the argument list address.
* - R3 is used as counter.
* - The last arguments addr is marked with the HOB=high-order-bit=1.
***********************************************************************
                                                                SPACE 1
COUNTARG DS   0H
         LA    R3,0                 Set argument counter to zero
         LTR   R2,R1                ...does input parm vector exist?
         BZ    GETSTOR              -> No, skip counting
                                                                SPACE 1
NEXTARG  DS   0H
         LA    R3,1(,R3)            Increase R3 by 1 (found next arg)
         ICM   R4,B'1111',0(R1)     Get arg address, Set cond. flags
         BM    GETSTOR              ...HOB set? -> was the last in list
         LA    R1,4(,R1)            Let R1 point to next arg's addr
         B     NEXTARG
                                                                SPACE 1
***********************************************************************
* Get the required storage:
* - Size of storage to be gotten depends on number of arguments passed:
*   - For each arg 1 DW (8 byte) is needed:
*     - 1.st FW - address of argument string
*     - 2.nd FW - length  of argument string
*   - Additionaly IRXEXEC requires another DW of X'FF' for closing its
*     parmlist (-> this DW is called the FENCE).
* - The first 18 fullwords of gotten storage are my save area (STSAVE).
* - Establish forw<->backw linkage of caller's and my own save area.
***********************************************************************
                                                                SPACE 1
GETSTOR  DS   0H
         LA    R3,1(,R3)            Increase R3 by 1 (needed for FENCE)
         SLL   R3,3                 Multiply with 8 (1 DW for each arg)
         LA    R0,STSTORAL(,R3)     Add to length of STSTORAG DSECT
         GETMAIN RC,LV=(0)
         LTR   R15,R15              ...did I get the memory?
         BNZ   RETMEME              -> no, return memory error code
                                                                SPACE 1
         ST    R13,4(,R1)           Save caller's SA addr in my SA
         ST    R1,8(R13)            Save my SA addr in caller's SA
         LR    R13,R1               Let R13 point to gotten storage
         USING STSTORAG,R13         DSECT STSTORAG addressability
         ST    R0,STSTLEN           Keep size of gotten storage
                                                                SPACE 1
***********************************************************************
* Detect if there is already an active REXX Environment block:
* - Build IRXINIT parmlist for FINDENVB command.
* - LOAD IRXINIT.
* - Invoke IRXINIT.
* - Handle result:
*   - if found -> store address to that environment in STAENV.
*   - if none is available -> initialize it (see next code block).
***********************************************************************
                                                                SPACE 1
         LA    R3,FINDENVB          Name of IRXINIT function
         LA    R4,NIL               No parameter module
         LA    R5,NIL               No in-storage block
         LA    R6,NIL               No user field
         LA    R7,NIL               Reserved
         LA    R8,STAENV            Addr of REXX environment block
         LA    R9,STIRXRSN          Addr for IRXINIT reason code
         LA    R10,NIL              No work area
         O     R10,LASTARG          Mark as last argument with HOB on
         STM   R3,R10,STPLIST       Store those addrs into STPLIST
                                                                SPACE 1
         LA    R3,LOADIXIN          Get addr of LOAD macro list
         LOAD  SF=(E,(3))           Load IRXINIT into memory
         LR    R11,R0               Keep IRXINIT entry point addr
                                                                SPACE 1
         LR    R15,R0               Get addr of IRXINIT entry point
         LA    R1,STPLIST           Get addr of PLIST for IRXINIT
         BASR  R14,R15              Invoke IRXINIT
                                                                SPACE 1
         C     R15,SABEND           ...did a system abend occur?
         BZ    RETENVE              -> yes
         C     R15,UABEND           ...did an user abend occur?
         BZ    RETENVE              -> yes
                                                                SPACE 1
         LA    R10,4(,R0)
         CLR   R15,R10              ...is the env-blk addr set?
         BH    INITENV              -> no, create new env-blk
         B     PARMLIST
                                                                SPACE 1
***********************************************************************
* Initialize REXX environment block:
* - Needed when program was started via JCL in MVS batch environment.
* - Build IRXINIT parmlist for INITENVB command.
*   - Using the IRXPARMS parameter module
* - Invoke IRXINIT.
* - Store address to that environment in STAENV.
***********************************************************************
                                                                SPACE 1
INITENV  DS   0H
         LA    R3,INITENVB          Point to IRXINIT function name
         LA    R4,PARMMOD           Point to IRXINIT parm mod name
         LA    R5,NIL               Point to 0: no in-storage block
         LA    R6,NIL               Point to 0: no user field
         LA    R7,NIL               Point to 0: reserved
         LA    R8,STAENV            Point to addr of REXX ENVBLOCK
         LA    R9,STIRXRSN          Point to IRXINIT reason code field
         LA    R10,NIL              Point to 0: no work area
         O     R10,LASTARG          Mark as last argument with HOB on
         STM   R3,R10,STPLIST       Store those pointers into STPLIST
                                                                SPACE 1
         LR    R15,R11              Get addr of IRXINIT entry point
         LA    R1,STPLIST           Get addr of PLIST for IRXINIT
         BASR  R14,R15              Invoke IRXINIT
                                                                SPACE 1
         C     R15,SABEND           ...did a system abend occur?
         BZ    RETENVE              -> yes
         C     R15,UABEND           ...did an user abend occur?
         BZ    RETENVE              -> yes
                                                                SPACE 1
         LA    R10,4(,R0)           Load R10 with 4
         CLR   R15,R10              ...is the env-blk addr set? (RC<=4)
         BH    RETENVE              -> no, give it up...
         ST    R0,STAENV            -> yes, save it
         B     PARMLIST
                                                                SPACE 1
***********************************************************************
* Build up STPLIST, the IRXEXEC parmlist. It contains the addresses of
* 8 arguments, where the real arguments are:
* - 4* NIL          (DC XL4'00000000')
* - 1* INVOTYPE     (DC XL4'30000000')
* - 1* STAARGV      (DS A - will be set up to point to STARGV)
* - 1* STAINST      (DS A - will be set up to point to STINSTB)
* - 1* STAEVAL      (DS A - will be set up to point to STEVALB)
***********************************************************************
                                                                SPACE 1
PARMLIST DS   0H
         LA    R3,NIL               Point to 0: no exec block
         LA    R4,STAARGV           Point to addr of argument vector
         LA    R5,INVOTYPE          Point to invocation type field
         LA    R6,STAINST           Point to addr of in-storage block
         LR    R7,R3                Point to 0: no CPPL
         LA    R8,STAEVAL           Point to addr of EVALBLOCK
         LR    R9,R3                Point to 0: no work area
         LR    R10,R3               Point to 0: no user field
         LA    R11,STAENV
         O     R11,LASTARG          Mark as last argument with HOB on
         STM   R3,R11,STPLIST       Store those pointers into STPLIST
                                                                SPACE 1
         LA    R3,STARGV            Let STAARGV point to STARGV
         ST    R3,STAARGV
         LA    R3,STINSTB           Let STAINST point to STINSTB
         ST    R3,STAINST
         LA    R3,STEVALB           Let STAEVAL point to STEVALB
         ST    R3,STAEVAL
                                                                SPACE 1
***********************************************************************
* Now fill the addresses and lengths of the delivered arguments into
* parmlist at STARGV as required by IRXEXEC:
* - The input argument vector consists of addresses pointing to
*   character strings (CHAR*).
* - The length is determined by scanning memory from the address of the
*   argument string until a byte of X'00' is found.
* - R2 is original R1, so it points to input argument vector.
***********************************************************************
                                                                SPACE 1
         LA    R11,STARGV           Get addr of parmlist vector
         LTR   R2,R2                ...is addr of arg vector = 0?
         BZ    DONEARG              -> yes, don't count args
                                                                SPACE 1
NEXTARG2 DS   0H
         L     R3,0(,R2)            Get addr of next argument string
         LA    R7,0(,R3)            Make sure HOB is cleared in addr
         LTR   R7,R7                ...is parm omitted?
         BZ    OMITARG              -> yes, branch
         LR    R4,R7                R4 is used as zero-seek-pointer
         XR    R6,R6                clear R6
                                                                SPACE 1
SEEKZERO DS   0H
         ICM   R6,B'1000',0(R4)     ...are all bits in that byte zeros?
         BZ    ZFOUND               -> yes, string-end-zero found
         LA    R4,1(,R4)            Increase seek-zero-pointer R4 by 1
         B     SEEKZERO
                                                                SPACE 1
ZFOUND   DS   0H
         SR    R4,R7                Calc length of argument string
         B     STORARG
                                                                SPACE 1
OMITARG  DS   0H
         XR    R4,R4                Set arg length to zero
STORARG  DS   0H
         ST    R7,0(,R11)           Store argument addr into parmlist
         ST    R4,4(,R11)           Store argument length into parmlist
         LA    R2,4(,R2)            Let R2 point to next input arg addr
         LA    R11,8(,R11)          Let R11 point to next IRXEXEC parm
         LTR   R3,R3                ...was this the last argument?
         BNM   NEXTARG2             -> no, continue with next argument
                                                                SPACE 1
DONEARG  DS   0H                    Close IRXEXEC parmlist with  a DW
         MVC   0(L'FENCE,R11),FENCE filled with X'FF'
                                                                SPACE 1
***********************************************************************
* Initialize in-storage control block:
* - It will have 1 INSTBLK_ENTRY entry describing the preloaded REXX
*   program.
* - This is parameter 4 for the IRXEXEC invocation.
* - Is used to supply the PARSE SOURCE statement with input.
***********************************************************************
                                                                SPACE 1
         LA    R3,STINSTB           Get addr of in-storage block
         USING INSTBLK,R3           DSECT INSTBLK addressability
         MVI   0(R3),X'00'          Init INSTBLK to X'00'
         MVC   1(LINSTB-1,R3),0(R3)
         MVC   INSTBLK_ACRONYM,INSTBLK_ACRYN
         LA    R4,LINSTB            Set INSTBLK_HDRLEN equal to
         ST    R4,INSTBLK_HDRLEN    LINSTB (lenght of in-stor-block)
         LA    R4,STINSTE           Set INSTBLK_ADDRESS equal to
         ST    R4,INSTBLK_ADDRESS   STINSTE (addr in-stor-block entry)
         LA    R4,LINSTE            Set INSTBLK_USEDLEN equal to
         ST    R4,INSTBLK_USEDLEN   LINSTE (length in-stor-block entry)
         MVC   INSTBLK_MEMBER,=CL8'?'   Want default search order,
*                                       but don't know member name
         MVC   INSTBLK_DDNAME,=CL8''    Don't know DD name
         MVC   INSTBLK_SUBCOM,=CL8''    Don't know initial SUBCOM
         SR    R4,R4                Set INSTBLK_DSNLEN to zero, since
         ST    R4,INSTBLK_DSNLEN    DSNAME is not given
         DROP  R3
                                                                SPACE 1
***********************************************************************
* Initialize in-storage control block entry.
***********************************************************************
                                                                SPACE 1
         LA    R3,STINSTE           Get addr of in-storage block entry
         USING INSTBLK_ENTRY,R3     DSECT INSTBLK_ENTRY addressability
         L     R4,AOBJECT           Set INSTBLK_ENTRY to addr of
         ST    R4,INSTBLK_STMT@     compiled REXX program
         LA    R4,20                Set INSTBLK_STMTLEN to 20 bytes -
         ST    R4,INSTBLK_STMTLEN   this should suffice...
         DROP  R3
                                                                SPACE 1
***********************************************************************
* Initialize EVALBLOCK:
* - Is used for passing back the return string of the REXX program.
* - The preallocated EVALBLOCK is exactly 16 bytes long, which means
*   that it cannot hold ANY result (not one byte), but it will be
*   used by IRXEXEC to store the length of the result (if any at all).
*   So lateron an EVALBLOCK large enough to hold the complete result
*   can be allocated.
***********************************************************************
                                                                SPACE 1
         LA    R3,STEVALB           Get addr of EVALBLOCK
         USING EVALBLOCK,R3         DSECT EVALBLOCK addressability
         XR    R4,R4
         ST    R4,EVALBLOCK_EVPAD1  Set EVALBLOCK_EVPAD1 to zero
         LA    R5,2                 Size of EVALBLOCK in DWs
         ST    R5,EVALBLOCK_EVSIZE  Store size in EVALBLOCK_EVSIZE
         ST    R4,EVALBLOCK_EVLEN   Set EVALBLOCK_EVLEN  to zero
         ST    R4,EVALBLOCK_EVPAD2  Set EVALBLOCK_EVPAD2 to zero
         DROP  R3
                                                                SPACE 1
***********************************************************************
* Invoke IRXEXEC:
* - Get its address from REXX Vector of External Entry Points.
***********************************************************************
                                                                SPACE 1
         L     R7,STAENV            Get addr of REXX Environment block
         USING ENVBLOCK,R7
         L     R8,ENVBLOCK_IRXEXTE  Get addr of IRXEXTE table
         DROP  R7
         USING IRXEXTE,R8
         L     R15,IRXEXEC          Get addr of IRXEXEC entry point
         DROP  R8
                                                                SPACE 1
         LA    R1,STPLIST           Set addr of PLIST for IRXEXEC
         BASR  R14,R15              Invoke IRXEXEC
                                                                SPACE 1
***********************************************************************
* Handle IRXEXEC return value (R15):
* - Can be abend code or zero for successful completion.
***********************************************************************
                                                                SPACE 1
         C     R15,SABEND           ...did a system abend occur?
         BZ    RETEXEE              -> yes
         C     R15,UABEND           ...did an user abend occur?
         BZ    RETEXEE              -> yes
         LTR   R15,R15              ...is IRXEXEC RC == 0 ?
         BZ    GETEVAL              -> yes, processing was successful
         O     R15,RCEXEERR         -> no, set HOB on and
         B     RETVAL                      return the IRXEXEC error RC
                                                                SPACE 1
***********************************************************************
* Get an EVALBLOCK just big enough to contain the whole result:
* - Get storage required for the complete EVALBLOCK (data length + 16)
* - Initialize required fields in the EVALBLOCK.
* - Build IRXRLT parameter block for the GETRLT function of IRXRLT.
* - Invoke IRXRLT.
***********************************************************************
                                                                SPACE 1
GETEVAL  DS   0H
         L     R3,STAEVAL           Get addr of EVALBLOCK
         USING EVALBLOCK,R3         DSECT EVALBLOCK addressability
         L     R5,EVALBLOCK_EVLEN   Get length of return string
         LTR   R5,R5                ...is string lenght = 0?
         BZ    RETNULL              -> return NULL pointer
         C     R5,=X'80000000'      ...is no-data flag set?
         BZ    RETNULL              -> return NULL pointer
         LA    R6,EVALBLOCK_EVDATA  Get addr of return string
         DROP  R3
                                                                SPACE 1
         LCR   R7,R5                Calc required length for result
         LA    R7,16(,R7)           16 byte more needed for EVALBLOCK
         GETMAIN RC,LV=(7)          Get storage for bigger EVALBLOCK
         LTR   R15,R15              ...did I get what I wanted?
         BNZ   RETMEME              -> no, return memory error RC
                                                                SPACE 1
         ST    R1,STAEVAL           Store address of new EVALBLOCK
         USING EVALBLOCK,R1         DSECT EVALBLOCK addressability
         XR    R4,R4
         ST    R4,EVALBLOCK_EVPAD1  Set EVALBLOCK_EVPAD1 to zero
         ST    R4,EVALBLOCK_EVPAD2  Set EVALBLOCK_EVPAD2 to zero
         ST    R4,EVALBLOCK_EVLEN   Set EVALBLOCK_EVLEN  to zero
         SRL   R0,3
         ST    R0,EVALBLOCK_EVSIZE  Store size in EVALBLOCK_EVSIZE
         DROP  R1
                                                                SPACE 1
         LA    R4,GETRLT            Point to function name field
         LA    R5,STAEVAL           Point to addr of EVALBLOCK
         LA    R6,NIL               not used for GETRLT function
         LA    R7,STAENV            Point to addr of ENVBLOCK
         O     R7,LASTARG           Mark as last argument with HOB on
         STM   R4,R7,STPLIST        Store those pointers in STPLIST
                                                                SPACE 1
         L     R7,STAENV            Get addr of REXX Environment block
         USING ENVBLOCK,R7
         L     R8,ENVBLOCK_IRXEXTE  Get addr of IRXEXTE table
         DROP  R7
         USING IRXEXTE,R8
         L     R15,IRXRLT           Get addr of IRXRLT entry point
         DROP  R8
                                                                SPACE 1
         LA    R1,STPLIST           Set addr of PLIST for IRXRLT
         BASR  R14,R15              Invoke IRXRLT 'GETRLT'
                                                                SPACE 1
         LTR   R15,R15              ...was it successful?
         BNZ   RETRLTE              -> no, return IRXRLT error RC
                                                                SPACE 1
         L     R3,STAEVAL
         USING EVALBLOCK,R3         DSECT EVALBLOCK addressability
         L     R5,EVALBLOCK_EVLEN   Get length of return string
         LTR   R5,R5                ...is lenght = 0?
         BZ    RETNULL              -> return NULL pointer
         C     R5,=X'80000000'      ...is no-data flag set?
         BZ    RETNULL              -> return NULL pointer
         LA    R6,EVALBLOCK_EVDATA  Get addr of return string
         DROP  R3
                                                                SPACE 1
***********************************************************************
* Move string:
* - Move the result string 1 Byte back in the EVALBLOCK and append
*   x'00' as closing Byte. The move is necessary because after the
*   result string there is no more space for a x'00' in the EVALBLOCK.
***********************************************************************
                                                                SPACE 1
         LR    R7,R5                Put return string length also in R7
         LR    R4,R6                Put return string addr also in R4
         BCTR  R4,0                 Decrease R4 by 1
         LR    R15,R4               R15=new addr of return string
         MVCL  R4,R6                Move return string 1 byte backwards
         AR    R4,R5                Let R4 point 1 byte after retstring
         MVI   0(R4),X'00'          Close return string with X'00'
                                                                SPACE 1
         MVC   0(L'COOLY1,R3),COOLY1
         MVC   8(L'COOLY2,R3),COOLY2
         B     RETVAL
                                                                SPACE 1
***********************************************************************
* Exit coding:
* - Store return or abend code in caller's save area
*   - In case of abend R15 (abend code) and R0 (reason code) are stored
*     in the caller's save area.
*   - In case of success address of return string (R15) is stored
*     in the caller's save area.
* - Remove IRXINIT from memory.
* - Reestablish R13 to point to caller's save area.
* - Give back storage gotten:
*   - do it conditionally, do not care if not successful.
* - Restore registers (R15 and R0 may be changed)
* - Return to caller.
***********************************************************************
                                                                SPACE 1
RETMEME  DS   0H                    return MEMORY  error return code
         L     R15,RCMEMERR
         B     RETVAL
                                                                SPACE 1
RETENVE  DS   0H                    return IRXINIT error return code
         L     R15,RCENVERR
         B     RETVAL
                                                                SPACE 1
RETEXEE  DS   0H                    return IRXEXEC error return code
         L     R15,RCEXEERR
         B     RETVAL
                                                                SPACE 1
RETRLTE  DS   0H                    return IRXRLT  error return code
         L     R15,RCRLTERR
         B     RETVAL
                                                                SPACE 1
RETNULL  DS   0H                    return NULL pointer as return code
         XR    R15,R15
                                                                SPACE 1
RETVAL   DS   0H
         L     R10,4(,R13)          Get addr of caller's save area
         ST    R15,16(,R10)         Store R15 there
                                                                SPACE 1
         DELETE EPLOC=IRXINITN      Remove IRXEXEC from memory
         L     R0,STSTLEN           Get size of storage gotten in R0
         LR    R1,R13               Get addr of storage gotten in R1
         DROP  R13
         LR    R13,R10              Restore R13 to point to caller's SA
         FREEMAIN RC,LV=(0),A=(1)   Release the allocated memory
         DROP  R12
         LM    R14,R12,12(R13)      Restore registers from caller's SA
         BR    R14                  Return to caller
                                                                EJECT
***********************************************************************
* DC stuff
***********************************************************************
                                                                SPACE 1
AOBJECT  DC    V(EAGOBJ)            Address of compiled program
                                                                SPACE 1
*                                   stub return codes:
RCMEMERR DC    XL4'81000000'         - memory shortage problem
RCENVERR DC    XL4'82000000'         - IRXINIT ended with error
RCEXEERR DC    XL4'83000000'         - IRXEXEC ended with error
RCRLTERR DC    XL4'84000000'         - IRXRLT  ended with error
                                                                SPACE 1
SABEND   DC    F'100'               System Abend of IRXxxx module
UABEND   DC    F'104'               User Abend   of IRXxxx module
                                                                SPACE 1
NIL      DC    XL4'00000000'        NIL
INVOTYPE DC    XL4'30000000'        Subrtn., extended return code
LASTARG  DC    XL4'80000000'        Last argument
FENCE    DC    XL8'FFFFFFFFFFFFFFFF' Fence
                                                                SPACE 1
IRXINITN DC    CL8'IRXINIT'         Name of program to invoke
INITENVB DC    CL8'INITENVB'        Name of IRXINIT function to invoke
FINDENVB DC    CL8'FINDENVB'        Name of IRXINIT function to invoke
PARMMOD  DC    CL8'IRXPARMS'        Name of INITENVB parameter module
                                                                SPACE 1
GETRLT   DC    CL8'GETRLT'          Name of IRXRLT function to invoke
                                                                SPACE 1
COOLY1   DC    CL4'REXX'
COOLY2   DC    CL7'IS COOL'
                                                                SPACE 1
***********************************************************************
* LOAD macro list forms, specifying parameter list for usage by
* an execute form LOAD macro:
* - LOADIXIN for loading IRXINIT
***********************************************************************
                                                                SPACE 1
LOADIXIN LOAD  EPLOC=IRXINITN,SF=L
                                                                SPACE 1
***********************************************************************
* DSECT and EQU stuff:
* - Build up STSTORAG DSECT.
* - Build up INSTBLK, INSTBLK_ENTRY, EVALBLOCK, ENVBLOCK and IRXEXTE
*   DSECTs using the mapping macros IRXINSTB, IRXEVALB, IRXENVB and
*   IRXEXTE.
* - Determine the lengths of INSTBLK, INSTBLK_ENTRY, EVALBLOCK DSECTs
*   (control blocks of that type are contained in the STSTORAG DSECT).
* - Register EQUs.
***********************************************************************
                                                                SPACE 1
STSTORAG DSECT
STSAVE   DS    18F                  My save area
STSTLEN  DS    F                    Length of gotten storage in bytes
STPLIST  DS    9A                   PLIST for IRX... module invocation
STAARGV  DS    A                    Addr of argument vector   (STARGV)
STAINST  DS    A                    Addr of in-storage block  (STINSTB)
STAEVAL  DS    F                    Addr of EVALBLOCK         (STEVALB)
STAENV   DS    F                    Addr of Environment block
STIRXRSN DS    F                    Reason code for IRXINIT abend
         DS   0D
STINSTB  DS    CL(LINSTB)           In-storage block
STINSTE  DS    CL(LINSTE)           In-storage block entry
         DS   0D
STEVALB  DS    CL(LEVALB)           EVALBLOCK
         DS   0D
STARGV   DS   0CL1                  Here starts the argument vector.
*                                   Enough additional space will be
*                                   reserved at start (GETSTOR).
STSTORAL EQU   *-STSTORAG           Determine STSTORAG DSECT length
                                                                SPACE 1
EAGSTUB  CSECT                      mapping macro for INSTBLK
         IRXINSTB DECLARE=YES                     and INSTBLK_ENTRY
EAGSTUB  CSECT                      mapping macro for EVALBLOK
         IRXEVALB DECLARE=NO
EAGSTUB  CSECT
         IRXENVB                    mapping macro for Environment block
EAGSTUB  CSECT
         IRXPARMB                   mapping macro for Parameter block
EAGSTUB  CSECT
         IRXEXTE                    Vector of Entry Points of IRX mods
                                                                SPACE 1
INSTBLK  DSECT ,
         ORG
LINSTB   EQU   *-INSTBLK            Determine DSECT INSTBLK length
                                                                SPACE 1
INSTBLK_ENTRY DSECT ,
         ORG
LINSTE   EQU   *-INSTBLK_ENTRY      Determine DSECT INSTBLK_ENTRY lngth
                                                                SPACE 1
EVALBLOCK DSECT ,
         ORG
LEVALB   EQU   *-EVALBLOCK+16       Determine DSECT EVALBLOCK length.
*                                   Reserve space for a return value of
*                                   up to 0 characters -> must always
*                                   obtain a new EVALBLOCK.
                                                                SPACE 1
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
                                                                SPACE 1
EAGSTUB  CSECT
         DS   0D
EAGSTBL  EQU   *-EAGSTUB            Determine stub code length
         END
