//Copyright 2014,2015 MCbx, All rights reserved.
//http://mcbx.netne.net/ictester
//This file is part of ICTester.
//ICTester is free software; you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation; either version 2 of the License, or
//(at your option) any later version.
//ICTester is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//You should have received a copy of the GNU General Public License
//along with ICTester; if not, write to the Free Software Foundation,
//Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include <QCoreApplication>
#include <QByteArray>
#include "../devicedriver.h"
#include <QDebug>
#include <QString>
#include <qglobal.h>
#include <cmath>
#include <QStringList>
#include <QFile>

#include "r2716.h"
#include "r74s475.h"
#include "rK565RT5.h"
#include "r74s571.h"
#include "r82s129.h"
#include "r2732.h"
#include "r74s287.h"
#include "r82s131.h"

void help(QStringList typelist)
{

            qDebug()<<"USAGE:\n "<<"icromdump ttySx file.bin TYPE";
            qDebug()<<"  ttySX    - serial port name";
            qDebug()<<"  file.bin - destination file";
            qDebug()<<"SUPPORTED TYPES:";
            QString a;
            for (int i=0;i<typelist.length();i++)
                a=a+" "+typelist[i];
            qDebug()<<qPrintable(a);
            return;
}


int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);


    qDebug()<<"IC ROM/PROM/EPROM dump utility";
    qDebug()<<"v. 0.02       MCbx, 2014";

    //Add supported type here.
    QStringList supportedTypes;
    supportedTypes<<"2716"<<"74s475"<<"K565RT5"<<"74s571"<<"82s129"<<"2732"<<"74s287"<<"82s131";

    if ((argc<=3)||(argc>4))
    {
        help(supportedTypes);
        return 2;
    }

    qDebug()<<"Port: "<<argv[1];
    qDebug()<<"File: "<<argv[2];
    qDebug()<<"Chip: "<<argv[3];
    int dbg=0;

    DeviceDriver tester (argv[1],QSerialPort::Baud19200,1000);
    //test is device OK:
    int k = tester.reset();
    if (k<0)
    {
        qDebug()<<"ERROR: Cannot connect to device!\n";
        help(supportedTypes);
        return 1;
    }
    qDebug()<<"Identify Device:"<<tester.deviceVersion().replace(0x0a,' ').replace(0x0d,' ').trimmed();
    tester.reset();

    bool automate=0;
    if (argv[3][0]=='.')
    {
        automate=1;
        argv[3]++;
    }

    QByteArray result;
    switch(supportedTypes.indexOf(argv[3])) {
    case 0:
        if (!automate) power2716();
        result=read2716(&tester,dbg);
        break;
    case 1:
        if (!automate) power74s475();
        result=read74s475(&tester,dbg);
        break;
    case 2:
        if (!automate) powerK565RT5();
        result=readK565RT5(&tester,dbg);
        break;
    case 3:
        if (!automate) power74s571();
        result=read74s571(&tester,dbg);
        break;
    case 4:
        if (!automate) power82s129();
        result=read82s129(&tester,dbg);
        break;
    case 5:
        if (!automate) power2732();
        result=read2732(&tester,dbg);
        break;
    case 6:
        if (!automate) power74s287();
        result=read74s287(&tester,dbg);
        break;
    case 7:
        if (!automate) power82s131();
        result=read82s131(&tester,dbg);
           break;
//  case 8:
//           break;


    default:
        qDebug()<<"Unknown type.";
        help(supportedTypes);
        return 2;
        break;
    }

    if (result.length()==0)
    {
        qDebug()<<"Nothing to save, result's length is 0!";
        return 3;
    }

    qDebug()<<"Saving...";
    QFile file(argv[2]);
    file.open(QIODevice::WriteOnly);
    file.write(result);
    file.close();
    qDebug()<<"Successfully saved "<<argv[2];


    return 0;
}
