
############################################################################
#
#   $modname: $
#
#   Constructs test.exe - DOS test application for Tempo
#
#   $version$
#      $date$
#     $owner$
#
#
# ---- Copyright (C) 1993 MediaShare Corporation.  All Rights Reserved. ----
#
#$nokeywords$###############################################################
#
#   to build a debug version:
#       NMAKE "DEBUG"
#   to build a non debug version:
#       NMAKE
#
############################################################################

OEM=IOMAGIC
DEF = -D$(OEM)

!ifdef DEBUG
OEM = IOMAGIC  
!MESSAGE Building $(OEM) debugging version
OBJDIR = debug
DEF     = $(DEF) -DDEBUG 
CLOPT   = /Zip /Od /AM
MASMOPT = -Zi
LINKOPT = /CO/LI
!else  
!MESSAGE Building $(OEM) version
CLOPT   =/Zp /O1egilsxb1 /AM
MASMOPT =
LINKOPT = 
OBJDIR = $(OEM)
!endif 

!MESSAGE

!ifdef LISTCODE
CLOPT = $(CLOPT) /Fc
MASMOPT = $(MASMOPT) /Fl
!endif 

NAME = $(OBJDIR)\test


OBJ1    = $(OBJDIR)\io.obj $(OBJDIR)\test.obj $(OBJDIR)\playwave.obj $(OBJDIR)\playfm.obj  
OBJ2    = $(OBJDIR)\csapi.obj $(OBJDIR)\midpak.obj  $(OBJDIR)\recwave.obj $(OBJDIR)\fm.obj
OBJ3    = $(OBJDIR)\loader.obj $(OBJDIR)\doscalls.obj
OBJS = $(OBJ1) $(OBJ2) $(OBJ3)
SBRS    = $(OBJS:.obj=.sbr)
LIBS    = mlibce

CC      = cl /c  /nologo /W3 /G2syf /YX /Fo$@ $(DEF) $(CLOPT)

ASM  = c:\masm611\bin\ml /c /Cx /Sc /Sg /Fo$@ $(DEF) $(MASMOPT) 

LINK    = link /NOD /NOE /MAP:FULL /STACK:2048 /NOPACKF $(LINKOPT)

{.}.c{$(OBJDIR)}.obj:
    $(CC) $< 

{.}.asm{$(OBJDIR)}.obj:
    $(ASM) $<

###################### goal ######################

goal: $(NAME).exe
    @echo ***** finished making $(NAME) *****

##################################################

$(NAME).exe : $(OBJS)
    $(LINK) @<<
    $(OBJ1)+ 
    $(OBJ2)+
    $(OBJ3),
    $(NAME).exe,
    $(NAME).map,
    $(LIBS)
<< 

$(NAME).bsc: $(SBRS) 
    bscmake @<<
/o$(NAME).bsc /n $(SBRS)
<<


##################### clean ######################

clean:
    -del *.exe
    -del *.obj
    -del *.map
    -del *.sym
    -del *.cod
    -del *.sbr
    -del *.bsc 

##################### depend #####################

depend:
    mv makefile makefile.old
    sed "/^# START Dependencies/,/^# END Dependencies/D" makefile.old > makefile
    -del makefile.old
    echo # START Dependencies >> makefile
    includes -l *.c *.asm >> makefile
    echo # END Dependencies >> makefile


# START Dependencies 

$(OBJDIR)\csapi.obj: test.h cs.h

$(OBJDIR)\playfm.obj: test.h midpak.h

$(OBJDIR)\io.obj: test.h

$(OBJDIR)\playwave.obj: test.h

$(OBJDIR)\recwave.obj: test.h

$(OBJDIR)\test.obj: test.h cs.h midpak.h doscalls.h loader.h

$(OBJDIR)\loader.obj: loader.h doscalls.h midpak.h

# END Dependencies

