/****************************************************************************

    playfm.c   Play an Xmidi file

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#include <conio.h>
#include <dos.h>
#include <malloc.h>

#include <memory.h>
#include <string.h> 
#include "test.h"
#include "midpak.h" 

BYTE FAR *lpMidiData;

//--------------------------------------------------------------------------------
BYTE far * loadMidiData (CHAR* pszFilename, size_t *Length)
/*
    Read MIDI data into a big buffer.
*/
    {
    size_t               bytesInSample;
    size_t               totalRead;
    size_t               numRead;
    int                 fh;
    BYTE far *          writeBuffer; 
    BYTE far *          Buffer;

    if ( (fh = _open(pszFilename, O_RDONLY | O_BINARY)) == -1 )
        {
        printf("Could not access [%s]\n", pszFilename);
        exit(0);
        }

    *Length = bytesInSample = (size_t)_filelength(fh);
    _lseek(fh, 0L, SEEK_SET);

    if ( (Buffer = (BYTE  FAR *) _fmalloc(bytesInSample)) == NULL )
        {
        printf("Not enough memory to load [%s]\n", pszFilename);
        exit(0);
        }

    writeBuffer = Buffer;

    for ( totalRead = 0L; totalRead < bytesInSample; totalRead += numRead )
        {
        if (0 == (numRead = _read(fh, diskread, (UINT)DISKREADSIZE)) )
            {
            printf("File read error [%x]\n", totalRead);
            abort();
            }

        _fmemcpy(writeBuffer, diskread, numRead);
        writeBuffer += numRead;
        }

    _close(fh);  
    return (Buffer);
    } 
    
    
// --------------------------------------------------------------------------
BOOL PlayFM(CHAR *pFileName)
    {
    size_t MidiLen;   

    MixPlayFMMax();                        // Setup to play at max volume

    lpMidiData = loadMidiData("test.xmi", &MidiLen);
    CheckBreak();
       
    if (0 == RegisterXmidi(lpMidiData, MidiLen)) 
        {
        printf("\nERROR registering xmidi file \"test.xmi\"\n");
        return FALSE;
        }
 
    printf("Playing MIDI file to FM Synth. Press any key to interrupt...");  
    
    if (1 != PlaySequence(0))  
        {
        printf("\nUnable to play file. Make sure \"test.xmi\" exists.\n");
        return FALSE;
        }
 
    while (!CheckBreak() && ! _kbhit() && (SequenceStatus() != SEQ_DONE))
        {
        // just wait... data pump occurs in ISR
        DELAY
        }
    
    if (_kbhit()) 
        {     
        _getch();    // Eat the character
        printf(" interrupted!\n"); 
        }
    else
        printf(" done!\n");
    MidiStop(); 

    return TRUE;
    } 
 