;; MIDPAK.ASM           January 5, 1992, John W. Ratciff
;;
;; This piece of source provides C procedure call hooks down into
;; the resident TSR sound driver.  Use the call CheckIn to find out
;; if the sound driver is in memory.  See the C header file MIDPAK.H
;; for prototype information.
;;
;; Modified for MASM6.11 by Jon Tara, I/OMagic.
;; Original code was for Borland Turbo Assembler IDEAL mode.
;; Note: the "IFDEF LOADABLE_DRIVERS" code hasn't been converted


    .MODEL  MEDIUM, C
    .286


;; These external procedures are required for the Load and Unload sound
;; driver calls.  The need access to memory allocation functions.
;; The application must provide memory allocation through the functions
;; memfree and memalloc.  The user may redirect these either through DOSCALLS
;; which uses the standard DOS memory allocate, or through their C compiler's
;; memory allocation functions.
    extrn   memfree:far     ; Application controlled memory allocation.
    extrn   memalloc:far   ; Application controlled memory allocation.
    extrn   floadpara:far      ; File load procedure, found in DOSCALLS!

    .CODE

;;  int  PlaySequence(int seqnum)
PlaySequence    PROC    PUBLIC, DATA:WORD
    mov ax,0702h    ; Function #3, DigPlay
    mov bx,[DATA]
    int 66h
    ret
PlaySequence ENDP


;;  int  SegueSequence(int seqnum,int activate)
SegueSequence   PROC    PUBLIC, SEQ:WORD, ACT:WORD
    mov     ax,0703h        
    mov bx,[SEQ]
    mov cx,[ACT]
    int 66h
    ret
SegueSequence   ENDP



;;  int  RegisterXmidi(char far *midi) 
RegisterXmidi   PROC    PUBLIC USES di si, SEQOFF:WORD, SEQSEG:WORD, LENL:WORD, LENH:WORD
    mov ax,0704h    ; Register XMIDI file.
    mov bx,[SEQOFF]
    mov cx,[SEQSEG]
    mov si,[LENL]
    mov di,[LENH]   ; Length of XMIDI data.
    int 66h
    ret
RegisterXmidi   ENDP


;;  int  MidiStop(void)  
MidiStop        PROC    PUBLIC
    mov ax,0705h    ; Stop playing current sequence.
    int 66h
    ret
MidiStop        ENDP

;; long int MidPakClock(void)
MidPakClock     PROC    PUBLIC
    mov ax,712h
    int 66h
    ret
MidPakClock     ENDP

;; long int MidPakClockAddress(void)
MidPakClockAddress  PROC    PUBLIC
    mov ax,712h
    int 66h
    mov ax,bx       ; offset portion of address
    mov dx,cx       ; segment portion of address
    ret 
MidPakClockAddress  ENDP


;;  void RemapChannel(sequence,physical)
RemapChannel    PROC    PUBLIC, sequence:WORD, physical:WORD
    mov ax,0706h    ; Stop playing current sequence.
    mov bx,[sequence]
    mov cx,[physical]
    int 66h
    ret
RemapChannel    ENDP


;;  int  CheckMidiIn(void);   // Is sound driver available?  
CheckMidiIn PROC    PUBLIC
    push    ds      ; Save ds register.
    push    si

    mov si,66h*4h           ; get vector number
    xor     ax,ax           ; zero
    mov     ds,ax           ; point it there
    lds si, ds:[si]         ; get address of interupt vector
    or      si,si           ; zero?
    jz      CIOUT           ; exit if zero
    sub     si,6            ; point back to identifier

    cmp WORD PTR ds:[si],'IM'      ; Midi driver?
    jne CIOUT
    cmp WORD PTR ds:[si]+2,'ID'  ; full midi driver identity string?
    jne CIOUT
    mov ax,1
EXT:
    pop si
    pop ds
    ret
CIOUT: xor    ax,ax       ; Zero return code.
    jmp EXT
CheckMidiIn ENDP


DigPakAvailable PROC    PUBLIC      
    mov ax,701h
    int 66h
    ret
DigPakAvailable ENDP

ReportCallbackTrigger   PROC    PUBLIC
    mov ax,707h
    int 66h
    ret
ReportCallbackTrigger   ENDP


ResetCallbackCounter    PROC    PUBLIC
    mov ax,708h
    int 66h
    ret 
ResetCallbackCounter    ENDP

MidiSleep       PROC    PUBLIC
    mov ax,709h
    int 66h
    ret
MidiSleep       ENDP

MidiAwake       PROC    PUBLIC
    mov ax,70Ah
    int 66h
    ret 
MidiAwake       ENDP

ResumePlaying   PROC    PUBLIC
    mov ax,70Bh
    int 66h
    ret 
ResumePlaying   ENDP

SequenceStatus  PROC    PUBLIC
    mov ax,70Ch
    int 66h
    ret 
SequenceStatus  ENDP


RelativeVolume  PROC    PUBLIC
    mov ax,70Eh
    int 66h
    ret
RelativeVolume  ENDP


SetRelativeVolume   PROC    PUBLIC, VOL:WORD, TIME:WORD
    mov ax,70Fh
    mov bx,[VOL]
    mov cx,[TIME]
    int 66h
    ret
SetRelativeVolume   ENDP

RegisterXmidiFile   PROC    PUBLIC, FNAMEL:WORD, FNAMEH:WORD
    mov ax,70Dh
    mov bx,[FNAMEL]
    mov cx,[FNAMEH]
    int 66h
    ret 
RegisterXmidiFile   ENDP

PollMidPak      PROC    PUBLIC
    mov ax,0711h
    int 66h
    ret
PollMidPak      ENDP

TriggerCountAddress PROC    PUBLIC
    mov ax,713h
    int 66h
    ret 
TriggerCountAddress ENDP

EventIDAddress  PROC    PUBLIC
    mov ax,714h
    int 66h
    ret 
EventIDAddress  ENDP


ReportSequenceNumber    PROC    PUBLIC
    mov ax,716h
    int 66h
    ret
ReportSequenceNumber    ENDP


    .DATA
InstallDriver   LABEL   DWORD
InstOff         dw      0200h   ; Offset of first jump.
InstSeg         dw      ?       ; Segment of audio driver.
DeInstallDriver LABEL   DWORD
DeInstOff       dw      0203h   ; Offset of deinstall jump
DeInstSeg       dw      ?       ; Segment of audio driver.

    .CODE
        
DeInitMP    PROC    PUBLIC, MIDSEG:WORD
    mov     ax,[MIDSEG]
    sub     ax,10h
    mov     [DeInstSeg],ax
    call    [DeInstallDriver]       ; Do indirect call to deinstall the driver.
    ret 
DeInitMP    ENDP


InitMP      PROC    PUBLIC USES es ds si di, MIDSEG:WORD, ADV:WORD, ADL:WORD, ADH:WORD
    mov     ax,[MIDSEG]             ; Save segment loaded at.
    mov     es,ax                   ; Into ES
    sub     ax,10h                  ; Less 10 paragraphs for the org 100h   
    
;; Check Identity string 'MIDPAK' if not located starting 3 bytes into
;; the file loaded, then this is not a compatible digitized sound driver.

    mov     cx,ax
    mov     ax,9999                 ; Not valid driver.
    cmp     BYTE PTR es:[3],'M'     ; M in MIDPAK?
    jne     @F
    cmp     BYTE PTR es:[4],'I'     ; I in MIDPAK?
    jne     @F
    cmp     BYTE PTR es:[5],'D'     ; D in MIDPAK?
    jne     @F
    cmp     BYTE PTR es:[6],'P'     ; P in MIDPAK?
    jne     @F
    cmp     BYTE PTR es:[7],'A'     ; A in MIDPAK?
    jne     @F
    cmp     BYTE PTR es:[8],'K'     ; K in MIDPAK?
    jne     @F
    mov     [InstSeg], cx           ; set jmp segment address.
    call    [InstallDriver]         ; Install the driver.
    or      ax,ax                   ; Installed ok?
    jnz     @F
    mov     bx,[ADV]                ; Segment portion of .ADV file
    xor     cx,cx                   ; offset portion must be ZERO!
    mov     dx,[ADH]                ; Segment portion of .AD file.
    mov     si,[ADL]                ; Offset portion of .AD file.
    mov     ax,710h
    int     66h
@@:
    ret
InitMP  ENDP





    end

