//==============================================================================
//
//  $modname: $
//
//  Description: Caller-friendly API for PCMCIA Card Services Release 2.1
//
//   $version$
//      $date$
//     $owner$
//
//
// ---- Copyright (C) 1993 MediaShare Corporation.  All Rights Reserved. ----  
//
//==============================================================================

#include "test.h"
#include "cs.h"


static CS_RETURN_CODE CardServices(CS_FUNCTION_CODE Function, WORD FAR *Handle, LPVOID lpPointer, 
                                   WORD wArgLength, LPVOID lpArg)
    {
    BYTE            bFunction;                                   
    CS_RETURN_CODE  RC;
    WORD            wHandleIn, wHandleOut; 
    
    bFunction = (BYTE) Function;
    wHandleIn = *Handle;
            
        _asm
            {                
            mov     al, bFunction
            mov     dx, wHandleIn
            mov     di, WORD PTR lpPointer+2
            mov     si, WORD PTR lpPointer
            mov     cx, wArgLength 
            les     bx, lpArg
            mov     ah, 0afh
            int     1ah
            mov     wHandleOut, dx 
            mov     RC, ax  
            }
        *Handle = wHandleOut;
        return RC;
    }
        
//-----------------------------------------------------------------------------------
CS_RETURN_CODE GetCardServicesInfo(WORD wArgLength, LPGETCARDSERVICESARGS lpArg)
    { 
    WORD    wHandle = 0;
    
    return CardServices(CSFUNC_GET_CARD_SERVICES_INFO, &wHandle, 0, 
                        wArgLength, (LPVOID) lpArg); 
    } 
    
//-----------------------------------------------------------------------------------    
CS_RETURN_CODE RegisterClient(CLIENTHANDLE FAR *lpClientHandle, CALLBACK lpCallBack, 
                              LPREGISTERCLIENTARGS lpArg)
    {
    return CardServices(CSFUNC_REGISTER_CLIENT, lpClientHandle, lpCallBack, 
                        sizeof(REGISTERCLIENTARGS), lpArg);    
    }
    
//-----------------------------------------------------------------------------------
CS_RETURN_CODE GetFirstTuple(LPGETFIRSTNEXTTUPLEARGS lpArg)
    {
    WORD    Handle = 0;
    
    return CardServices(CSFUNC_GET_FIRST_TUPLE, &Handle, 0, sizeof(GETFIRSTNEXTTUPLEARGS),
                        lpArg);
    }

//-----------------------------------------------------------------------------------    
CS_RETURN_CODE GetTupleData(LPGETTUPLEDATAARGS lpArg)
    {
    WORD    Handle = 0;
    
    return CardServices(CSFUNC_GET_TUPLE_DATA, &Handle, 0, sizeof(GETTUPLEDATAARGS),
                        lpArg); 
    }

//-----------------------------------------------------------------------------------    
CS_RETURN_CODE RequestIO(CLIENTHANDLE ClientHandle, LPREQUESTIOARGS lpArg)
    {
    return CardServices(CSFUNC_REQUEST_IO, &ClientHandle, 0, sizeof(REQUESTIOARGS), lpArg);    
    }

//-----------------------------------------------------------------------------------    
CS_RETURN_CODE RequestIRQ(CLIENTHANDLE ClientHandle, LPREQUESTIRQARGS lpArg)
    {
    return CardServices(CSFUNC_REQUEST_IRQ, &ClientHandle, 0, sizeof(REQUESTIRQARGS), lpArg);    
    }                                  

//-----------------------------------------------------------------------------------     
CS_RETURN_CODE RequestConfiguration(CLIENTHANDLE ClientHandle, LPREQUESTCONFIGARGS lpArg)
    {
    return CardServices(CSFUNC_REQUEST_CONFIGURATION, &ClientHandle, 0, 
                        sizeof(REQUESTCONFIGARGS), lpArg);    
    }

//-----------------------------------------------------------------------------------    
CS_RETURN_CODE RequestWindow(CLIENTHANDLE ClientHandle, WINDOWHANDLE FAR *lpWindowHandle,
                             LPREQUESTWINDOWARGS lpArg)
    {
    WORD Handle = ClientHandle;
    WORD RC;
    
    RC =CardServices(CSFUNC_REQUEST_WINDOW, &Handle, 0, 
                        sizeof(REQUESTWINDOWARGS), lpArg);
    *lpWindowHandle = Handle;
    return RC;    
    }

//-----------------------------------------------------------------------------------    
CS_RETURN_CODE ReleaseWindow(WINDOWHANDLE WindowHandle)
    {
    return CardServices(CSFUNC_RELEASE_WINDOW, &WindowHandle, 0, 0, 0);
    }
    
//-----------------------------------------------------------------------------------    
CS_RETURN_CODE ReleaseConfiguration(CLIENTHANDLE ClientHandle, WORD wSocket)
    {
    return CardServices(CSFUNC_RELEASE_CONFIGURATION, &ClientHandle, 0, sizeof(WORD), &wSocket);
    }
    
//-----------------------------------------------------------------------------------     
CS_RETURN_CODE ReleaseIO(CLIENTHANDLE ClientHandle, LPREQUESTIOARGS lpArg)
    {
    return CardServices(CSFUNC_RELEASE_IO, &ClientHandle, 0, sizeof(REQUESTIOARGS), lpArg);    
    }
    
//-----------------------------------------------------------------------------------    
CS_RETURN_CODE ReleaseIRQ(CLIENTHANDLE ClientHandle, LPREQUESTIRQARGS lpArg)
    {
    return CardServices(CSFUNC_RELEASE_IRQ, &ClientHandle, 0, 
                        sizeof(REQUESTIRQARGS)-sizeof(BYTE)-sizeof(WORD), lpArg);    
    }
    
//-----------------------------------------------------------------------------------
CS_RETURN_CODE GetFirstClient(CLIENTHANDLE *lpClientHandle, LPGETFIRSTNEXTCLIENTARGS lpArg)
    {
    
    return CardServices(CSFUNC_GET_FIRST_CLIENT, lpClientHandle, 0, 
                        sizeof(GETFIRSTNEXTCLIENTARGS), lpArg);
    }
    
//-----------------------------------------------------------------------------------
CS_RETURN_CODE GetNextClient(CLIENTHANDLE *lpClientHandle, LPGETFIRSTNEXTCLIENTARGS lpArg)
    {
    
    return CardServices(CSFUNC_GET_NEXT_CLIENT, lpClientHandle, 0, 
                        sizeof(GETFIRSTNEXTCLIENTARGS), lpArg);
    }
    
//-----------------------------------------------------------------------------------     
CS_RETURN_CODE GetClientInfo(CLIENTHANDLE ClientHandle, LPGETCLIENTINFO lpArg)
    {
    return CardServices(CSFUNC_GET_CLIENT_INFO, &ClientHandle, 0, sizeof(GETCLIENTINFO), lpArg);    
    }

//-----------------------------------------------------------------------------------
CS_RETURN_CODE ValidateCIS(LPVALIDATECISARGS lpArg)
    {
    return CardServices(CSFUNC_VALIDATE_CIS, 0, 0, sizeof(VALIDATECISARGS), lpArg); 
    }                                      