#include "stdafx.h"
#include "resource.h"
#include "mmsystem.h"
#include "..\..\CommInc\EgoCntrol.h"

#define LED_GREEN   0x2 // BIT1  LED1
#define LED_RED		0x1 // BIT0  LED2

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
extern HINSTANCE _ghInst;
extern void DebugF ( PTSTR pszFormat, ... ); 
extern HMENU hRightPop;

///////////////////////////////////////////////////////////////////////////////////////////
void Set_TogleCheck( HWND hWnd, BOOL check )	{SendMessage( hWnd, BM_SETCHECK, check, 0 );}
void Set_Text( HWND hWnd, char *Text )			{SendMessage( hWnd, WM_SETTEXT, 0, (LPARAM)Text );}
void Set_Pos( HWND hWnd, WORD pos )				{SendMessage( hWnd, SBM_SETPOS, pos, 0 );}
BOOL Get_TogleCheck( HWND hWnd )				{return SendMessage( hWnd, BM_GETCHECK, 0, 0 );}
WORD Get_Pos( HWND hWnd )						{return (WORD)SendMessage( hWnd, SBM_GETPOS, 0, 0 );}

///////////////////////////////////////////////////////////////////////////////////////////
void HW_Init( int _O );
void Display_init( int _O );
void Panel_DisPlay(int id, int _O);

///////////////////////////////////////////////////////////////////////////////////////////
#define KEYNAME "Software\\EGOSYS\\U2A"
#define ROOTKEY HKEY_LOCAL_MACHINE

void DEBUGPRINTF(LPSTR  pszFormat, ...) 
{ 
    char        ach[256]; 
    va_list     va; 
    va_start(va, pszFormat); wvsprintf(ach, pszFormat, va); va_end(va); 
    OutputDebugString(ach);OutputDebugString("\n"); 
} 

#define DF DEBUGPRINTF

DWORD mmGetProfileBinary( LPSTR valuename, LPVOID pDefault, LPVOID pResult,  DWORD cbSize ) 
{ 
    HKEY hkey; 
    DWORD dwType; 
    DWORD cbResult = cbSize; 
 
    if (RegOpenKey(ROOTKEY, KEYNAME, &hkey) == ERROR_SUCCESS) { 
        if (RegQueryValueEx(hkey, valuename, NULL, &dwType, (LPBYTE)pResult,  &cbResult) == ERROR_SUCCESS) 
			{ 
                 if (dwType == REG_BINARY) { 
                    // cbResult is the size 
                    RegCloseKey(hkey); 
                    return(cbResult); 
                } 
        } 
        RegCloseKey(hkey); 
    } 
 
    // if we got here, we didn't find it, or it was the wrong type - return 
    // the default values (use MoveMemory, since src could equal dst) 
    MoveMemory (pResult, pDefault, cbSize); 
    return cbSize; 
} 

///////////////////////////////////////////////////////////////////////////////////////////

VOID mmWriteProfileBinary(LPSTR valuename, LPVOID pData, int cbData) 
{ 
    HKEY hkey; 
 
    if (RegCreateKey(ROOTKEY, KEYNAME, &hkey) == ERROR_SUCCESS) { 
        RegSetValueEx( 
            hkey, valuename, 0, REG_BINARY, 
            (LPBYTE)pData, cbData ); 
 
        RegCloseKey(hkey); 
    } 
} 

///////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class PanChild {

	private :
		int Order;

	public :
		HWND Vols[4];
		HWND VolNum[2];
		HWND Gang;
		HWND Freq[3];
		HWND AutoFreq;
		HWND AnalogMx[3];
		HWND DigitalMx[3];
		HWND Outmix[2];
		HWND Pro[2];
		HWND ClockSrc[2];
		HWND InputSrcA[2];
		HWND InputSrcD[2];

		PanChild(HINSTANCE hInstance, HWND hWnd, int x, int y, int _Order );
		~PanChild();
};
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define ID_Test  (HMENU)0x500

#define ID_Vols			0x600
#define ID_VolNum		0x610
#define ID_Gang			0x620
#define ID_Freq			0x630
#define ID_AutoFreq		0x640
#define ID_AnalogMx		0x650
#define ID_DigitalMx	0x660
#define ID_Outmix		0x670
#define ID_Pro			0x680
#define ID_ClockSrc		0x690
#define ID_InputSrcA	0x6A0
#define ID_InputSrcD	0x6B0

#define _MENU(x)  HMENU(0x1000*_Order+x)

typedef struct
	{
	UINT Vols[4];
	UINT Gang;
	UINT Freq;
	UINT AutoFreq;
	UINT AnalogMx[3];
	UINT DigitalMx[3];
	UINT Outmix;
	UINT Pro;
	UINT ClockSrc;
	UINT InputSrcA;
	UINT InputSrcD;
	} MIXER;

MIXER DefMx = 
{
	{0x7F,0x7F,0x7F,0x7F},//Vols[4];
	1,//Gang;
	1,//Freq;
	1,//AutoFreq;
	0,0,1,//AnalogMx;
	0,0,1,//DigitalMx;
	0,//Outmix;
	0,//Pro;
	0,//ClockSrc;
	0,//InputSrcA;
	0//InputSrcD;
};

HWND		gWnd;
MIXER		mx[4]; 
PanChild	*Panel[4];

PanChild::PanChild(HINSTANCE hInstance, HWND hWnd, int x, int y, int _Order )
{
	Order = _Order;
	if (hWnd)
	{	

	VolNum[0]   = Ego_Create_SmallText( _ghInst, hWnd, _MENU(ID_VolNum+0), 130+x, 134+y, 32, 14, RGB( 255, 255,0), RGB(0,0,0), "-95.5" );
	VolNum[1]   = Ego_Create_SmallText( _ghInst, hWnd, _MENU(ID_VolNum+1), 180+x, 134+y, 32, 14, RGB( 255, 255,0), RGB(0,0,0), "-95.5" );

	Vols[0]		= Ego_Create_VS( _ghInst, hWnd, _MENU(ID_Vols+0), 125+x, 29+y, 0,0xAF, "panbar1", "panbutton_off", "panbutton_on", 0 );
	Vols[1]		= Ego_Create_VS( _ghInst, hWnd, _MENU(ID_Vols+1), 146+x, 29+y, 0,0xAF, "panbar2", "panbutton_off", "panbutton_on", 0 );
	Vols[2]		= Ego_Create_VS( _ghInst, hWnd, _MENU(ID_Vols+2), 173+x, 29+y, 0,0x7F, "panbar3", "panbutton_off", "panbutton_on", 0 );
	Vols[3]		= Ego_Create_VS( _ghInst, hWnd, _MENU(ID_Vols+3), 194+x, 29+y, 0,0x7F, "panbar4", "panbutton_off", "panbutton_on", 0 );

	Gang		= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Gang+0), 156+x, 165+y, "gangbutton_on", "gangbutton_off" );

	AutoFreq	= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_AutoFreq), 114+x, 195+y, "auto_on", "auto_off" );
	Freq[0]		= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Freq+0), 165+x, 195+y, "32_on", "32_off" );
	Freq[1]		= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Freq+1), 186+x, 195+y, "441_on", "441_off" );
	Freq[2]		= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Freq+2), 207+x, 195+y, "48_on", "48_off" );

		
	AnalogMx[0]	= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_AnalogMx+0), 240+x, 34+y, "analogin_on", "analogin_off" );
	AnalogMx[1]	= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_AnalogMx+1), 240+x, 47+y, "digitalin_on", "digitalin_off" );
	AnalogMx[2]	= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_AnalogMx+2), 240+x, 60+y, "usbout_on", "usbout_off" );
	DigitalMx[0]= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_DigitalMx+0), 240+x,  91+y, "analogin_on", "analogin_off" );
	DigitalMx[1]= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_DigitalMx+1), 240+x, 104+y, "digitalin_on", "digitalin_off" );
	DigitalMx[2]= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_DigitalMx+2), 240+x, 117+y, "usbout_on", "usbout_off" );

	Outmix[0]	= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Outmix+0), 240+x, 146+y, "dynamic_on", "dynamic_off" );
	Outmix[1]	= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Outmix+1), 240+x, 159+y, "soft_on", "soft_off" );

	Pro[0]		= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Pro+0),  240+x, 206+y, "consumer_on", "consumer_off" );
	Pro[1]		= Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_Pro+1),  240+x, 219+y, "pro_on", "pro_off" );

	InputSrcA[0]= Ego_Create_Togle ( _ghInst, hWnd, _MENU(ID_InputSrcA+0), 22+x,  105+y, "l_analogin_on", "l_analogin_off" );
	InputSrcA[1]= Ego_Create_Togle ( _ghInst, hWnd, _MENU(ID_InputSrcA+1), 22+x,  118+y, "l_digitalin_on", "l_digitalin_off" );

	InputSrcD[0]= Ego_Create_Togle ( _ghInst, hWnd, _MENU(ID_InputSrcD+0), 22+x, 146+y, "coaxial_on", "coaxial_off");
	InputSrcD[1]= Ego_Create_Togle ( _ghInst, hWnd, _MENU(ID_InputSrcD+1), 22+x, 159+y, "optical_on", "optical_off");

	ClockSrc[0] = Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_ClockSrc+0),  22+x, 205+y, "internal_on", "internal_off" );
	ClockSrc[1] = Ego_Create_Togle( _ghInst, hWnd, _MENU(ID_ClockSrc+1),  22+x, 218+y, "l_digitalin_2_on", "l_digitalin_2_off" );

	}
}

void Panel_Init(HINSTANCE hInstance, HWND hWnd, int x, int y, int _O )
{
	gWnd=hWnd;
	Panel[_O] = new PanChild( hInstance, hWnd, x, y, _O );
	Display_init( _O );
	HW_Init( _O );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
HMIXER gh_mixer;
UINT g_VolID;  
UINT g_MuteID;  
UINT g_DevID;  

BOOL FatalError( void )
{
	SetWindowText( gWnd, "USB is not working. Please re-connect usb" );
	gh_mixer=0;
	return FALSE;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL Mixer_GetID_U2A( HMIXEROBJ hMixer, UINT cDestinations )
{
	UINT Cnt = 0;

	for (UINT j = 0; j < cDestinations; j++)
	{
		MIXERLINE	mxl;
		mxl.cbStruct      = sizeof(mxl);
		mxl.dwDestination = j;

		MMRESULT ret = mixerGetLineInfo(hMixer, &mxl, MIXER_GETLINEINFOF_DESTINATION );
		
		if ( (ret == MMSYSERR_NOERROR) &&
			 (MIXERLINE_COMPONENTTYPE_DST_WAVEIN == mxl.dwComponentType ) )
		{
			UINT uiNumSrcLines = (UINT)mxl.cConnections;

			for (UINT k = 0; k < uiNumSrcLines; k++)
			{
				ret = mixerGetLineInfo(hMixer, &mxl, MIXER_GETLINEINFOF_LINEID);

				if (ret == MMSYSERR_NOERROR)
				{
					PMIXERCONTROL pControls;
					MIXERLINECONTROLS ControlList;

					pControls = (PMIXERCONTROL)LocalAlloc(LPTR, sizeof(*pControls) * mxl.cControls );

					ControlList.cbStruct = sizeof(MIXERLINECONTROLS);
					ControlList.dwLineID = mxl.dwLineID;
					ControlList.cControls = mxl.cControls;
					ControlList.cbmxctrl = sizeof(*pControls);
					ControlList.pamxctrl = pControls;

					ret = mixerGetLineControls(hMixer, &ControlList, MIXER_GETLINECONTROLSF_ALL);

					if (ret == MMSYSERR_NOERROR)
					{
						for(UINT i=0; i<mxl.cControls; i++)
						{
							if( pControls[i].dwControlType == MIXERCONTROL_CONTROLTYPE_VOLUME)
							{
								Cnt++;
								DF(" Control Vol : %s : %d (%X-%X)", pControls[i].szName, pControls[i].dwControlID, pControls[i].dwControlType, pControls[i].fdwControl );
								g_VolID = pControls[i].dwControlID;
							}
							else
							if( pControls[i].dwControlType == MIXERCONTROL_CONTROLTYPE_MUTE)
							{
								Cnt++;
								DF(" Control Vol : %s : %d (%X-%X)", pControls[i].szName, pControls[i].dwControlID, pControls[i].dwControlType, pControls[i].fdwControl );
								g_MuteID = pControls[i].dwControlID;
							}
						}
					}

					LocalFree((HLOCAL)pControls);
				}
			}
		}
	}

	if( Cnt ) 
		return true;
	else
		return FatalError();
}

BOOL Mixer_Open( HWND hWnd )
{
    MIXERCAPS           mxcaps;

	CHAR buf[32];
	wsprintf( buf, "Mixer%d", 0 );
	mmGetProfileBinary(buf , &DefMx, &mx, sizeof(MIXER));
	
	AppendMenu( hRightPop, MF_SEPARATOR, NULL, NULL );

	gWnd=hWnd;
	g_DevID = (UINT)-1;

	UINT n=mixerGetNumDevs();

	for(UINT i=0; i<n; i++)
	{
		mixerGetDevCaps( i, &mxcaps, sizeof(MIXERCAPS) );
		
		AppendMenu( hRightPop, MF_STRING, 2000+i, mxcaps.szPname );

		if( strstr( mxcaps.szPname, "USB" ) || // WIn98 Se Me 2k
			strstr( mxcaps.szPname, "U2A" ) ||
			strstr( mxcaps.szPname, "U24" ) 
			)  // XP
		
		g_DevID = i;
	}


	if( g_DevID != (UINT)-1 )
	{
		return TRUE;
	}

	return FatalError();
}

BOOL Mixer_CreateInstance( HWND hWnd )
{
    MMRESULT            mmr;
    MIXERCAPS           mxcaps;

	if( g_DevID != (UINT)-1 )
	{
		if( gh_mixer )
			mixerClose(gh_mixer);

		mixerGetDevCaps( g_DevID, &mxcaps, sizeof(MIXERCAPS) );

	    mmr = mixerOpen( &gh_mixer, g_DevID, (DWORD)(UINT)hWnd, 0L, CALLBACK_WINDOW );
		if (MMSYSERR_NOERROR == mmr)
		{
			Mixer_GetID_U2A ((HMIXEROBJ)gh_mixer, mxcaps.cDestinations);
			CheckMenuItem( hRightPop, g_DevID+2000, MF_CHECKED );
			return TRUE;
		}
	}

	return FatalError();
}

void Mixer_Close( void )
{
	CHAR buf[32];
	wsprintf( buf, "Mixer%d", 0 );
	mmWriteProfileBinary(buf, &mx, sizeof(MIXER));
	
	void HW_FPGA_Out( int reg, int mask, int data );
	HW_FPGA_Out( 1, LED_GREEN, 0x00 ); // LED2

	mixerClose(gh_mixer);
	gh_mixer=0;
}

BOOL Mixer_Set_Volume( UINT id, UINT Left, UINT Right )
{
	MMRESULT						mmr;
    MIXERCONTROLDETAILS             mxcd;
    MIXERCONTROLDETAILS_UNSIGNED    mxcd_u[4];
	
	if( gh_mixer==0 ) 
		return FALSE;

    mxcd.cbStruct       = sizeof(mxcd);
    mxcd.dwControlID    = id;
    mxcd.cChannels      = 2;
    mxcd.cMultipleItems = 0;
    mxcd.cbDetails      = sizeof(mxcd_u);
    mxcd.paDetails      = &mxcd_u;

    mmr = mixerGetControlDetails( (HMIXEROBJ)gh_mixer, &mxcd, 0L);

    mxcd_u[0].dwValue  = Left;
    mxcd_u[1].dwValue  = Right;

    mmr = mixerSetControlDetails( (HMIXEROBJ)gh_mixer, &mxcd, 0L);
	if( mmr != MMSYSERR_NOERROR )
		return FatalError();
	else
		return TRUE;
}

BOOL Mixer_Set_Mute( UINT id, UINT OnOff )
{
	MMRESULT						mmr;
    MIXERCONTROLDETAILS             mxcd;
    MIXERCONTROLDETAILS_BOOLEAN     mxcd_f;
	
	if( gh_mixer==0 ) 
		return FALSE;

    mxcd.cbStruct       = sizeof(mxcd);
    mxcd.dwControlID    = id;
    mxcd.cChannels      = 1;
    mxcd.cMultipleItems = 0;
    mxcd.cbDetails      = sizeof(mxcd_f);
    mxcd.paDetails      = &mxcd_f;

    //mmr = mixerGetControlDetails( (HMIXEROBJ)gh_mixer, &mxcd, 0L);

    mxcd_f.fValue = OnOff;

    mmr = mixerSetControlDetails( (HMIXEROBJ)gh_mixer, &mxcd, 0L);

	if( mmr != MMSYSERR_NOERROR )
		return FatalError();
	else
		return TRUE;
}

void SystemMixerInit(void)
{
	Mixer_Set_Volume( g_VolID, 0xFFFF, 0xFFFF ); // input
	//Mixer_Set_Volume( 2, 0xFFFF, 0xFFFF ); // wave
	//Mixer_Set_Volume( 4, 0xFFFF, 0xFFFF ); // synth
	Mixer_Set_Mute( g_MuteID, 0 ); // input
	//Mixer_Set_Mute( 3, 0 ); // wave
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*
	*** U2A Control Volume Data

	00 : 00000(0000) - 10453(0000) : 00000
	01 : 10469(0000) - 10533(0000) : 10500
	02 : 10549(0000) - 10613(0000) : 10580
	03 : 10629(0000) - 10693(0000) : 10660
	04 : 10709(0000) - 10757(0000) : 10730
	05 : 10773(0000) - 10837(0000) : 10800
	06 : 10853(0000) - 10917(0000) : 10880
	07 : 10933(0000) - 10997(0000) : 10960
	08 : 11013(0000) - 11077(0000) : 11040
	09 : 11093(0000) - 11157(0000) : 11130
	0A : 11173(0000) - 11237(0000) : 11200
	0B : 11253(0000) - 11317(0000) : 11280
	0C : 11333(0000) - 11397(0000) : 11360
	0D : 11413(0000) - 11477(0000) : 11440
	0E : 11493(0000) - 11573(0000) : 11530
	0F : 11589(0000) - 11654(0000) : 11620

	10 : 11670(0000) - 11734(0000) : 11700
	11 : 11750(0000) - 11814(0000) : 11780
	12 : 11830(0000) - 11910(0000) : 11870
	13 : 11926(0000) - 11990(0000) : 11960
	14 : 12006(0000) - 12070(0000) : 12040
	15 : 12086(0000) - 12166(0000) : 12120
	16 : 12182(0000) - 12246(0000) : 12210
	17 : 12262(0000) - 12342(0000) : 12300
	18 : 12358(0000) - 12438(0000) : 12400
	19 : 12454(0000) - 12518(0000) : 12480
	1A : 12534(0000) - 12614(0000) : 12570
	1B : 12630(0000) - 12710(0000) : 12680
	1C : 12726(0000) - 12790(0000) : 12760
	1D : 12806(0000) - 12886(0000) : 12840
	1E : 12902(0000) - 12982(0000) : 12940
	1F : 12998(0000) - 13078(0000) : 13040

	20 : 13094(0000) - 13174(0000) : 13130
	21 : 13190(0000) - 13270(0000) : 13230
	22 : 13286(0000) - 13366(0000) : 13330
	23 : 13382(0000) - 13462(0000) : 13430
	24 : 13478(0000) - 13558(0000) : 13530
	25 : 13574(0000) - 13654(0000) : 13620
	26 : 13670(0000) - 13751(0000) : 13720
	27 : 13767(0000) - 13847(0000) : 13810
	28 : 13863(0000) - 13943(0000) : 13900
	29 : 13959(0000) - 14055(0000) : 14010
	2A : 14071(0000) - 14151(0000) : 14110
	2B : 14167(0000) - 14247(0000) : 14200
	2C : 14263(0000) - 14359(0000) : 14300
	2D : 14375(0000) - 14455(0000) : 14400
	2E : 14471(0000) - 14567(0000) : 14520
	2F : 14583(0000) - 14663(0000) : 14620

	30 : 14679(0000) - 14775(0000) : 14720
	31 : 14791(0000) - 14887(0000) : 14830
	32 : 14903(0000) - 14983(0000) : 14940
	33 : 14999(0000) - 15095(0000) : 15050
	34 : 15111(0000) - 15207(0000) : 15150
	35 : 15223(0000) - 15319(0000) : 15270
	36 : 15335(0000) - 15431(0000) : 15380
	37 : 15447(0000) - 15543(0000) : 15490
	38 : 15559(0000) - 15655(0000) : 15600
	39 : 15671(0000) - 15767(0000) : 15720
	3A : 15783(0000) - 15880(0000) : 15830
	3B : 15896(0000) - 15992(0000) : 15940
	3C : 16008(0000) - 16104(0000) : 16050
	3D : 16120(0000) - 16232(0000) : 16180
	3E : 16248(0000) - 16344(0000) : 16300
	3F : 16360(0000) - 16456(0000) : 16400

	40 : 16472(0000) - 16584(0000) : 16520
	41 : 16600(0000) - 16696(0000) : 16650
	42 : 16712(0000) - 16824(0000) : 16770
	43 : 16840(0000) - 16936(0000) : 16890
	44 : 16952(0000) - 17064(0000) : 17000
	45 : 17080(0000) - 17192(0000) : 17120
	46 : 17208(0000) - 17304(0000) : 17250
	47 : 17320(0000) - 17432(0000) : 17380
	48 : 17448(0000) - 17560(0000) : 17500
	49 : 17576(0000) - 17688(0000) : 17620
	4A : 17704(0000) - 17816(0000) : 17760
	4B : 17832(0000) - 17944(0000) : 17890
	4C : 17960(0000) - 18073(0000) : 18010
	4D : 18089(0000) - 18201(0000) : 18150
	4E : 18217(0000) - 18345(0000) : 18280
	4F : 18361(0000) - 18473(0000) : 18410

	50 : 18489(0000) - 18601(0000) : 18540
	51 : 18617(0000) - 18745(0000) : 18680
	52 : 18761(0000) - 18873(0000) : 18820
	53 : 18889(0000) - 19017(0000) : 18950
	54 : 19033(0000) - 19145(0000) : 19090
	55 : 19161(0000) - 19289(0000) : 19220
	56 : 19305(0000) - 19417(0000) : 19360
	57 : 19433(0000) - 19561(0000) : 19500
	58 : 19577(0000) - 19705(0000) : 19620
	59 : 19721(0000) - 19849(0000) : 19780
	5A : 19865(0000) - 19993(0000) : 19930
	5B : 20009(0000) - 20138(0000) : 20080
	5C : 20154(0000) - 20282(0000) : 20210
	5D : 20298(0000) - 20426(0000) : 20360
	5E : 20442(0000) - 20570(0000) : 20500
	5F : 20586(0000) - 20730(0000) : 20660

	60 : 20746(0000) - 20874(0000) : 20800
	61 : 20890(0000) - 21018(0000) : 20950
	62 : 21034(0000) - 21178(0000) : 21100
	63 : 21194(0000) - 21338(0000) : 21260
	64 : 21354(0000) - 21482(0000) : 21420
	65 : 21498(0000) - 21642(0000) : 21570
	66 : 21658(0000) - 21802(0000) : 21730
	67 : 21818(0000) - 21946(0000) : 21880
	68 : 21962(0000) - 22106(0000) : 22030
	69 : 22122(0000) - 22267(0000) : 22200
	6A : 22283(0000) - 22427(0000) : 22350
	6B : 22443(0000) - 22587(0000) : 22500
	6C : 22603(0000) - 22763(0000) : 22680
	6D : 22779(0000) - 22923(0000) : 22850
	6E : 22939(0000) - 23083(0000) : 23000
	6F : 23099(0000) - 23259(0000) : 23180

	70 : 23275(0000) - 23419(0000) : 23350
	71 : 23435(0000) - 23595(0000) : 23520
	72 : 23611(0000) - 23755(0000) : 23680
	73 : 23771(0000) - 23931(0000) : 23850
	74 : 23947(0000) - 24107(0000) : 24020
	75 : 24123(0000) - 24283(0000) : 24200
	76 : 24299(0000) - 24460(0000) : 24380
	77 : 24476(0000) - 24636(0000) : 24550
	78 : 24652(0000) - 24812(0000) : 24730
	79 : 24828(0000) - 24988(0000) : 24900
	7A : 25004(0000) - 25164(0000) : 25080
	7B : 25180(0000) - 25356(0000) : 25260
	7C : 25372(0000) - 25532(0000) : 25450
	7D : 25548(0000) - 25724(0000) : 25630
	7E : 25740(0000) - 25900(0000) : 25820
	7F : 25916(0000) - 26092(0000) : 26000

	80 : 26108(0000) - 26284(0000) : 26200
	81 : 26300(0000) - 26477(0000) : 26380
	82 : 26493(0000) - 26669(0000) : 26580
	83 : 26685(0000) - 26861(0000) : 26780
	84 : 26877(0000) - 27053(0000) : 26950
	85 : 27069(0000) - 27245(0000) : 27150
	86 : 27261(0000) - 27437(0000) : 27350
	87 : 27453(0000) - 27645(0000) : 27550
	88 : 27661(0000) - 27837(0000) : 27750
	89 : 27853(0000) - 28045(0000) : 27950
	8A : 28061(0000) - 28237(0000) : 28150
	8B : 28253(0000) - 28445(0000) : 28350
	8C : 28461(0000) - 28654(0000) : 28550
	8D : 28670(0000) - 28862(0000) : 28750
	8E : 28878(0000) - 29070(0000) : 28950
	8F : 29086(0000) - 29278(0000) : 29150

	90 : 29294(0000) - 29486(0000) : 29400
	91 : 29502(0000) - 29710(0000) : 29600
	92 : 29726(0000) - 29918(0000) : 29800
	93 : 29934(0000) - 30126(0000) : 30000
	94 : 30142(0000) - 30350(0000) : 30250
	95 : 30366(0000) - 30574(0000) : 30450
	96 : 30590(0000) - 30799(0000) : 30650
	97 : 30815(0000) - 31007(0000) : 30900
	98 : 31023(0000) - 31231(0000) : 31100
	99 : 31247(0000) - 31471(0000) : 31350
	9A : 31487(0000) - 31695(0000) : 31600
	9B : 31711(0000) - 31919(0000) : 31800
	9C : 31935(0000) - 32143(0000) : 32050
	9D : 32159(0000) - 32383(0000) : 32250
	9E : 32399(0000) - 32623(0000) : 32450
	9F : 32639(0000) - 32848(0000) : 32650

	A0 : 32864(0000) - 33088(0000) : 32950
	A1 : 33104(0000) - 33328(0000) : 33250
	A2 : 33344(0000) - 33568(0000) : 33450
	A3 : 33584(0000) - 33808(0000) : 33700
	A4 : 33824(0000) - 34048(0000) : 33950
	A5 : 34064(0000) - 34304(0000) : 34180
	A6 : 34320(0000) - 34544(0000) : 34420
	A7 : 34560(0000) - 34800(0000) : 34680
	A8 : 34816(0000) - 35057(0000) : 34900
	A9 : 35073(0000) - 35297(0000) : 35200
	AA : 35313(0000) - 35553(0000) : 35440
	AB : 35569(0000) - 35809(0000) : 35700
	AC : 35825(0000) - 36081(0000) : 35950
	AD : 36097(0000) - 36337(0000) : 36200
	AE : 36353(0000) - 36593(0000) : 36450
	AF : 36609(0000) - 36865(0000) : 36750

	B0 : 36881(0000) - 37122(0000) : 37000
	B1 : 37138(0000) - 37394(0000) : 37250
	B2 : 37410(0000) - 37666(0000) : 37530
	B3 : 37682(0000) - 37938(0000) : 37800
	B4 : 37954(0000) - 38210(0000) : 38070
	B5 : 38226(0000) - 38482(0000) : 38340
	B6 : 38498(0000) - 38770(0000) : 38630
	B7 : 38786(0000) - 39042(0000) : 38900
	B8 : 39058(0000) - 39331(0000) : 39180
	B9 : 39347(0000) - 39619(0000) : 39470
	BA : 39635(0000) - 39891(0000) : 39750
	BB : 39907(0000) - 40179(0000) : 40020
	BC : 40195(0000) - 40483(0000) : 40320
	BD : 40499(0000) - 40771(0000) : 40620
	BE : 40787(0000) - 41059(0000) : 40930
	BF : 41075(0000) - 41364(0000) : 41120

	C0 : 41380(0000) - 41652(0000) : 41520
	C1 : 41668(0000) - 41956(0000) : 41800
	C2 : 41972(0000) - 42260(0000) : 42120
	C3 : 42276(0000) - 42564(0000) : 42420
	C4 : 42580(0000) - 42868(0000) : 42720
	C5 : 42884(0000) - 43188(0000) : 43020
	C6 : 43204(0000) - 43493(0000) : 43330
	C7 : 43509(0000) - 43813(0000) : 43640
	C8 : 43829(0000) - 44133(0000) : 43950
	C9 : 44149(0000) - 44453(0000) : 44300
	CA : 44469(0000) - 44773(0000) : 44600
	CB : 44789(0000) - 45093(0000) : 44900
	CC : 45109(0000) - 45413(0000) : 45250
	CD : 45429(0000) - 45750(0000) : 45550
	CE : 45766(0000) - 46070(0000) : 45900
	CF : 46086(0000) - 46406(0000) : 46250

	D0 : 46422(0000) - 46742(0000) : 46580
	D1 : 46758(0000) - 47078(0000) : 46900
	D2 : 47094(0000) - 47414(0000) : 47250
	D3 : 47430(0000) - 47767(0000) : 47600
	D4 : 47783(0000) - 48103(0000) : 47900
	D5 : 48119(0000) - 48455(0000) : 48300
	D6 : 48471(0000) - 48807(0000) : 48650
	D7 : 48823(0000) - 49159(0000) : 49000
	D8 : 49175(0000) - 49511(0000) : 49350
	D9 : 49527(0000) - 49864(0000) : 49700
	DA : 49880(0000) - 50232(0000) : 50100
	DB : 50248(0000) - 50600(0000) : 50450
	DC : 50616(0000) - 50952(0000) : 50800
	DD : 50968(0000) - 51320(0000) : 51150
	DE : 51336(0000) - 51704(0000) : 51500
	DF : 51720(0000) - 52073(0000) : 51850

	E0 : 52089(0000) - 52441(0000) : 52250
	E1 : 52457(0000) - 52825(0000) : 52600
	E2 : 52841(0000) - 53209(0000) : 53000
	E3 : 53225(0000) - 53593(0000) : 53400
	E4 : 53609(0000) - 53978(0000) : 53800
	E5 : 53994(0000) - 54362(0000) : 54150
	E6 : 54378(0000) - 54762(0000) : 54550
	E7 : 54778(0000) - 55162(0000) : 54950
	E8 : 55178(0000) - 55562(0000) : 55350
	E9 : 55578(0000) - 55962(0000) : 55750
	EA : 55978(0000) - 56363(0000) : 56150
	EB : 56379(0000) - 56763(0000) : 56550
	EC : 56779(0000) - 57179(0000) : 57000
	ED : 57195(0000) - 57595(0000) : 57400
	EE : 57611(0000) - 58011(0000) : 57800
	EF : 58027(0000) - 58428(0000) : 58200

	F0 : 58444(0000) - 58844(0000) : 58650
	F1 : 58860(0000) - 59276(0000) : 59050
	F2 : 59292(0000) - 59708(0000) : 59500
	F3 : 59724(0000) - 60140(0000) : 59050
	F4 : 60156(0000) - 60573(0000) : 60350
	F5 : 60589(0000) - 61005(0000) : 60800
	F6 : 61021(0000) - 61437(0000) : 61250
	F7 : 61453(0000) - 61885(0000) : 61700
	F8 : 61901(0000) - 62333(0000) : 62150
	F9 : 62349(0000) - 62782(0000) : 62600
	FA : 62798(0000) - 63246(0000) : 63050
	FB : 63262(0000) - 63694(0000) : 63500
	FC : 63710(0000) - 64158(0000) : 63900
	FD : 64174(0000) - 64623(0000) : 64350
	FE : 64639(0000) - 65087(0000) : 64850
	FF : 65103(0000) - 65535(0000) : 65535


	*** Data Format & Control Data ***

	1 - Left Volume Data(Command) : Mute & Right Volume Data = 0xffff
	    0x00 : All Chip Disable
	    0x01 : CS8420 Chip Select
	    0x02 : AKM Chip Select
	    0x03 : FPGA Control Data Chip Select
	    0x04 : FPGA Reset

	    0x08 : Fs = 32KHz
	    0x09 : Fs = 44.1KHz
	    0x0A : Fs = 48KHz

	    0x0B : CS8420 = Consumer Mode 
	    0x0C : CS8420 = Professional Mode

	    0x0D : Fs = Auto (x)
	    0x0E : Fs = Auto (o)

	2 - Right Volume Data(Data) : Mute & Left Volume Data = 0xffff
	   *** AKM Register Setting Value ***
		*** Initialize ***
		ADD(H)	Data(H)
		A0	07
		A1	03
		A2	60	---> 64KHz,88.2KHz,96Khz :65
		A3	19
		A4	7F
		A5	7F
		A6	7F
		A7	7F

	   *** CS8420 Register Setting Value ***
		spi_sdo(0x20);
		spi_sdo(add);
		spi_sdo(dat);

		*** Initialize ***
		ADD(D)	Data(H)
		04	00
		04	40
		01	00
		02	00

		*** Wait about 100ms ***
		ADD(D)	Data(H)
		03	0d
		04	41
		05	05
		06	05

		*** Sample Rate Converter ***
		ADD(D)	Data(H)
		03	0d	- Off
		03	09	- On

		*** Consumer Mode ***
		ADD(D)	Data(H)
		18	1c
		19	03

		32	20
		33	00
		34	00
		35	xxxx0000b
			0000 - 44.1kHz
			0100 - 48kHz
			1100 - 32kHz

		36	00
		~	00
		55	00


		*** Professional Mode ***
		ADD(D)	Data(H)
		18	1c
		19	03

		32	100000xxb
			      00 - other Sample Rate
			      01 - 48kHz
			      10 - 44.1kHz
			      11 - 32kHz

		33	40
		34	34
		35	00

		36	00
		~	00
		53	00

		54	07
		55	00



  ** FPGA **

REG0(RW) D7 D6 D5 D4 D3 D2 D1 D0 (Default  0100 1000)
         |  |  |  |  |  |  |  |       
         |  |  |  |  |  |  |  +- Monitor Analog IN       0:OFF, 1:ON
         |  |  |  |  |  |  +---- Monitor Digital IN      0:OFF, 1:ON              Digital Out
         |  |  |  |  |  +------- Wave Out                0:OFF, 1:ON
         |  |  |  |  +---------- SFTD1                   0:1ch(1/1), 1:2ch(1/2)
         |  |  |  |                                 --------------------------
         |  |  |  +------------- Monitor Analog IN       0:OFF, 1:ON  
         |  |  +---------------- Monitor Digital IN      0:OFF, 1:ON              Analog Out
         |  +------------------- Wave Out                0:OFF, 1:ON
         +---------------------- SFTA1                   0:1ch(1/1), 1:2ch(1/2)

REG1(RW) D7 D6 D5 D4 D3 D2 D1 D0 (Default  0000 0000)
         |  |  |  |  |  |  |  |       
         |  |  |  |  |  |  |  +- LED2                    0:OFF, 1:ON
         |  |  |  |  |  |  +---- LED1                    0:OFF, 1:ON
         |  |  |  |  |  +------- DIN_SEL2				 0:Optical 1:Opticla disable
         |  |  |  |  +---------- DIN_SEL1				 0:Coaxial 1:Coaxial disable
         |  |  |  +------------- SELECT Input            0:Analog IN, 1:Digital IN
         |  |  +---------------- Disable (SELECT Input)  0:Enable,    1:Disable
         |  +------------------- 
         +---------------------- SELECT Clock            0:Internal,  1:Digital IN
*/

UINT VolMap[] = {
		0,10500,10580,10660,10730,10800,10880,10960,11040,11130,11200,11280,11360,11440,11530,11620,
	11700,11780,11870,11960,12040,12120,12210,12300,12400,12480,12570,12680,12760,12840,12940,13040,
	13130,13230,13330,13430,13530,13620,13720,13810,13900,14010,14110,14200,14300,14400,14520,14620,
	14720,14830,14940,15050,15150,15270,15380,15490,15600,15720,15830,15940,16050,16180,16300,16400,
	16520,16650,16770,16890,17000,17120,17250,17380,17500,17620,17760,17890,18010,18150,18280,18410,
	18540,18680,18820,18950,19090,19220,19360,19500,19620,19780,19930,20080,20210,20360,20500,20660,
	20800,20950,21100,21260,21420,21570,21730,21880,22030,22200,22350,22500,22680,22850,23000,23180,
	23350,23520,23680,23850,24020,24200,24380,24550,24730,24900,25080,25260,25450,25630,25820,26000,
	26200,26380,26580,26780,26950,27150,27350,27550,27750,27950,28150,28350,28550,28750,28950,29150,
	29400,29600,29800,30000,30250,30450,30650,30900,31100,31350,31600,31800,32050,32250,32450,32650,
	32950,33250,33450,33700,33950,34180,34420,34680,34900,35200,35440,35700,35950,36200,36450,36750,
	37000,37250,37530,37800,38070,38340,38630,38900,39180,39470,39750,40020,40320,40620,40930,41120,
	41520,41800,42120,42420,42720,43020,43330,43640,43950,44300,44600,44900,45250,45550,45900,46250,
	46580,46900,47250,47600,47900,48300,48650,49000,49350,49700,50100,50450,50800,51150,51500,51850,
	52250,52600,53000,53400,53800,54150,54550,54950,55350,55750,56150,56550,57000,57400,57800,58200,
	58650,59050,59500,59050,60350,60800,61250,61700,62150,62600,63050,63500,63900,64350,64850,65535
};

#define All_Chip_Disable				0x00 
#define CS8420_Chip_Select				0x01 
#define AKM_Chip_Select					0x02 
#define FPGA_Control_Data_Chip_Select	0x03 
#define FPGA_Reset						0x04 
#define Fs_32KHz						0x08 
#define Fs_441KHz						0x09 
#define Fs_48KHz						0x0A 
#define CS8420_Consumer_Mode			0x0B
#define CS8420_Professional_Mode		0x0C
#define Fs_Auto_off						0x0D 
#define Fs_Auto_on						0x0E 

#define BIT0	0x01
#define BIT1	0x02
#define BIT2	0x04
#define BIT3	0x08
#define BIT4	0x10
#define BIT5	0x20
#define BIT6	0x40
#define BIT7	0x80

#include <stdio.h>
#include <math.h>

char *Get_AkmDB( WORD v )
{
	static char buf[32];
	double mod=0;
	double ret=0;
	int m = (v>>4)&0xF;
	int l = v&0xF;

	if( v>127 )
	{
		ret = (v-128)*0.5;
		if( ret > 18.0 ) ret=18.0;
		sprintf( buf, "%.1f", ret );
	}
	else if( v==127 )
	{
		sprintf( buf, "0.0" );
	}
	else if( v==0 )
	{
		sprintf( buf, "mute" );
	}
	else
	{
		mod = (1<<m)*( 2*l + 33 )- 33;
		mod = mod/8031.0;
		ret = log10( mod );
		ret = ret*20;
		sprintf( buf, "%.2f", ret );
	}

	return buf;
}

void HW_ComOut( int com )
{
	DF( "%02X", com );

	Mixer_Set_Volume( g_VolID, VolMap[ 0x07], 0xFFFF );
	Mixer_Set_Volume( g_VolID, VolMap[ com ], 0xFFFF );
}

void HW_DataOut( int data )
{
	DF( "%02X", data );

	Mixer_Set_Volume( g_VolID, VolMap[ 0xF ],	~VolMap[ data ]	 ); // to avoid same value cache
	Mixer_Set_Volume( g_VolID, 0xFFFF,		VolMap[ data ]	 );
}

void HW_Ready( UINT f )
{
	Mixer_Set_Mute( g_MuteID, f );
}

void HW_RestoreVolume( void )
{
	Mixer_Set_Volume( g_VolID, mx[0].Vols[0], mx[0].Vols[1] );
}

void HW_SendCommand( int com )
{
	HW_Ready( true );
	HW_ComOut( com );
	HW_Ready( false );
}

void HW_AKM_Out( int reg, int data )
{
	HW_Ready( true );

	HW_ComOut( AKM_Chip_Select );

	HW_DataOut( reg );
	HW_DataOut( data );

	HW_ComOut( All_Chip_Disable );

	HW_Ready( false );
}

void HW_AKM_Init( void )
{
	int AKM[] = {
		0xA0,	0x07,
		0xA1,	0x03,
		0xA2,	0x60, //	---> 64KHz,88.2KHz,96Khz :65
		0xA3,	0x19,
		0xA4,	0x7F,
		0xA5,	0x7F,
		0xA6,	0x7F,
		0xA7,	0x7F
	};

	int s = sizeof( AKM )/sizeof( AKM[0] );

	HW_Ready( true );

	for(int i=0; i<s; i+=2 )
	{
		HW_ComOut( AKM_Chip_Select );

		HW_DataOut( AKM[i+0] );
		HW_DataOut( AKM[i+1] );

		HW_ComOut( All_Chip_Disable );
	}

	HW_Ready( false );
}

void HW_CS8420_Out( int *p, int len )
{
	int i;

	HW_Ready( true );

	for(i=0; i<len; i+=2 )
	{
		HW_ComOut( CS8420_Chip_Select );

		HW_DataOut( 0x20 );
		HW_DataOut( *p++ );
		HW_DataOut( *p++ );

		HW_ComOut( All_Chip_Disable );
	}

	HW_Ready( false );
}

void HW_CS8420_Init( void )
{
	int CS1[] = {
		0x04,	0x00,
		0x04,	0x40,
		0x01,	0x00,
		0x02,	0x00
	};

	int CS2[] = {
		0x03,	0x0d,
		0x04,	0x41,
		0x05,	0x05,
		0x06,	0x05
	};

	int s;

	s = sizeof( CS1 )/sizeof( CS1[0] );
	HW_CS8420_Out( CS1, s );

	// delay 100 ms
	DWORD Start = timeGetTime();
	while( timeGetTime()-Start < 100 );

	s = sizeof( CS2 )/sizeof( CS2[0] );
	HW_CS8420_Out( CS2, s );
}

void HW_CS8420_Sample_Rate_Converter( int f )
{
	int CS0[] = {
		0x03,	0x0d//	- Off
	};

	int CS1[] = {
		0x03,	0x09//	- On
	};

	int s = sizeof( CS0 )/sizeof( CS0[0] );
	HW_CS8420_Out( f==1 ? CS1 : CS0, s );
}

void HW_CS8420_Pro_Consumer(void)
{

	int Consum[] = {
		18,	0x1c,
		19,	0x03,
		32,	0x20,
		33,	0x00,
		34,	0x00,
		35,	0x00,
		36,	0x00,
		37,	0x00,
		38,	0x00,
		39,	0x00,
		40,	0x00,
		41,	0x00,
		42,	0x00,
		43,	0x00,
		44,	0x00,
		45,	0x00,
		46,	0x00,
		47,	0x00,
		48,	0x00,
		49,	0x00,
		50,	0x00,
		51,	0x00,
		52,	0x00,
		53,	0x00,
		54,	0x00,
		55,	0x00
	};

	int Pro[] = {
		18,	0x1c,
		19,	0x03,
		32,	0x20,
		33,	0x40,
		34,	0x34,
		35,	0x00,
		36,	0x00,
		37,	0x00,
		38,	0x00,
		39,	0x00,
		40,	0x00,
		41,	0x00,
		42,	0x00,
		43,	0x00,
		44,	0x00,
		45,	0x00,
		46,	0x00,
		47,	0x00,
		48,	0x00,
		49,	0x00,
		50,	0x00,
		51,	0x00,
		52,	0x00,
		53,	0x00,
		54,	0x07,
		55,	0x00
	};

	if( mx[0].Pro )
	{
		switch( mx[0].Freq )
		{
		case 0 : Pro[2] = 0x83; break; // 32k
		case 1 : Pro[2] = 0x82; break; // 44.1k
		case 2 : Pro[2] = 0x81; break; // 48k
		}
	}
	else
	{
		switch( mx[0].Freq )
		{
		case 0 : Consum[11] = 0xC0; break; // 32k
		case 1 : Consum[11] = 0x00; break; // 44.1k
		case 2 : Consum[11] = 0x40; break; // 48k
		}
	}

	if( mx[0].Pro )
	{
		HW_SendCommand( CS8420_Professional_Mode );
	}
	else
	{
		HW_SendCommand( CS8420_Consumer_Mode );
	}

}

///////////////////
int FPGAREG[2];  // static
///////////////////

void HW_FPGA_Out( int reg, int mask, int data )
{
	HW_Ready( true );

	HW_ComOut( FPGA_Control_Data_Chip_Select );

	HW_DataOut( 0xE0+reg );

	int outdata = (FPGAREG[ reg ] & ~mask ) | data;
	
	FPGAREG[ reg ] = outdata;

	HW_DataOut( outdata );

	HW_ComOut( All_Chip_Disable );

	HW_Ready( false );
}


void HW_Set( int id, int _O )
{
	switch( id&0x0FF0 )
	{
	case ID_Vols		: 
		switch( id&0xF )
		{
		case 0: HW_AKM_Out( 0xA4, mx[0].Vols[0] ); break; // left in
		case 1: HW_AKM_Out( 0xA5, mx[0].Vols[1] ); break; // right in
		case 2: HW_AKM_Out( 0xA6, mx[0].Vols[2] ); break; // left out
		case 3: HW_AKM_Out( 0xA7, mx[0].Vols[3] ); break; // right out
		}
		break;
	case ID_VolNum		: break;
	case ID_Gang		: break;
	case ID_Freq		: 
		switch( mx[0].Freq )
		{
		case 0: HW_SendCommand( Fs_32KHz ); break; // 32khz
		case 1: HW_SendCommand( Fs_441KHz ); break; // 44.1khz
		case 2: HW_SendCommand( Fs_48KHz ); break; // 48khz
		}
		break;
	case ID_AutoFreq	: 
		switch( mx[0].AutoFreq )
		{
		case 0: HW_SendCommand( Fs_Auto_off ); break; // Disable Auto
		case 1: HW_SendCommand( Fs_Auto_on ); break; // Enable Auto
		}
		break;
	case ID_AnalogMx	: 
		switch( id&0xF )
		{
		case 0: HW_FPGA_Out( 0, BIT4, mx[0].AnalogMx[0]==1 ? BIT4 : 0 ); break; // analog
		case 1: HW_FPGA_Out( 0, BIT5, mx[0].AnalogMx[1]==1 ? BIT5 : 0 ); break; // digital
		case 2: HW_FPGA_Out( 0, BIT6, mx[0].AnalogMx[2]==1 ? BIT6 : 0 ); break; // wave out
		}
		break;
	case ID_DigitalMx	: 
		switch( id&0xF )
		{
		case 0: HW_FPGA_Out( 0, BIT0, mx[0].DigitalMx[0]==1 ? BIT0 : 0 ); break; // analog
		case 1: HW_FPGA_Out( 0, BIT1, mx[0].DigitalMx[1]==1 ? BIT1 : 0 ); break; // analog
		case 2: HW_FPGA_Out( 0, BIT2, mx[0].DigitalMx[2]==1 ? BIT2: 0 ); break; // analog
		}
		break;
	case ID_Outmix		: 
		HW_FPGA_Out( 0, BIT7|BIT3, mx[0].Outmix==1 ? BIT7|BIT3 : 0 ); 
		break;
	case ID_Pro			: 
		HW_CS8420_Pro_Consumer();
		break;

	case ID_ClockSrc	: 
		HW_FPGA_Out( 1, BIT7|BIT5, mx[0].ClockSrc==1 ? BIT7|BIT5 : 0 ); 
		break;

	case ID_InputSrcA	: 
		{
		int data = 0;
		data |= (mx[0].InputSrcA==0 ? 0 : BIT4); //100
		data |= (mx[0].InputSrcA==0 ? LED_RED : 0); 
		HW_FPGA_Out( 1, BIT4|LED_RED, data );
		}
		break;

	case ID_InputSrcD	: 
		{
		int data = 0;
		data |= (mx[0].InputSrcD==0 ? 0 : BIT3); //010 
		data |= (mx[0].InputSrcD==1 ? 0 : BIT2); //001
		HW_FPGA_Out( 1, BIT3|BIT2, data );
		}
		break;
	}
}

LRESULT Do_VSCROLL(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//UINT    nPos = (UINT) HIWORD(wParam);  // scroll box position 
	LONG    _ID =GetWindowLong( (HWND)lParam, GWL_ID );
	int		x   = _ID&0xF ;
	int		_O  = (_ID&0xF000) >> 12;
	int		nPos= Get_Pos( (HWND)lParam );

	mx[0].Vols[ x ]=nPos;

	if(mx[0].Gang)
	{
		int y = x&1 ? x-1:x+1;
		mx[0].Vols[ y ]=nPos;
		Set_Pos( Panel[_O]->Vols[y], mx[0].Vols[ y ] );
		HW_Set( (_ID&0xFFF0)+y, _O );
	}
	
	Set_Pos( Panel[_O]->Vols[x], mx[0].Vols[ x ] );
	Set_Text( Panel[_O]->VolNum[x/2], Get_AkmDB( mx[_O].Vols[x] ) );
	
	HW_Set( _ID, _O );

	return 0;
}

LRESULT Do_COMMAND (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int		_ID     = LOWORD(wParam); 
	int		wNotify = HIWORD(wParam); 
	HWND    hWndBtn = (HWND) lParam;  
	int		card	= (_ID&0xF000)>>12;
	LONG	ret		= SendMessage( hWndBtn, BM_GETCHECK, 0, 0 );
	int		x		= _ID&0xF;
	
	switch( _ID&0xFF0 )
	{
	case ID_Gang	: mx[card].Gang=ret; break;
	case ID_Freq	: mx[card].AutoFreq=0; mx[card].Freq=x;
						Panel_DisPlay( ID_Freq, card); HW_Set( ID_AutoFreq, card ); HW_Set( _ID, card ); break;
	case ID_AutoFreq: mx[card].AutoFreq=ret; 
						Panel_DisPlay( ID_AutoFreq, card); HW_Set( _ID, card ); break;
	case ID_AnalogMx: mx[card].AnalogMx[x]=ret; 
						Panel_DisPlay( ID_AnalogMx, card); HW_Set( _ID, card ); break;
	case ID_DigitalMx: mx[card].DigitalMx[x]=ret; 
						Panel_DisPlay( ID_DigitalMx, card); HW_Set( _ID, card ); break;
	case ID_Outmix	: mx[card].Outmix=x; 
						Panel_DisPlay( ID_Outmix, card); HW_Set( _ID, card ); break;
	case ID_Pro		: mx[card].Pro=x; 
						Panel_DisPlay( ID_Pro, card); HW_Set( _ID, card ); break;
	case ID_ClockSrc: mx[card].ClockSrc=x; 
						Panel_DisPlay( ID_ClockSrc, card); HW_Set( _ID, card ); break;
	case ID_InputSrcA: mx[card].InputSrcA=x; 
						Panel_DisPlay( ID_InputSrcA, card); HW_Set( _ID, card ); break;
	case ID_InputSrcD: mx[card].InputSrcD=x; 
						Panel_DisPlay( ID_InputSrcD, card); HW_Set( _ID, card ); break;
	}

	return 0;
}

void Panel_DisPlay(int id, int _O)
{
	int x = id&0xF ;

	/*
	mx[_O].ClockSrc Will Stop / Start 4 buttons together,

	AnalogMx[2] 
	DigitalMx[2]
	InputSrcA[0]
	InputSrcA[1]
	*/

	switch ( id&0xFF0 )
	{
	case ID_Vols		: 
		Set_Pos(  Panel[_O]->Vols[x], mx[_O].Vols[x] );
		Set_Text( Panel[_O]->VolNum[x/2], Get_AkmDB( mx[_O].Vols[x] ) );			break;
	case ID_Gang		:
		Set_TogleCheck( Panel[_O]->Gang, mx[_O].Gang );
	case ID_Freq		:
	case ID_AutoFreq	:
		Set_TogleCheck( Panel[_O]->Freq[0], mx[_O].AutoFreq==1?0:mx[_O].Freq==0?1:0 );
		Set_TogleCheck( Panel[_O]->Freq[1], mx[_O].AutoFreq==1?0:mx[_O].Freq==1?1:0 );
		Set_TogleCheck( Panel[_O]->Freq[2], mx[_O].AutoFreq==1?0:mx[_O].Freq==2?1:0 );
		Set_TogleCheck( Panel[_O]->AutoFreq, mx[_O].AutoFreq==1?1:0 ); break;
	case ID_AnalogMx	:
		Set_TogleCheck( Panel[_O]->AnalogMx[0], mx[_O].AnalogMx[0]==1?1:0 );
		Set_TogleCheck( Panel[_O]->AnalogMx[1], mx[_O].AnalogMx[1]==1?1:0 );
		if(!mx[_O].ClockSrc) Set_TogleCheck( Panel[_O]->AnalogMx[2], mx[_O].AnalogMx[2]==1?1:0 ); break;
	case ID_DigitalMx	:
		Set_TogleCheck( Panel[_O]->DigitalMx[0], mx[_O].DigitalMx[0]==1?1:0 );
		Set_TogleCheck( Panel[_O]->DigitalMx[1], mx[_O].DigitalMx[1]==1?1:0 );
		if(!mx[_O].ClockSrc) Set_TogleCheck( Panel[_O]->DigitalMx[2], mx[_O].DigitalMx[2]==1?1:0 ); break;
	case ID_Outmix	: 
		Set_TogleCheck( Panel[_O]->Outmix[0], mx[_O].Outmix==0?1:0 );
		Set_TogleCheck( Panel[_O]->Outmix[1], mx[_O].Outmix==1?1:0 ); break;
	case ID_Pro		: 
		Set_TogleCheck( Panel[_O]->Pro[0], mx[_O].Pro==0?1:0 );
		Set_TogleCheck( Panel[_O]->Pro[1], mx[_O].Pro==1?1:0 ); break;

	case ID_ClockSrc		: 
		Set_TogleCheck( Panel[_O]->ClockSrc[0], mx[_O].ClockSrc==0?1:0 );
		Set_TogleCheck( Panel[_O]->ClockSrc[1], mx[_O].ClockSrc==1?1:0 ); 
		/**/
		Set_TogleCheck( Panel[_O]->AnalogMx[2],  mx[_O].ClockSrc==1 ? 0 : mx[_O].AnalogMx[2]==1?1:0 );
		Set_TogleCheck( Panel[_O]->DigitalMx[2], mx[_O].ClockSrc==1 ? 0 : mx[_O].DigitalMx[2]==1?1:0 );
		Set_TogleCheck( Panel[_O]->InputSrcA[0], mx[_O].ClockSrc==1 ? 0 : mx[_O].InputSrcA==0?1:0 );	
		Set_TogleCheck( Panel[_O]->InputSrcA[1], mx[_O].ClockSrc==1 ? 0 : mx[_O].InputSrcA==1?1:0 );
		ShowWindow( Panel[_O]->AnalogMx[2]	, !mx[_O].ClockSrc );
		ShowWindow( Panel[_O]->DigitalMx[2]	, !mx[_O].ClockSrc );
		ShowWindow( Panel[_O]->InputSrcA[0]	, !mx[_O].ClockSrc );
		ShowWindow( Panel[_O]->InputSrcA[1]	, !mx[_O].ClockSrc );
		/**/
		break;

	case ID_InputSrcA: 
		Set_TogleCheck( Panel[_O]->InputSrcA[0], mx[_O].InputSrcA==0?1:0 );	
		Set_TogleCheck( Panel[_O]->InputSrcA[1], mx[_O].InputSrcA==1?1:0 ); break;
	case ID_InputSrcD: 
		Set_TogleCheck( Panel[_O]->InputSrcD[0], mx[_O].InputSrcD==0?1:0 );	
		Set_TogleCheck( Panel[_O]->InputSrcD[1], mx[_O].InputSrcD==1?1:0 ); break;
	}
}

void Display_init( int _O )
{
	SystemMixerInit();

	Panel_DisPlay(ID_Vols+0, _O);
	Panel_DisPlay(ID_Vols+1, _O);
	Panel_DisPlay(ID_Vols+2, _O);
	Panel_DisPlay(ID_Vols+3, _O);

	Panel_DisPlay(ID_Gang, _O);

	Panel_DisPlay(ID_Freq, _O);
	Panel_DisPlay(ID_AnalogMx, _O);
	Panel_DisPlay(ID_DigitalMx, _O);
	Panel_DisPlay(ID_Outmix, _O);
	Panel_DisPlay(ID_Pro, _O);
	Panel_DisPlay(ID_InputSrcA, _O);
	Panel_DisPlay(ID_InputSrcD, _O);
	Panel_DisPlay(ID_ClockSrc, _O);
}

void HW_Init( int _O )
{
	FPGAREG[0]=FPGAREG[1]=0;
	
	HW_FPGA_Out( 1, LED_GREEN, LED_GREEN ); 

	HW_Set( ID_Vols+0, _O );
	HW_Set( ID_Vols+1, _O );
	HW_Set( ID_Vols+2, _O );
	HW_Set( ID_Vols+3, _O );

	HW_Set( ID_AutoFreq, _O ); 
	HW_Set( ID_Freq, _O ); 
	HW_Set( ID_AnalogMx+0, _O ); 
	HW_Set( ID_AnalogMx+1, _O ); 
	HW_Set( ID_AnalogMx+2, _O ); 
	HW_Set( ID_DigitalMx+0, _O ); 
	HW_Set( ID_DigitalMx+1, _O ); 
	HW_Set( ID_DigitalMx+2, _O ); 
	HW_Set( ID_Outmix, _O ); 
	HW_Set( ID_Pro, _O ); 
	HW_Set( ID_ClockSrc, _O ); 
	HW_Set( ID_InputSrcA, _O ); 
	HW_Set( ID_InputSrcD, _O ); 
}



